/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.raster;

import com.sun.jimi.core.ImageAccessException;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.raster.MemoryIntRasterImage;
import com.sun.jimi.core.vmem.IntPageMapper;
import com.sun.jimi.util.RandomAccessStorage;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.io.IOException;

public class VMemIntRasterImage
extends MemoryIntRasterImage {
    protected IntPageMapper pageMapper;
    int[] pixelBuf = new int[1];

    protected void initStorage() throws JimiException {
    }

    public void getRectangleRGB(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) throws ImageAccessException {
        if (this.rowBuf == null) {
            this.rowBuf = new int[n3];
        }
        int n7 = 0;
        while (n7 < n4) {
            this.getRow(n2 + n7, this.rowBuf, 0);
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            while (n10 < n3) {
                nArray[n7 * n6 + n9++ + n5] = this.colorModel.getRGB(this.rowBuf[n8++]);
                ++n10;
            }
            ++n7;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getRectangle(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) throws ImageAccessException {
        try {
            this.pageMapper.getRectangle(n, n2, n3, n4, nArray, n5, n6);
            return;
        }
        catch (IOException iOException) {
            throw new ImageAccessException(iOException.getMessage());
        }
    }

    public synchronized int getPixel(int n, int n2) throws ImageAccessException {
        this.getRectangle(n, n2, 1, 1, this.pixelBuf, 0, 0);
        return this.pixelBuf[0];
    }

    public int getPixelRGB(int n, int n2) throws ImageAccessException {
        return this.colorModel.getRGB(this.getPixel(n, n2));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void storeRectangle(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) throws ImageAccessException {
        this.setModified();
        try {
            this.pageMapper.setRectangle(n, n2, n3, n4, nArray, n5, n6);
            return;
        }
        catch (IOException iOException) {
            throw new ImageAccessException(iOException.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void storeChannelRectangle(int n, int n2, int n3, int n4, int n5, byte[] byArray, int n6, int n7) throws ImageAccessException {
        this.setModified();
        try {
            this.pageMapper.setChannelRectangle(n, n2, n3, n4, n5, byArray, n6, n7);
            return;
        }
        catch (IOException iOException) {
            throw new ImageAccessException(iOException.getMessage());
        }
    }

    public synchronized void storePixel(int n, int n2, int n3) throws ImageAccessException {
        this.pixelBuf[0] = n3;
        this.setRectangle(n, n2, 0, 0, this.pixelBuf, 0, 0);
    }

    protected void sendToConsumerFully(ImageConsumer imageConsumer) throws ImageAccessException {
        int n = this.pageMapper.getPageDimensions().height;
        int[] nArray = new int[this.getWidth() * n];
        int n2 = this.getHeight();
        int n3 = this.getWidth();
        int n4 = 0;
        ColorModel colorModel = this.getColorModel();
        while (n4 < n2) {
            int n5 = Math.min(n, n2 - n4);
            this.getRectangle(0, n4, n3, n5, nArray, 0, n3);
            imageConsumer.setPixels(0, n4, n3, n5, this.colorModel, nArray, 0, n3);
            n4 += n5;
        }
    }

    protected void sendRegionToConsumerFully(ImageConsumer imageConsumer, Rectangle rectangle) throws ImageAccessException {
        int n = this.pageMapper.getPageDimensions().height;
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        ColorModel colorModel = this.getColorModel();
        int n6 = this.getWidth() * n / n4;
        n6 = Math.max(1, n6);
        int[] nArray = new int[n4 * n6];
        int n7 = 0;
        while (n7 < n5) {
            int n8 = Math.min(n6, n5 - n7);
            this.getRectangle(n2, n7 + n3, n4, n8, nArray, 0, n4);
            imageConsumer.setPixels(0, n7, n4, n8, colorModel, nArray, 0, n4);
            n7 += n8;
        }
    }

    public int[] asIntArray() {
        return null;
    }

    public VMemIntRasterImage(RandomAccessStorage randomAccessStorage, int n, int n2, ColorModel colorModel) throws JimiException {
        super(n, n2, colorModel);
        this.pageMapper = new IntPageMapper(randomAccessStorage, new Dimension(n, n2), 2048);
    }
}

