/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util;

class InverseColorMap {
    static final int QUANTBITS = 5;
    static final int TRUNCBITS = 3;
    static final int QUANTMASK_BLUE = 31;
    static final int QUANTMASK_GREEN = 992;
    static final int QUANTMASK_RED = 31744;
    static final int MAXQUANTVAL = 32;
    byte[] rgbCMap_;
    int numColors_;
    int maxColor_;
    byte[] irgb_;

    void initIRGB(int[] nArray) {
        int n = 8;
        int n2 = 64;
        int n3 = n2 + n2;
        byte[] byArray = this.irgb_;
        int n4 = 0;
        while (n4 < this.numColors_) {
            int n5 = this.rgbCMap_[n4 * 4] & 0xFF;
            int n6 = this.rgbCMap_[n4 * 4 + 1] & 0xFF;
            int n7 = this.rgbCMap_[n4 * 4 + 2] & 0xFF;
            int n8 = n5 - n / 2;
            int n9 = n6 - n / 2;
            int n10 = n7 - n / 2;
            n8 = n8 * n8 + n9 * n9 + n10 * n10;
            int n11 = 2 * (n2 - (n5 << 3));
            int n12 = 2 * (n2 - (n6 << 3));
            int n13 = 2 * (n2 - (n7 << 3));
            int n14 = 0;
            int n15 = 0;
            int n16 = n11;
            while (n15 < 32) {
                int n17 = 0;
                n9 = n8;
                int n18 = n12;
                while (n17 < 32) {
                    int n19 = 0;
                    n10 = n9;
                    int n20 = n13;
                    while (n19 < 32) {
                        if (n4 == 0 || nArray[n14] > n10) {
                            nArray[n14] = n10;
                            byArray[n14] = (byte)n4;
                        }
                        n10 += n20;
                        ++n19;
                        ++n14;
                        n20 += n3;
                    }
                    n9 += n18;
                    ++n17;
                    n18 += n3;
                }
                n8 += n16;
                ++n15;
                n16 += n3;
            }
            ++n4;
        }
    }

    public final int getIndexNearest(int n) {
        return this.irgb_[(n >> 9 & 0x7C00) + (n >> 6 & 0x3E0) + (n >> 3 & 0x1F)] & 0xFF;
    }

    public final int getIndexNearest(int n, int n2, int n3) {
        return this.irgb_[(n << 7 & 0x7C00) + (n2 << 2 & 0x3E0) + (n3 >> 3 & 0x1F)] & 0xFF;
    }

    InverseColorMap(byte[] byArray) {
        this.rgbCMap_ = byArray;
        this.numColors_ = this.rgbCMap_.length / 4;
        this.irgb_ = new byte[32768];
        this.initIRGB(new int[32768]);
    }
}

