/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util;

import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.MemoryJimiImageFactory;
import com.sun.jimi.core.raster.ByteRasterImage;
import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.util.ColorOctree;
import com.sun.jimi.core.util.FSDither;
import com.sun.jimi.core.util.InverseColorMap;
import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;

public class JimiImageColorReducer {
    ColorOctree octree;
    int maxColors;
    byte[] rgbCMap;
    int numColors;

    public JimiRasterImage colorReduce(ImageProducer imageProducer) throws JimiException {
        return this.colorReduce(Jimi.createRasterImage(imageProducer));
    }

    public JimiRasterImage colorReduce(JimiRasterImage jimiRasterImage) throws JimiException {
        ByteRasterImage byteRasterImage;
        jimiRasterImage.waitFinished();
        ColorModel colorModel = jimiRasterImage.getColorModel();
        if (colorModel instanceof IndexColorModel && ((IndexColorModel)colorModel).getMapSize() <= this.maxColors) {
            return jimiRasterImage;
        }
        if (this.octree != null) {
            this.fillOctree(jimiRasterImage);
            byte[] byArray = new byte[this.maxColors * 4];
            int n = this.octree.getPalette(byArray);
            byteRasterImage = new MemoryJimiImageFactory().createByteRasterImage(jimiRasterImage.getWidth(), jimiRasterImage.getHeight(), new IndexColorModel(8, byArray.length / 4, byArray, 0, true));
            this.fillJimiRasterImage(byArray, n, byteRasterImage, jimiRasterImage);
        } else {
            byteRasterImage = new MemoryJimiImageFactory().createByteRasterImage(jimiRasterImage.getWidth(), jimiRasterImage.getHeight(), new IndexColorModel(8, this.numColors, this.rgbCMap, 0, false));
            this.fillJimiRasterImage(this.rgbCMap, this.numColors, byteRasterImage, jimiRasterImage);
        }
        return byteRasterImage;
    }

    public JimiRasterImage colorReduceFS(ImageProducer imageProducer) throws JimiException {
        return this.colorReduceFS(Jimi.createRasterImage(imageProducer));
    }

    public JimiRasterImage colorReduceFS(JimiRasterImage jimiRasterImage) throws JimiException {
        ByteRasterImage byteRasterImage;
        jimiRasterImage.waitFinished();
        ColorModel colorModel = jimiRasterImage.getColorModel();
        if (colorModel instanceof IndexColorModel && ((IndexColorModel)colorModel).getMapSize() <= this.maxColors) {
            return jimiRasterImage;
        }
        if (this.octree != null) {
            this.fillOctree(jimiRasterImage);
            byte[] byArray = new byte[this.maxColors * 4];
            int n = this.octree.getPalette(byArray);
            if (this.octree.hasAlpha()) {
                --n;
            }
            byteRasterImage = new MemoryJimiImageFactory().createByteRasterImage(jimiRasterImage.getWidth(), jimiRasterImage.getHeight(), new IndexColorModel(8, this.maxColors, byArray, 0, true));
            this.fillJimiRasterImageFS(byArray, n, byteRasterImage, jimiRasterImage);
        } else {
            byteRasterImage = new MemoryJimiImageFactory().createByteRasterImage(jimiRasterImage.getWidth(), jimiRasterImage.getHeight(), new IndexColorModel(8, this.maxColors, this.rgbCMap, 0, false));
            this.fillJimiRasterImageFS(this.rgbCMap, this.numColors, byteRasterImage, jimiRasterImage);
        }
        return byteRasterImage;
    }

    private void fillJimiRasterImage(byte[] byArray, int n, ByteRasterImage byteRasterImage, JimiRasterImage jimiRasterImage) throws JimiException {
        int[] nArray = new int[jimiRasterImage.getWidth()];
        InverseColorMap inverseColorMap = new InverseColorMap(byArray);
        byte[] byArray2 = new byte[jimiRasterImage.getWidth()];
        int n2 = 0;
        while (n2 < jimiRasterImage.getHeight()) {
            jimiRasterImage.getRowRGB(n2, nArray, 0);
            int n3 = 0;
            while (n3 < byteRasterImage.getWidth()) {
                int n4;
                if (this.octree != null) {
                    n4 = this.octree.quantizeColor(nArray[n3]);
                    byArray2[n3] = (byte)(n4 / 3);
                } else {
                    n4 = inverseColorMap.getIndexNearest(nArray[n3]);
                    byArray2[n3] = (byte)n4;
                }
                ++n3;
            }
            byteRasterImage.setRow(n2, byArray2, 0);
            ++n2;
        }
        byteRasterImage.setFinished();
    }

    int findIdx(byte[] byArray, int n, int n2) {
        int n3 = (n2 & 0xFF0000) >> 16;
        int n4 = (n2 & 0xFF00) >> 8;
        int n5 = n2 & 0xFF;
        int n6 = 0;
        long l = 2000000000L;
        int n7 = n;
        while (--n7 >= 0) {
            int n8 = byArray[n7 * 3] & 0xFF;
            int n9 = byArray[n7 * 3 + 1] & 0xFF;
            int n10 = byArray[n7 * 3 + 2] & 0xFF;
            long l2 = (n3 - n8) * (n3 - n8) + (n4 - n9) * (n4 - n9) + (n5 - n10) * (n5 - n10);
            if (l2 >= l) continue;
            n6 = n7;
            l = l2;
        }
        return n6;
    }

    private void fillJimiRasterImageFS(byte[] byArray, int n, ByteRasterImage byteRasterImage, JimiRasterImage jimiRasterImage) throws JimiException {
        int[] nArray = new int[jimiRasterImage.getWidth()];
        FSDither fSDither = new FSDither(byArray, n, jimiRasterImage.getWidth());
        byte[] byArray2 = new byte[jimiRasterImage.getWidth()];
        int n2 = 0;
        while (n2 < jimiRasterImage.getHeight()) {
            jimiRasterImage.getRowRGB(n2, nArray, 0);
            fSDither.ditherRow(nArray, byArray2);
            byteRasterImage.setRow(n2, byArray2, 0);
            ++n2;
        }
        byteRasterImage.setFinished();
    }

    private void fillOctree(JimiRasterImage jimiRasterImage) throws JimiException {
        int[] nArray = new int[jimiRasterImage.getWidth()];
        int n = 0;
        while (n < jimiRasterImage.getHeight()) {
            jimiRasterImage.getRowRGB(n, nArray, 0);
            this.octree.addColor(nArray);
            ++n;
        }
    }

    public JimiImageColorReducer(int n) {
        this.maxColors = n;
        this.octree = new ColorOctree(n);
    }

    public JimiImageColorReducer(byte[] byArray, int n) {
        this.rgbCMap = byArray;
        this.numColors = n;
    }

    public JimiImageColorReducer(IndexColorModel indexColorModel) {
        this(indexColorModel, indexColorModel.getMapSize());
    }

    public JimiImageColorReducer(IndexColorModel indexColorModel, int n) {
        this.maxColors = n;
        byte[] byArray = new byte[indexColorModel.getMapSize() * 4];
        this.numColors = indexColorModel.getMapSize();
        byte[] byArray2 = new byte[indexColorModel.getMapSize()];
        byte[] byArray3 = new byte[indexColorModel.getMapSize()];
        byte[] byArray4 = new byte[indexColorModel.getMapSize()];
        byte[] byArray5 = new byte[indexColorModel.getMapSize()];
        indexColorModel.getReds(byArray2);
        indexColorModel.getGreens(byArray3);
        indexColorModel.getBlues(byArray4);
        indexColorModel.getAlphas(byArray5);
        int n2 = 0;
        int n3 = 0;
        while (n3 < byArray2.length) {
            byArray[n2++] = byArray2[n3];
            byArray[n2++] = byArray3[n3];
            byArray[n2++] = byArray4[n3];
            byArray[n2++] = byArray5[n3];
            ++n3;
        }
        this.rgbCMap = byArray;
    }
}

