/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util;

import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LEDataOutputStream
extends FilterOutputStream
implements DataOutput {
    protected int written = 0;

    public synchronized void write(int n) throws IOException {
        this.out.write(n);
        ++this.written;
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
        this.written += n2;
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public final void writeBoolean(boolean bl) throws IOException {
        this.out.write(bl ? 1 : 0);
        ++this.written;
    }

    public final void writeByte(int n) throws IOException {
        this.out.write(n);
        ++this.written;
    }

    public final void writeShort(int n) throws IOException {
        OutputStream outputStream = this.out;
        outputStream.write(n >>> 0 & 0xFF);
        outputStream.write(n >>> 8 & 0xFF);
        this.written += 2;
    }

    public final void writeChar(int n) throws IOException {
        OutputStream outputStream = this.out;
        outputStream.write(n >>> 0 & 0xFF);
        outputStream.write(n >>> 8 & 0xFF);
        this.written += 2;
    }

    public final void writeInt(int n) throws IOException {
        OutputStream outputStream = this.out;
        outputStream.write(n >>> 0 & 0xFF);
        outputStream.write(n >>> 8 & 0xFF);
        outputStream.write(n >>> 16 & 0xFF);
        outputStream.write(n >>> 24 & 0xFF);
        this.written += 4;
    }

    public final void writeLong(long l) throws IOException {
        OutputStream outputStream = this.out;
        outputStream.write((int)(l >>> 0) & 0xFF);
        outputStream.write((int)(l >>> 8) & 0xFF);
        outputStream.write((int)(l >>> 16) & 0xFF);
        outputStream.write((int)(l >>> 24) & 0xFF);
        outputStream.write((int)(l >>> 32) & 0xFF);
        outputStream.write((int)(l >>> 40) & 0xFF);
        outputStream.write((int)(l >>> 48) & 0xFF);
        outputStream.write((int)(l >>> 56) & 0xFF);
        this.written += 8;
    }

    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public final void writeBytes(String string) throws IOException {
        OutputStream outputStream = this.out;
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            outputStream.write((byte)string.charAt(n2));
            ++n2;
        }
        this.written += n;
    }

    public final void writeChars(String string) throws IOException {
        OutputStream outputStream = this.out;
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            outputStream.write(c >>> 8 & 0xFF);
            outputStream.write(c >>> 0 & 0xFF);
            ++n2;
        }
        this.written += n * 2;
    }

    public final void writeUTF(String string) throws IOException {
    }

    public final int size() {
        return this.written;
    }

    public LEDataOutputStream(OutputStream outputStream) {
        super(outputStream);
    }
}

