/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.util.Hashtable;
import java.util.Vector;

public class MulticastImageConsumer
implements ImageConsumer {
    protected int hints_;
    protected ColorModel colorModel_;
    protected int width_;
    protected int height_;
    protected Hashtable properties_;
    private Vector consumers_ = new Vector();
    private ImageConsumer[] consumerCache_;
    private boolean cacheValid_ = false;

    @Override
    public void setDimensions(int n, int n2) {
        this.width_ = n;
        this.height_ = n2;
        ImageConsumer[] imageConsumerArray = this.getConsumers();
        for (int i = 0; i < imageConsumerArray.length; ++i) {
            imageConsumerArray[i].setDimensions(n, n2);
        }
    }

    @Override
    public void setColorModel(ColorModel colorModel) {
        this.colorModel_ = colorModel;
        ImageConsumer[] imageConsumerArray = this.getConsumers();
        for (int i = 0; i < imageConsumerArray.length; ++i) {
            imageConsumerArray[i].setColorModel(colorModel);
        }
    }

    @Override
    public void setHints(int n) {
        this.hints_ = n;
        ImageConsumer[] imageConsumerArray = this.getConsumers();
        for (int i = 0; i < imageConsumerArray.length; ++i) {
            imageConsumerArray[i].setHints(n);
        }
    }

    @Override
    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        ImageConsumer[] imageConsumerArray = this.getConsumers();
        for (int i = 0; i < imageConsumerArray.length; ++i) {
            imageConsumerArray[i].setPixels(n, n2, n3, n4, colorModel, byArray, n5, n6);
        }
    }

    @Override
    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        ImageConsumer[] imageConsumerArray = this.getConsumers();
        for (int i = 0; i < imageConsumerArray.length; ++i) {
            imageConsumerArray[i].setPixels(n, n2, n3, n4, colorModel, nArray, n5, n6);
        }
    }

    @Override
    public void imageComplete(int n) {
        ImageConsumer[] imageConsumerArray = this.getConsumers();
        for (int i = 0; i < imageConsumerArray.length; ++i) {
            imageConsumerArray[i].imageComplete(n);
        }
    }

    public void setProperties(Hashtable hashtable) {
        this.properties_ = hashtable;
        ImageConsumer[] imageConsumerArray = this.getConsumers();
        for (int i = 0; i < imageConsumerArray.length; ++i) {
            imageConsumerArray[i].setProperties(hashtable);
        }
    }

    public synchronized ImageConsumer[] getConsumers() {
        if (!this.cacheValid_) {
            this.consumerCache_ = new ImageConsumer[this.consumers_.size()];
            this.consumers_.copyInto(this.consumerCache_);
            this.cacheValid_ = true;
        }
        return this.consumerCache_;
    }

    public synchronized void addConsumer(ImageConsumer imageConsumer) {
        this.cacheValid_ = false;
        this.consumers_.addElement(imageConsumer);
    }

    public void addConsumers(ImageConsumer[] imageConsumerArray) {
        this.consumers_.ensureCapacity(this.consumers_.size() + imageConsumerArray.length);
        for (int i = 0; i < imageConsumerArray.length; ++i) {
            this.addConsumer(imageConsumerArray[i]);
        }
    }

    public void removeConsumer(ImageConsumer imageConsumer) {
        this.cacheValid_ = false;
        this.consumers_.removeElement(imageConsumer);
    }

    public void removeAll() {
        this.cacheValid_ = false;
        this.consumers_.removeAllElements();
    }

    public boolean isEmpty() {
        return this.consumers_.size() == 0;
    }

    public boolean contains(ImageConsumer imageConsumer) {
        return this.consumers_.contains(imageConsumer);
    }
}

