/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util;

import com.sun.jimi.core.util.OctreeCallback;

public class OctreeNode {
    static boolean debug;
    static int[] levCounts;
    public static int numNodes;
    boolean leaf;
    boolean marked;
    long sumR;
    long sumG;
    long sumB;
    int count;
    OctreeNode r0g0b0;
    OctreeNode r0g0b1;
    OctreeNode r0g1b0;
    OctreeNode r0g1b1;
    OctreeNode r1g0b0;
    OctreeNode r1g0b1;
    OctreeNode r1g1b0;
    OctreeNode r1g1b1;
    int childCount;
    int level;
    int redMask;
    int greenMask;
    int blueMask;
    int pIndex;
    OctreeCallback oc;

    static void dumpLevCounts() {
        String string = "";
        int n = 0;
        while (n < 9) {
            string = string + " " + levCounts[n] + " ";
            ++n;
        }
        System.out.println("levCounts " + string);
    }

    public String toString() {
        String string = "l " + this.leaf;
        string = string + " m " + this.marked;
        string = string + " count " + this.count;
        string = string + " childCount " + this.childCount;
        string = string + " level " + this.level;
        if (this.r0g0b0 != null) {
            string = string + " r0g0b0 ";
        }
        if (this.r0g0b1 != null) {
            string = string + " r0g0b1 ";
        }
        if (this.r0g1b0 != null) {
            string = string + " r0g1b0 ";
        }
        if (this.r0g1b1 != null) {
            string = string + " r0g1b1 ";
        }
        if (this.r1g0b0 != null) {
            string = string + " r1g0b0 ";
        }
        if (this.r1g0b1 != null) {
            string = string + " r1g0b1 ";
        }
        if (this.r1g1b0 != null) {
            string = string + " r1g1b0 ";
        }
        if (this.r1g1b1 != null) {
            string = string + " r1g1b1 ";
        }
        return string;
    }

    public void dump(String string) {
        System.out.println(string + "[" + this.level + "]" + this.toString());
        if (this.r1g1b1 != null) {
            this.r1g1b1.dump(string + "111 ");
        }
        if (this.r1g1b0 != null) {
            this.r1g1b0.dump(string + "110 ");
        }
        if (this.r1g0b1 != null) {
            this.r1g0b1.dump(string + "101 ");
        }
        if (this.r1g0b0 != null) {
            this.r1g0b0.dump(string + "100 ");
        }
        if (this.r0g1b1 != null) {
            this.r0g1b1.dump(string + "011 ");
        }
        if (this.r0g1b0 != null) {
            this.r0g1b0.dump(string + "010 ");
        }
        if (this.r0g0b1 != null) {
            this.r0g0b1.dump(string + "001 ");
        }
        if (this.r0g0b0 != null) {
            this.r0g0b0.dump(string + "000 ");
        }
    }

    void setFields(OctreeCallback octreeCallback, int n) {
        this.count = 0;
        this.sumR = 0L;
        this.sumG = 0L;
        this.sumB = 0L;
        this.level = n;
        this.pIndex = -1;
        this.childCount = 0;
        this.leaf = false;
        this.marked = false;
        this.r1g1b1 = null;
        this.r1g1b0 = null;
        this.r1g0b1 = null;
        this.r1g0b0 = null;
        this.r0g1b1 = null;
        this.r0g1b0 = null;
        this.r0g0b1 = null;
        this.r0g0b0 = null;
        if (n != 8) {
            this.blueMask = 128 >> n;
            this.greenMask = this.blueMask << 8;
            this.redMask = this.greenMask << 8;
        }
        this.oc = octreeCallback;
        int n2 = n;
        levCounts[n2] = levCounts[n2] + 1;
    }

    OctreeNode findChild(int n) {
        if (this.childCount == 0) {
            return this;
        }
        int n2 = n & this.redMask;
        int n3 = n & this.greenMask;
        int n4 = n & this.blueMask;
        if (n2 == 0) {
            if (n3 == 0) {
                if (n4 == 0) {
                    if (this.r0g0b0 != null) {
                        return this.r0g0b0.findChild(n);
                    }
                    return this;
                }
                if (this.r0g0b1 != null) {
                    return this.r0g0b1.findChild(n);
                }
                return this;
            }
            if (n4 == 0) {
                if (this.r0g1b0 != null) {
                    return this.r0g1b0.findChild(n);
                }
                return this;
            }
            if (this.r0g1b1 != null) {
                return this.r0g1b1.findChild(n);
            }
            return this;
        }
        if (n3 == 0) {
            if (n4 == 0) {
                if (this.r1g0b0 != null) {
                    return this.r1g0b0.findChild(n);
                }
                return this;
            }
            if (this.r1g0b1 != null) {
                return this.r1g0b1.findChild(n);
            }
            return this;
        }
        if (n4 == 0) {
            if (this.r1g1b0 != null) {
                return this.r1g1b0.findChild(n);
            }
            return this;
        }
        if (this.r1g1b1 != null) {
            return this.r1g1b1.findChild(n);
        }
        return this;
    }

    int insertColor(int n, int n2) {
        int n3 = 0;
        int n4 = this.level + 1;
        ++this.count;
        this.sumR += (long)((n & 0xFF0000) >> 16);
        this.sumG += (long)((n & 0xFF00) >> 8);
        this.sumB += (long)(n & 0xFF);
        if (!this.leaf) {
            int n5 = n & this.redMask;
            int n6 = n & this.greenMask;
            int n7 = n & this.blueMask;
            if (n5 == 0) {
                if (n6 == 0) {
                    if (n7 == 0) {
                        if (this.r0g0b0 == null) {
                            this.r0g0b0 = this.oc.getONode(this.oc, n4);
                            if (n4 >= n2) {
                                this.r0g0b0.leaf = true;
                                ++n3;
                            }
                            ++this.childCount;
                        }
                        n3 += this.r0g0b0.insertColor(n, n2);
                    } else {
                        if (this.r0g0b1 == null) {
                            this.r0g0b1 = this.oc.getONode(this.oc, n4);
                            if (n4 >= n2) {
                                this.r0g0b1.leaf = true;
                                ++n3;
                            }
                            ++this.childCount;
                        }
                        n3 += this.r0g0b1.insertColor(n, n2);
                    }
                } else if (n7 == 0) {
                    if (this.r0g1b0 == null) {
                        this.r0g1b0 = this.oc.getONode(this.oc, n4);
                        if (n4 >= n2) {
                            this.r0g1b0.leaf = true;
                            ++n3;
                        }
                        ++this.childCount;
                    }
                    n3 += this.r0g1b0.insertColor(n, n2);
                } else {
                    if (this.r0g1b1 == null) {
                        this.r0g1b1 = this.oc.getONode(this.oc, n4);
                        if (n4 >= n2) {
                            this.r0g1b1.leaf = true;
                            ++n3;
                        }
                        ++this.childCount;
                    }
                    n3 += this.r0g1b1.insertColor(n, n2);
                }
            } else if (n6 == 0) {
                if (n7 == 0) {
                    if (this.r1g0b0 == null) {
                        this.r1g0b0 = this.oc.getONode(this.oc, n4);
                        if (n4 >= n2) {
                            this.r1g0b0.leaf = true;
                            ++n3;
                        }
                        ++this.childCount;
                    }
                    n3 += this.r1g0b0.insertColor(n, n2);
                } else {
                    if (this.r1g0b1 == null) {
                        this.r1g0b1 = this.oc.getONode(this.oc, n4);
                        if (n4 >= n2) {
                            this.r1g0b1.leaf = true;
                            ++n3;
                        }
                        ++this.childCount;
                    }
                    n3 += this.r1g0b1.insertColor(n, n2);
                }
            } else if (n7 == 0) {
                if (this.r1g1b0 == null) {
                    this.r1g1b0 = this.oc.getONode(this.oc, n4);
                    if (n4 >= n2) {
                        this.r1g1b0.leaf = true;
                        ++n3;
                    }
                    ++this.childCount;
                }
                n3 += this.r1g1b0.insertColor(n, n2);
            } else {
                if (this.r1g1b1 == null) {
                    this.r1g1b1 = this.oc.getONode(this.oc, n4);
                    if (n4 >= n2) {
                        this.r1g1b1.leaf = true;
                        ++n3;
                    }
                    ++this.childCount;
                }
                n3 += this.r1g1b1.insertColor(n, n2);
            }
            if (this.childCount > 1 && !this.marked) {
                this.oc.markReducible(this);
            }
        }
        return n3;
    }

    int collapseOctree() {
        int n = 0;
        if (this.childCount == 0) {
            return 0;
        }
        if (this.r0g0b0 != null) {
            if (this.r0g0b0.leaf) {
                ++n;
            }
            n += this.r0g0b0.collapseOctree();
            this.oc.cacheONode(this.r0g0b0);
        }
        if (this.r0g0b1 != null) {
            if (this.r0g0b1.leaf) {
                ++n;
            }
            n += this.r0g0b1.collapseOctree();
            this.oc.cacheONode(this.r0g0b1);
        }
        if (this.r0g1b0 != null) {
            if (this.r0g1b0.leaf) {
                ++n;
            }
            n += this.r0g1b0.collapseOctree();
            this.oc.cacheONode(this.r0g1b0);
        }
        if (this.r0g1b1 != null) {
            if (this.r0g1b1.leaf) {
                ++n;
            }
            n += this.r0g1b1.collapseOctree();
            this.oc.cacheONode(this.r0g1b1);
        }
        if (this.r1g0b0 != null) {
            if (this.r1g0b0.leaf) {
                ++n;
            }
            n += this.r1g0b0.collapseOctree();
            this.oc.cacheONode(this.r1g0b0);
        }
        if (this.r1g0b1 != null) {
            if (this.r1g0b1.leaf) {
                ++n;
            }
            n += this.r1g0b1.collapseOctree();
            this.oc.cacheONode(this.r1g0b1);
        }
        if (this.r1g1b0 != null) {
            if (this.r1g1b0.leaf) {
                ++n;
            }
            n += this.r1g1b0.collapseOctree();
            this.oc.cacheONode(this.r1g1b0);
        }
        if (this.r1g1b1 != null) {
            if (this.r1g1b1.leaf) {
                ++n;
            }
            n += this.r1g1b1.collapseOctree();
            this.oc.cacheONode(this.r1g1b1);
        }
        this.r0g0b0 = null;
        this.r0g0b1 = null;
        this.r0g1b0 = null;
        this.r0g1b1 = null;
        this.r1g0b0 = null;
        this.r1g0b1 = null;
        this.r1g1b0 = null;
        this.r1g1b1 = null;
        this.childCount = 0;
        return n;
    }

    final int getColor() {
        int n = (int)(this.sumR / (long)this.count);
        int n2 = (int)(this.sumG / (long)this.count);
        int n3 = (int)(this.sumB / (long)this.count);
        return (n << 16) + (n2 << 8) + n3;
    }

    int createPalette(byte[] byArray, int n) {
        int n2 = 0;
        if (this.leaf) {
            byArray[n] = (byte)(this.sumR / (long)this.count);
            byArray[n + 1] = (byte)(this.sumG / (long)this.count);
            byArray[n + 2] = (byte)(this.sumB / (long)this.count);
            this.pIndex = n;
            n2 += 3;
        }
        if (this.childCount > 0) {
            if (this.r0g0b0 != null) {
                n2 += this.r0g0b0.createPalette(byArray, n + n2);
            }
            if (this.r0g0b1 != null) {
                n2 += this.r0g0b1.createPalette(byArray, n + n2);
            }
            if (this.r0g1b0 != null) {
                n2 += this.r0g1b0.createPalette(byArray, n + n2);
            }
            if (this.r0g1b1 != null) {
                n2 += this.r0g1b1.createPalette(byArray, n + n2);
            }
            if (this.r1g0b0 != null) {
                n2 += this.r1g0b0.createPalette(byArray, n + n2);
            }
            if (this.r1g0b1 != null) {
                n2 += this.r1g0b1.createPalette(byArray, n + n2);
            }
            if (this.r1g1b0 != null) {
                n2 += this.r1g1b0.createPalette(byArray, n + n2);
            }
            if (this.r1g1b1 != null) {
                n2 += this.r1g1b1.createPalette(byArray, n + n2);
            }
        }
        return n2;
    }

    final int quantizeColor(int n) {
        if (this.leaf) {
            return this.pIndex;
        }
        OctreeNode octreeNode = this.findChild(n);
        if (!octreeNode.leaf) {
            debug = true;
            octreeNode = this.findChild(n);
            debug = false;
            if (this.level == 0) {
                this.dump("");
            }
        }
        return this.findChild((int)n).pIndex;
    }

    OctreeNode(OctreeCallback octreeCallback) {
        this(octreeCallback, 0);
    }

    OctreeNode(OctreeCallback octreeCallback, int n) {
        ++numNodes;
        this.setFields(octreeCallback, n);
    }

    static {
        levCounts = new int[9];
        int n = 0;
        while (n < 9) {
            OctreeNode.levCounts[n] = 0;
            ++n;
        }
        numNodes = 0;
    }
}

