/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util;

import com.sun.jimi.core.MemoryJimiImageFactory;
import com.sun.jimi.core.raster.IntRasterImage;
import com.sun.jimi.core.util.JimiUtil;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

public class StampImage {
    public static final int width = 46;
    public static final int height = 30;
    private static IntRasterImage image;
    public static final int[] pixels;
    public static byte[] packedPixels;
    public static int[] palette;
    public static byte[] bytePixels;

    public static IntRasterImage getRasterImage() {
        try {
            if (image != null) {
                return image;
            }
            image = new MemoryJimiImageFactory().createIntRasterImage(46, 30, ColorModel.getRGBdefault());
            image.setRectangle(0, 0, 46, 30, pixels, 0, 46);
            image.setFinished();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return image;
    }

    public static byte[] mapPalette(IndexColorModel indexColorModel) {
        int n;
        int n2 = indexColorModel.getMapSize();
        byte[] byArray = new byte[palette.length];
        int[] nArray = new int[palette.length];
        int[] nArray2 = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray2[n] = indexColorModel.getRGB(n);
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < byArray.length; ++i) {
                if (!StampImage.betterMatch(palette[i], nArray[i], nArray2[n])) continue;
                nArray[i] = nArray2[n];
                byArray[i] = (byte)n;
            }
        }
        return byArray;
    }

    private static boolean betterMatch(int n, int n2, int n3) {
        int n4 = n2;
        int n5 = n3;
        int n6 = n >>> 16 & 0xFF;
        int n7 = n >>> 8 & 0xFF;
        int n8 = n & 0xFF;
        int n9 = StampImage.abs(n6 - (n2 >>> 16 & 0xFF)) + StampImage.abs(n7 - (n2 >>> 8 & 0xFF)) + StampImage.abs(n8 - n2 & 0xFF);
        int n10 = StampImage.abs(n6 - (n3 >>> 16 & 0xFF)) + StampImage.abs(n7 - (n3 >>> 8 & 0xFF)) + StampImage.abs(n8 - n3 & 0xFF);
        return n10 < n9;
    }

    private static final int abs(int n) {
        return n < 0 ? -n : n;
    }

    static {
        pixels = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1049873, -4199745, -7349617, -8399745, -12533952, -12533952, -13583824, -16733696, -16733696, -16733696, -16733696, -16733696, -16733696, -16733696, -15683824, -12533952, -12533952, -9384080, -8399745, -4199745, -1049873, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -4199745, -7349617, -11483824, -14633696, -16733696, -12533952, -10433952, -8399745, -6299745, -4199745, -4199745, -1, -1, -1, -1, -1, -1, -1, -2100001, -4199745, -4199745, -8399745, -9384080, -12533952, -16733696, -14633696, -10433952, -6299745, -1049873, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2100001, -6299745, -11483824, -15683824, -14633696, -10433952, -6299745, -3149873, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -4199745, -7349617, -12533952, -16733696, -11483824, -6299745, -1, -1, -1, -1, -1, -1, -1, -1, -1049873, -6299745, -13583824, -16733696, -12533952, -7349617, -2100001, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1049873, -7349617, -13583824, -15683824, -8399745, -1049873, -1, -1, -1, -1049873, -8399745, -15683824, -12533952, -6299745, -9384080, -10433952, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -4199745, -12533952, -15683824, -1, -1, -5249873, -15683824, -12533952, -4199745, -1, -1, -1049873, -15683824, -2100001, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -13618945, -13618945, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2100001, -1, -10433952, -15683824, -4199745, -1, -1, -1, -1, -1, -8399745, -10433952, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -5263361, -14671617, -10460929, -6316033, -1, -1, -1, -1, -2105345, -8421377, -3158017, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -10433952, -13583824, -1049873, -1, -1, -1, -1, -1, -1, -2100001, -16733696, -1049873, -1, -1, -1, -1, -1, -1, -1, -1, -1, -10460929, -9408257, -5263361, -12566273, -1, -1, -1, -1052673, -13618945, -12566273, -13618945, -1, -1, -1, -1, -2105345, -1, -1, -1, -1, -1, -1, -3186592, -929841, -1, -10433952, -1049873, -1, -1, -1, -1, -1, -1, -1, -1, -10433952, -8399745, -1, -1, -1, -1, -1, -1, -1, -1, -1, -13618945, -4210689, -1052673, -16776961, -1, -1, -1, -9408257, -12566273, -1, -16776961, -1, -1, -1052673, -12566273, -15724289, -9408257, -1, -1, -1, -1, -331793, -3850176, -1925217, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -4199745, -15683824, -1, -1, -1, -1, -2257009, -663585, -1, -1, -1, -16776961, -1052673, -1, -14671617, -4210689, -1, -2105345, -16776961, -2105345, -1, -13618945, -4210689, -1052673, -13618945, -10460929, -1052673, -12566273, -1, -1, -1, -1, -13618945, -4210689, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -13583824, -6299745, -1, -1, -1, -5111808, -2588801, -1, -1, -2105345, -14671617, -1, -1, -11513601, -8421377, -1, -10460929, -10460929, -1, -1, -12566273, -4210689, -9408257, -13618945, -1, -4210689, -12566273, -1, -1, -1, -10460929, -11513601, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -7349617, -12533952, -1, -1, -1, -5263361, -4210689, -1, -1, -4210689, -12566273, -1, -1, -8421377, -11513601, -2105345, -16776961, -2105345, -1, -1, -12566273, -8421377, -15724289, -2105345, -1, -8421377, -10460929, -1, -1, -6316033, -14671617, -1052673, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1049873, -16733696, -2100001, -1, -1, -8421377, -9408257, -1, -1, -7368705, -9408257, -1, -1, -4210689, -13618945, -8421377, -10460929, -1, -1, -1, -12566273, -15724289, -8421377, -1, -1, -13618945, -6316033, -1, -3158017, -16776961, -3158017, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -11483824, -7349617, -1, -1, -4210689, -14671617, -1, -1, -8421377, -8421377, -1, -1, -1052673, -16776961, -15724289, -4210689, -1, -1, -1, -12566273, -15724289, -1052673, -1, -2105345, -16776961, -1052673, -2105345, -15724289, -7368705, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -6299745, -13583824, -1, -1, -1, -16776961, -2105345, -1, -10460929, -6316033, -1, -1, -1, -14671617, -13618945, -1, -1, -1, -1, -13618945, -8421377, -1, -1, -9408257, -10460929, -1052673, -13618945, -10460929, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1049873, -16733696, -2100001, -1, -1, -11513601, -6316033, -1, -12566273, -4210689, -1, -1, -1, -10460929, -7368705, -1, -1, -1, -1, -8421377, -2105345, -1, -1, -15724289, -3158017, -12566273, -13618945, -1052673, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -11483824, -7349617, -1, -1, -7368705, -11513601, -1, -12566273, -4210689, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -7368705, -12566273, -10460929, -13618945, -1052673, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -6299745, -12533952, -1, -1, -2105345, -16776961, -1052673, -15724289, -1, -1, -2039553, -7368705, -1, -1, -5639255, -1, -5263361, -5263361, -1, -1, -1, -10460929, -15724289, -13618945, -1052673, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2100001, -16733696, -1, -1, -1, -12566273, -7368705, -16776961, -1, -1, -5263361, -1, -5263361, -2031648, -2031648, -2105345, -2039553, -6316033, -1, -1, -1, -2105345, -5263361, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -14633696, -4199745, -1, -1, -4210689, -15724289, -16776961, -1, -1, -5263361, -6316033, -1, -5639255, -1, -3815937, -1, -5263361, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -11483824, -7349617, -1, -1, -1, -8421377, -9408257, -1, -1, -3815937, -3815937, -1, -5639255, -1, -1, -5263361, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -8399745, -8399745, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -5639255, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -3149873, -1049873, -1, -1, -1, -1, -1, -1, -6299745, -11483824, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -5639255, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -12533952, -4199745, -1, -1, -1, -1, -1, -1, -4199745, -12533952, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -5639255, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -12533952, -5249873, -1, -1, -1, -1, -1, -1, -4199745, -12533952, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -5639255, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -9384080, -8399745, -1, -1, -1, -1, -1, -1, -7349617, -8399745, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -5639255, -5639255, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -5249873, -14633696, -1, -1, -1, -1, -1, -1, -10433952, -6299745, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -14633696, -6299745, -1, -1, -1, -1, -2100001, -15683824, -1049873, -1, -1, -1, -1, -1, -1, -1, -1, -546391, -1, -1, -1, -1, -14907, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -4199745, -16733696, -7349617, -1049873, -1, -5249873, -14633696, -5249873, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -546391, -546391, -546391, -546391, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -3149873, -11483824, -16733696, -16733696, -11483824, -3149873, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        try {
            int n = 6;
            packedPixels = new byte[n * 30];
            for (int i = 0; i < 30; ++i) {
                JimiUtil.packPixels(pixels, i * 46, packedPixels, i * n, 46);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        palette = new int[]{-15132161, -10592513, -15683824, -12533952, -9909144, -5111808, -3850176, -3186592, -2588801, -5460737, -5708376, -2257009, -1925217, -546391, -131586};
        bytePixels = new byte[]{14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 10, 10, 4, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 4, 4, 10, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 10, 10, 4, 2, 2, 3, 4, 4, 10, 10, 10, 14, 14, 14, 14, 14, 14, 14, 14, 10, 10, 4, 4, 3, 2, 2, 4, 10, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 10, 4, 2, 2, 4, 10, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 10, 10, 3, 2, 4, 10, 14, 14, 14, 14, 14, 14, 14, 14, 14, 10, 2, 2, 3, 10, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 10, 2, 2, 4, 14, 14, 14, 14, 14, 4, 2, 3, 10, 4, 4, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 10, 3, 2, 14, 14, 10, 2, 3, 10, 14, 14, 14, 2, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 0, 0, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 4, 2, 10, 14, 14, 14, 14, 14, 4, 4, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 9, 0, 1, 9, 14, 14, 14, 14, 14, 1, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 4, 2, 14, 14, 14, 14, 14, 14, 14, 14, 2, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 1, 1, 9, 1, 14, 14, 14, 14, 0, 1, 0, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 7, 14, 14, 4, 14, 14, 14, 14, 14, 14, 14, 14, 14, 4, 4, 14, 14, 14, 14, 14, 14, 14, 14, 14, 0, 9, 14, 0, 14, 14, 14, 1, 1, 14, 0, 14, 14, 14, 1, 0, 1, 14, 14, 14, 14, 14, 6, 12, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 10, 2, 14, 14, 14, 14, 11, 14, 14, 14, 14, 0, 14, 14, 0, 9, 14, 14, 0, 14, 14, 0, 9, 14, 0, 1, 14, 1, 14, 14, 14, 14, 0, 9, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 2, 10, 14, 14, 14, 5, 8, 14, 14, 14, 0, 14, 14, 1, 1, 14, 1, 1, 14, 14, 1, 9, 1, 0, 14, 9, 1, 14, 14, 14, 1, 1, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 10, 3, 14, 14, 14, 9, 9, 14, 14, 9, 1, 14, 14, 1, 1, 14, 0, 14, 14, 14, 1, 1, 0, 14, 14, 1, 1, 14, 14, 9, 0, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 2, 14, 14, 14, 1, 1, 14, 14, 9, 1, 14, 14, 9, 0, 1, 1, 14, 14, 14, 1, 0, 1, 14, 14, 0, 9, 14, 14, 0, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 4, 10, 14, 14, 9, 0, 14, 14, 1, 1, 14, 14, 14, 0, 0, 9, 14, 14, 14, 1, 0, 14, 14, 14, 0, 14, 14, 0, 9, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 10, 2, 14, 14, 14, 0, 14, 14, 1, 9, 14, 14, 14, 0, 0, 14, 14, 14, 14, 0, 1, 14, 14, 1, 1, 14, 0, 1, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 2, 14, 14, 14, 1, 9, 14, 1, 9, 14, 14, 14, 1, 9, 14, 14, 14, 14, 1, 14, 14, 14, 0, 14, 1, 0, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 4, 10, 14, 14, 9, 1, 14, 1, 9, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 9, 1, 1, 0, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 10, 3, 14, 14, 14, 0, 14, 0, 14, 14, 14, 9, 14, 14, 10, 14, 9, 9, 14, 14, 14, 1, 0, 0, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 2, 14, 14, 14, 1, 9, 0, 14, 14, 9, 14, 9, 14, 14, 14, 14, 9, 14, 14, 14, 14, 9, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 2, 10, 14, 14, 9, 0, 0, 14, 14, 9, 9, 14, 10, 14, 14, 14, 9, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 4, 10, 14, 14, 14, 1, 1, 14, 14, 14, 14, 14, 10, 14, 14, 9, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 4, 4, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 10, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 10, 4, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 10, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 3, 10, 14, 14, 14, 14, 14, 14, 10, 3, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 10, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 3, 10, 14, 14, 14, 14, 14, 14, 10, 3, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 10, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 4, 4, 14, 14, 14, 14, 14, 14, 10, 4, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 10, 10, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 10, 2, 14, 14, 14, 14, 14, 14, 4, 10, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 2, 10, 14, 14, 14, 14, 14, 2, 14, 14, 14, 14, 14, 14, 14, 14, 14, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 10, 2, 10, 14, 14, 10, 2, 10, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 4, 2, 2, 4, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14};
    }
}

