/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.util.lzw;

import com.sun.jimi.core.util.lzw.BitInput;
import com.sun.jimi.core.util.lzw.LZWDecompressionStringTable;
import java.io.IOException;
import java.io.InputStream;

public final class LZWDecompressor {
    private int CLEAR_CODE;
    private int END_OF_INPUT;
    protected BitInput input_;
    protected int initialCodeSize_;
    protected int codeSize_;
    protected int limit_;
    protected boolean tiff_;
    protected LZWDecompressionStringTable table_;
    protected int count_;
    protected int oldCode_;
    protected byte oldCodeFirstChar_;
    protected int leftOverCode_;
    protected int leftOverIndex_;
    protected int leftOverOldCode_;
    protected boolean isLeftOver_;

    public void setInputStream(InputStream inputStream) {
        this.input_ = new BitInput(inputStream, !this.tiff_);
        this.clearTable();
        this.resetCodeSize();
    }

    public int decompress(byte[] byArray) throws IOException {
        int n = 0;
        int n2 = this.writeLeftOver(byArray);
        if (this.isLeftOver_) {
            return byArray.length;
        }
        n += n2;
        while (n < byArray.length) {
            int n3;
            int n4;
            int n5 = this.getNextCode();
            if (n5 == this.END_OF_INPUT) break;
            if (n5 == this.CLEAR_CODE) {
                this.clearTable();
                n5 = this.getNextCode();
                if (n5 == this.END_OF_INPUT) break;
                byArray[n++] = (byte)n5;
                this.oldCode_ = n5;
                this.oldCodeFirstChar_ = (byte)n5;
                continue;
            }
            if (this.table_.contains(n5)) {
                n4 = this.writeCode(byArray, n, n5);
                n3 = this.table_.addCharString(this.oldCode_, byArray[n]);
                if (n3 == this.limit_) {
                    this.incrementCodeSize();
                }
                this.oldCode_ = n5;
                this.oldCodeFirstChar_ = byArray[n];
                if (n4 < 0) {
                    return byArray.length;
                }
                n += n4;
                continue;
            }
            n4 = this.table_.addCharString(this.oldCode_, this.oldCodeFirstChar_);
            n3 = this.writeCode(byArray, n, n4);
            this.oldCode_ = n5;
            this.oldCodeFirstChar_ = byArray[n];
            if (n4 == this.limit_) {
                this.incrementCodeSize();
            }
            if (n3 < 0) {
                return byArray.length;
            }
            n += n3;
        }
        return n;
    }

    protected int writeCode(byte[] byArray, int n, int n2) {
        return this.writeCode(byArray, n, n2, 0);
    }

    protected int writeCode(byte[] byArray, int n, int n2, int n3) {
        int n4 = this.table_.expandCode(byArray, n, n2, n3);
        if (n4 < 0) {
            this.leftOverCode_ = n2;
            this.leftOverOldCode_ = this.oldCode_;
            this.isLeftOver_ = true;
            this.leftOverIndex_ = -n4;
        } else {
            this.isLeftOver_ = false;
        }
        return n4;
    }

    protected int writeLeftOver(byte[] byArray) {
        if (!this.isLeftOver_) {
            return 0;
        }
        int n = this.writeCode(byArray, 0, this.leftOverCode_, this.leftOverIndex_);
        return n;
    }

    protected int getNextCode() throws IOException {
        int n = this.input_.read();
        return n;
    }

    protected void clearTable() {
        this.table_.clearTable();
        this.resetCodeSize();
    }

    protected void resetCodeSize() {
        this.count_ = 0;
        this.codeSize_ = this.initialCodeSize_;
        this.incrementCodeSize();
    }

    protected void incrementCodeSize() {
        if (this.codeSize_ != 12) {
            ++this.codeSize_;
            this.limit_ = (1 << this.codeSize_) - 1;
            if (this.tiff_) {
                --this.limit_;
            }
            this.input_.setNumBits(this.codeSize_);
        }
    }

    public void gifFinishBlocks() throws IOException {
        if (!this.tiff_) {
            this.input_.gifFinishBlocks();
        }
    }

    public LZWDecompressor(InputStream inputStream, int n, boolean bl) {
        this.initialCodeSize_ = n;
        this.tiff_ = bl;
        this.CLEAR_CODE = 1 << n;
        this.END_OF_INPUT = (1 << n) + 1;
        this.table_ = new LZWDecompressionStringTable(n);
        this.setInputStream(inputStream);
        this.clearTable();
    }
}

