/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.vmem;

import com.sun.jimi.core.vmem.BytePageFrame;
import com.sun.jimi.core.vmem.PageFrame;
import com.sun.jimi.core.vmem.PageMapper;
import com.sun.jimi.util.RandomAccessStorage;
import java.awt.Dimension;
import java.io.IOException;

public class BytePageMapper
extends PageMapper {
    protected static final int SIZEOF_BYTE = 1;
    protected BytePageFrame[] pageFrames;
    protected int width;
    protected int height;
    protected int pageWidth;
    protected int pageHeight;
    protected int widthInPages;
    protected int heightInPages;

    public byte getPixel(int n, int n2) throws IOException {
        int n3 = this.getLogicalPageNumberForLocation(n, n2);
        BytePageFrame bytePageFrame = (BytePageFrame)this.getPageFrameForReading(n3);
        byte[] byArray = bytePageFrame.getPageData();
        return byArray[n % this.pageWidth + n2 % this.pageHeight * this.pageWidth];
    }

    public void setPixel(int n, int n2, byte by) throws IOException {
        int n3 = this.getLogicalPageNumberForLocation(n, n2);
        BytePageFrame bytePageFrame = (BytePageFrame)this.getPageFrameForWriting(n3);
        byte[] byArray = bytePageFrame.getPageData();
        byArray[n % this.pageWidth + n2 % this.pageHeight * this.pageWidth] = by;
    }

    public void getRectangle(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws IOException {
        int n7 = n5;
        int n8 = n4;
        int n9 = n2;
        while (n8 != 0) {
            int n10 = n3;
            int n11 = n;
            int n12 = Math.min(this.pageHeight - n9 % this.pageHeight, n8);
            while (n10 != 0) {
                int n13 = this.getLogicalPageNumberForLocation(n11, n9);
                BytePageFrame bytePageFrame = (BytePageFrame)this.getPageFrameForReading(n13);
                int n14 = Math.min(this.pageWidth - n11 % this.pageWidth, n10);
                byte[] byArray2 = bytePageFrame.getPageData();
                int n15 = 0;
                while (n15 < n12) {
                    System.arraycopy(byArray2, n11 % this.pageWidth + (n9 % this.pageHeight + n15) * this.pageWidth, byArray, n7 + n11 - n + (n9 - n2 + n15) * n6, n14);
                    ++n15;
                }
                n11 += n14;
                n10 -= n14;
            }
            n9 += n12;
            n8 -= n12;
        }
    }

    public void setRectangle(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws IOException {
        int n7 = n5;
        int n8 = n4;
        int n9 = n2;
        while (n8 != 0) {
            int n10 = n3;
            int n11 = n;
            int n12 = Math.min(this.pageHeight - n9 % this.pageHeight, n8);
            while (n10 != 0) {
                int n13 = this.getLogicalPageNumberForLocation(n11, n9);
                BytePageFrame bytePageFrame = (BytePageFrame)this.getPageFrameForWriting(n13);
                int n14 = Math.min(this.pageWidth - n11 % this.pageWidth, n10);
                byte[] byArray2 = bytePageFrame.getPageData();
                int n15 = 0;
                while (n15 < n12) {
                    System.arraycopy(byArray, n7 + n11 - n + (n9 - n2 + n15) * n6, byArray2, n11 % this.pageWidth + (n9 % this.pageHeight + n15) * this.pageWidth, n14);
                    ++n15;
                }
                n11 += n14;
                n10 -= n14;
            }
            n9 += n12;
            n8 -= n12;
        }
    }

    public int getLogicalPageNumberForLocation(int n, int n2) {
        return n / this.pageWidth + n2 / this.pageHeight * this.widthInPages;
    }

    public int getPageSize() {
        return this.pageWidth * this.pageHeight * 1;
    }

    protected int getPixelSize() {
        return 1;
    }

    public PageFrame[] getPageFrames() {
        return this.pageFrames;
    }

    public Dimension getPageDimensions() {
        return new Dimension(this.pageWidth, this.pageHeight);
    }

    public BytePageMapper(RandomAccessStorage randomAccessStorage, Dimension dimension, int n) {
        super(randomAccessStorage, dimension, n);
        this.width = dimension.width;
        this.height = dimension.height;
        this.pageWidth = this.pageDimensions.width;
        this.pageHeight = this.pageDimensions.height;
        this.widthInPages = this.width % this.pageWidth == 0 ? this.width / this.pageWidth : this.width / this.pageWidth + 1;
        this.heightInPages = this.height % this.pageHeight == 0 ? this.height / this.pageHeight : this.height / this.pageHeight + 1;
        int n2 = this.pageWidth * this.pageHeight;
        this.pageFrames = new BytePageFrame[this.numberOfPageFrames];
        int n3 = 0;
        while (n3 < this.pageFrames.length) {
            this.pageFrames[n3] = new BytePageFrame(n2);
            ++n3;
        }
    }
}

