/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.util;

import com.sun.jimi.util.RandomAccessStorage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public final class FileRandomAccessStorage
extends RandomAccessFile
implements RandomAccessStorage {
    protected InputStream in;
    protected OutputStream out;
    protected File file;

    public OutputStream asOutputStream() {
        return this.out;
    }

    public InputStream asInputStream() {
        return this.in;
    }

    public void skip(int n) throws IOException {
        this.seek(this.getFilePointer() + (long)n);
    }

    public void seek(long l) throws IOException {
        super.seek(l);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void finalize() {
        try {
            this.close();
        }
        catch (IOException iOException) {
        }
        this.file.delete();
    }

    public FileRandomAccessStorage(File file) throws IOException {
        super(file, "rw");
        FileRandomAccessStorage fileRandomAccessStorage = this;
        if (fileRandomAccessStorage == null) {
            throw null;
        }
        this.in = new InputStreamWrapper(fileRandomAccessStorage);
        FileRandomAccessStorage fileRandomAccessStorage2 = this;
        if (fileRandomAccessStorage2 == null) {
            throw null;
        }
        this.out = new OutputStreamWrapper(fileRandomAccessStorage2);
        this.file = file;
    }

    protected final class OutputStreamWrapper
    extends OutputStream {
        private final /* synthetic */ FileRandomAccessStorage this$0;
        protected FileRandomAccessStorage storage;

        public void write(int n) throws IOException {
            this.storage.write(n);
        }

        public void write(byte[] byArray) throws IOException {
            this.storage.write(byArray);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.storage.write(byArray, n, n2);
        }

        OutputStreamWrapper(FileRandomAccessStorage fileRandomAccessStorage) {
            this.storage = this.this$0 = fileRandomAccessStorage;
        }
    }

    protected final class InputStreamWrapper
    extends InputStream {
        private final /* synthetic */ FileRandomAccessStorage this$0;
        protected FileRandomAccessStorage storage;

        public int read() throws IOException {
            return this.storage.read();
        }

        public int read(byte[] byArray) throws IOException {
            return this.storage.read(byArray);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.storage.read(byArray, n, n2);
        }

        InputStreamWrapper(FileRandomAccessStorage fileRandomAccessStorage) {
            this.storage = this.this$0 = fileRandomAccessStorage;
        }
    }
}

