/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.alk;

import de.geocalc.alk.EdbsLinie;
import de.geocalc.alk.EdbsName;
import de.geocalc.alk.EdbsObjekt;
import de.geocalc.alk.EdbsPunkt;
import de.geocalc.alk.EdbsText;
import de.geocalc.awt.ExceptionList;
import de.geocalc.awt.IProgressViewer;
import de.geocalc.io.unix.UnixIOConstants;
import de.geocalc.text.IFormat;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class AlkReader {
    Thread reader;
    String line = null;
    int s = 0;
    Vector L = new Vector();
    Hashtable P = new Hashtable();
    Hashtable O = new Hashtable();
    int error = 0;
    String errString = null;
    protected File inFile = null;
    private long inFileLength = 0L;
    protected IProgressViewer progressBar = null;
    private int progress = 0;
    private ExceptionList exceptionList = null;
    private int[] unreadFolien = new int[0];
    static boolean debug = false;
    private LineNumberReader f = null;

    public AlkReader(File file, IProgressViewer iProgressViewer) {
        this.inFile = file;
        if (file != null) {
            this.inFileLength = file.length();
        }
        this.progressBar = iProgressViewer;
    }

    protected void setFileProgress(long l) {
        this.setProgress((int)(l * 100L / this.inFileLength));
    }

    protected void setProgress(int n) {
        if (n - this.progress >= 5) {
            if (this.progressBar != null) {
                this.progressBar.setValue(n);
            }
            this.progress = n;
        }
    }

    public void setUnreadFolien(int[] nArray) {
        this.unreadFolien = nArray;
    }

    private boolean isFolieRead(int n) {
        for (int i = this.unreadFolien.length - 1; i >= 0; --i) {
            if (this.unreadFolien[i] != n) continue;
            return false;
        }
        return true;
    }

    public Enumeration points() {
        return this.P.elements();
    }

    public Enumeration objects() {
        return this.O.elements();
    }

    public int getObjectCount() {
        return this.O.size();
    }

    public void clear() {
        this.O.clear();
    }

    public void userAbort() throws IOException {
        try {
            if (this.f != null) {
                this.f.close();
            }
        }
        catch (Exception exception) {
            throw new IOException("Fehler beim Schlie\u00dfen der Datei: " + this.inFile.getName());
        }
    }

    public void read() throws IOException {
        try {
            this.f = new LineNumberReader(new BufferedReader(new FileReader(this.inFile)));
            long l = 0L;
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            while ((this.line = this.f.readLine()) != null) {
                int n = this.testEdbs();
                switch (n) {
                    case -1: {
                        this.error(11, this.f.getLineNumber(), "", false);
                        break;
                    }
                    case -11: {
                        stringBuffer = new StringBuffer(this.line);
                        break;
                    }
                    case -12: {
                        stringBuffer.append(this.line.substring(36));
                        break;
                    }
                    case 13: {
                        stringBuffer.append(this.line.substring(36));
                        this.line = stringBuffer.toString();
                    }
                }
                if (n < 0) continue;
                this.s = 36;
                switch (this.testOperation()) {
                    case 0: {
                        break;
                    }
                    case -1: {
                        this.error(12, this.f.getLineNumber(), "", false);
                        break;
                    }
                    case -2: {
                        this.error(13, this.f.getLineNumber(), "", false);
                        break;
                    }
                    case 1: {
                        if (this.stringToInt(this.line.substring(this.s, this.s += 4)) <= 0) break;
                        this.readULQA0000();
                        break;
                    }
                    case 11: {
                        int n2;
                        int n3 = this.stringToInt(this.line.substring(this.s, this.s += 4));
                        for (n2 = 0; n2 < n3; ++n2) {
                            this.readULO8ALK();
                        }
                        break;
                    }
                    case 12: {
                        int n2 = this.stringToInt(this.line.substring(this.s, this.s += 4));
                        for (int i = 0; i < n2; ++i) {
                            this.readULOBNN();
                        }
                        break;
                    }
                    case 99: {
                        bl = true;
                    }
                }
                this.setFileProgress(l += (long)(this.line.length() + 1));
            }
            this.f.close();
            this.error = 0;
        }
        catch (Exception exception) {
            int n = 0;
            try {
                n = this.f.getLineNumber();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            System.out.println("L:" + this.f.getLineNumber() + " > " + exception.getMessage());
            exception.printStackTrace();
            this.error(99, n, exception.getMessage(), true);
        }
        this.fillObjects();
    }

    public boolean hasError() {
        return this.error > 0;
    }

    public String getErrorMessage() {
        return this.errString;
    }

    private void error(int n, int n2, String string, boolean bl) {
        ++this.error;
        switch (n) {
            case 1: {
                this.errString = "Datei: " + string + " nicht gefunden";
                break;
            }
            case 2: {
                this.errString = "Datei: " + string + " kann nicht zum Lesen ge\u00f6ffnet werden";
                break;
            }
            case 3: {
                this.errString = "Datei: " + string + " ist leer";
                break;
            }
            case 4: {
                this.errString = "Zeile: " + n2 + " IOFehler beim lesen";
                break;
            }
            case 11: {
                this.errString = "Zeile: " + n2 + " ohne EDBS-Kennung";
                break;
            }
            case 12: {
                this.errString = "Zeile: " + n2 + " Operation nicht m\u00f6glich";
                break;
            }
            case 13: {
                this.errString = "Zeile: " + n2 + " Aggregat nicht implementiert";
                break;
            }
            case 21: {
                this.errString = "Zeile: " + n2 + " Zeilenende vorzeitig erreicht";
                break;
            }
            case 22: {
                this.errString = "Zeile: " + n2 + " Dateiende vorzeitig erreicht";
                break;
            }
            case 23: {
                this.errString = "Zeile: " + n2 + " Unerwarteten Wert in Spalte " + (this.s + 1) + " vorgefunden";
                break;
            }
            case 31: {
                this.errString = "Objekt: " + string + " konnte nicht verkettet werden";
                break;
            }
            case 91: {
                this.errString = "Zeile: " + n2 + " Spalte: " + (this.s + 1) + " ,falsche Speicherzuweisung";
                break;
            }
            case 99: {
                this.errString = "Zeile: " + n2 + " kritischer Fehler: " + string;
                break;
            }
            default: {
                this.errString = "Allgemeiner Fehler in Modul EdbsReader";
            }
        }
    }

    private int testEdbs() throws StringIndexOutOfBoundsException {
        if (this.line.length() < 4 || !this.line.substring(0, 4).equals("EDBS")) {
            return -1;
        }
        switch (this.line.charAt(22)) {
            case 'A': {
                return -11;
            }
            case 'F': {
                return -12;
            }
            case 'E': {
                return 13;
            }
        }
        return 0;
    }

    private int testOperation() {
        String string = null;
        String string2 = null;
        string = this.line.substring(12, 16);
        if (this.line.length() >= 36) {
            string2 = this.line.substring(28, 36);
        }
        if (string.startsWith("B")) {
            if (string.equals("BSPE")) {
                if (string2.equals("ULO8ALK ")) {
                    return 11;
                }
                if (string2.equals("ULOBNN  ")) {
                    return 12;
                }
                return -2;
            }
            return 0;
        }
        if (string.startsWith("F")) {
            if (string.equals("FEIN")) {
                if (string2.equals("ULO8ALK ")) {
                    return 11;
                }
                if (string2.equals("ULOBNN  ")) {
                    return 12;
                }
                return -2;
            }
            return -1;
        }
        if (string.startsWith("A")) {
            if (string.equals("AKND")) {
                if (string2.equals("ULQA0000")) {
                    return 1;
                }
                return 0;
            }
            if (string.equals("AEND")) {
                return 99;
            }
            return 0;
        }
        if (string.startsWith("O")) {
            return 0;
        }
        if (string.startsWith("V")) {
            return 0;
        }
        if (string.startsWith("P")) {
            return 0;
        }
        return -1;
    }

    private void readULQA0000() throws StringIndexOutOfBoundsException {
        this.s += 258;
    }

    private void readULO8ALK() throws StringIndexOutOfBoundsException {
        int n;
        this.s += 4;
        EdbsPunkt edbsPunkt = this.readULOB0000();
        int n2 = this.stringToInt(this.line.substring(this.s, this.s += 4));
        for (n = 0; n < n2; ++n) {
            this.readULO10ALF(edbsPunkt);
        }
        n = this.stringToInt(this.line.substring(this.s, this.s += 4));
        for (int i = 0; i < n; ++i) {
            this.readULO20ALF(edbsPunkt);
        }
    }

    private void readULOBNN() throws StringIndexOutOfBoundsException {
        int n;
        this.s += 4;
        EdbsPunkt edbsPunkt = this.readULOB0000();
        int n2 = this.stringToInt(this.line.substring(this.s, this.s += 4));
        for (n = 0; n < n2; ++n) {
            this.readULOB100F(edbsPunkt);
        }
        n = this.stringToInt(this.line.substring(this.s, this.s += 4));
        for (int i = 0; i < n; ++i) {
            this.readULOB200F(edbsPunkt);
        }
    }

    private EdbsPunkt readULOB0000() throws StringIndexOutOfBoundsException {
        EdbsPunkt edbsPunkt = this.readPoint(this.s);
        this.s += 21;
        return edbsPunkt;
    }

    private void readULO10ALF(EdbsPunkt edbsPunkt) throws StringIndexOutOfBoundsException {
        int n;
        Object object;
        int n2;
        this.s += 4;
        EdbsLinie edbsLinie = new EdbsLinie();
        edbsLinie.pa = this.insertPunkt(new EdbsPunkt(edbsPunkt.x, edbsPunkt.y));
        edbsLinie = this.readULO10ALK(edbsLinie);
        int n3 = this.stringToInt(this.line.substring(this.s, this.s += 4));
        Vector<Object> vector = new Vector<Object>();
        for (n2 = 0; n2 < n3; ++n2) {
            object = this.readULO11ALK(new EdbsLinie(edbsLinie.pa, edbsLinie.pe, 0, edbsLinie.adG));
            if (!this.isFolieRead(edbsLinie.folie)) continue;
            vector.addElement(object);
        }
        n2 = this.stringToInt(this.line.substring(this.s, this.s += 4));
        object = new Vector();
        for (n = 0; n < n2; ++n) {
            ((Vector)object).addElement(this.readULOB1200(edbsLinie.adG));
        }
        n = vector.size();
        if (n == 0) {
            n = this.searchLinieDefs(edbsLinie, vector);
        }
        for (int i = 0; i < n; ++i) {
            EdbsLinie edbsLinie2 = (EdbsLinie)vector.elementAt(i);
            this.createLineGeom(edbsLinie2, (Vector)object, true);
            this.L.addElement(edbsLinie2);
        }
    }

    private void readULOB100F(EdbsPunkt edbsPunkt) throws StringIndexOutOfBoundsException {
        int n;
        int n2;
        int n3;
        this.s += 4;
        EdbsLinie edbsLinie = new EdbsLinie();
        edbsLinie.pa = this.insertPunkt(new EdbsPunkt(edbsPunkt.x, edbsPunkt.y));
        edbsLinie = this.readULOB1000(edbsLinie);
        int n4 = this.stringToInt(this.line.substring(this.s, this.s += 4));
        Vector<EdbsLinie> vector = new Vector<EdbsLinie>();
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = this.stringToInt(this.line.substring(this.s, this.s += 4));
            for (n2 = 0; n2 < n5; ++n2) {
                EdbsLinie edbsLinie2 = this.readULOB1100(new EdbsLinie(edbsLinie.pa, edbsLinie.pe, 0, edbsLinie.adG));
                if (!this.isFolieRead(edbsLinie2.folie)) continue;
                vector.addElement(edbsLinie2);
            }
            n2 = this.stringToInt(this.line.substring(this.s, this.s += 4));
            for (n = 0; n < n2; ++n) {
                this.s += 9;
            }
        }
        n3 = this.stringToInt(this.line.substring(this.s, this.s += 4));
        Vector<EdbsPunkt> vector2 = new Vector<EdbsPunkt>();
        for (n2 = 0; n2 < n3; ++n2) {
            vector2.addElement(this.readULOB1200(edbsLinie.adG));
        }
        n2 = vector.size();
        if (n2 == 0) {
            n2 = this.searchLinieDefs(edbsLinie, vector);
        }
        for (n = 0; n < n2; ++n) {
            EdbsLinie edbsLinie3 = (EdbsLinie)vector.elementAt(n);
            this.createLineGeom(edbsLinie3, vector2, true);
            this.L.addElement(edbsLinie3);
        }
    }

    private int searchLinieDefs(EdbsLinie edbsLinie, Vector vector) {
        for (int i = this.L.size() - 1; i >= 0; --i) {
            EdbsLinie edbsLinie2 = (EdbsLinie)this.L.elementAt(i);
            if (!edbsLinie2.pa.equals(edbsLinie.pa) || !edbsLinie2.pe.equals(edbsLinie.pe)) continue;
            this.L.removeElementAt(i);
            vector.addElement(edbsLinie2);
        }
        return vector.size();
    }

    private EdbsLinie readULO10ALK(EdbsLinie edbsLinie) throws StringIndexOutOfBoundsException {
        edbsLinie.pe = this.insertPunkt(this.readPoint(this.s));
        char c = this.line.charAt(this.s + 20);
        edbsLinie.adG = (byte)(this.line.charAt(this.s + 21) - 48 + (c < '<' ? c - 48 : c - 64) * 10);
        this.s += 22;
        return edbsLinie;
    }

    private EdbsLinie readULOB1000(EdbsLinie edbsLinie) throws StringIndexOutOfBoundsException {
        edbsLinie.pe = this.insertPunkt(this.readPoint(this.s));
        char c = this.line.charAt(this.s + 20);
        edbsLinie.adG = (byte)(this.line.charAt(this.s + 21) - 48 + (c < '<' ? c - 48 : c - 64) * 10);
        this.s += 22;
        return edbsLinie;
    }

    private EdbsLinie readULO11ALK(EdbsLinie edbsLinie) throws StringIndexOutOfBoundsException {
        edbsLinie.folie = this.stringToInt(this.line.substring(this.s, this.s + 3));
        edbsLinie.oska = this.stringToInt(this.line.substring(this.s + 3, this.s + 7));
        String string = this.line.substring(this.s + 7, this.s + 14).trim();
        if (string.length() > 0) {
            edbsLinie.objRechts = string;
        }
        if ((string = this.line.substring(this.s + 14, this.s + 21).trim()).length() > 0) {
            edbsLinie.objLinks = string;
        }
        this.s += 23;
        return edbsLinie;
    }

    private EdbsLinie readULOB1100(EdbsLinie edbsLinie) throws StringIndexOutOfBoundsException {
        edbsLinie.folie = this.stringToInt(this.line.substring(this.s, this.s + 3));
        edbsLinie.oska = this.stringToInt(this.line.substring(this.s + 3, this.s + 7));
        String string = this.line.substring(this.s + 7, this.s + 14).trim();
        if (string.length() > 0) {
            edbsLinie.objRechts = string;
        }
        if ((string = this.line.substring(this.s + 14, this.s + 21).trim()).length() > 0) {
            edbsLinie.objLinks = string;
        }
        this.s += 29;
        return edbsLinie;
    }

    private EdbsPunkt readULOB1200(int n) {
        EdbsPunkt edbsPunkt = new EdbsPunkt(0L, 0L);
        if (n > 29) {
            if (this.line.charAt(this.s + 1) == ' ') {
                edbsPunkt.oska = this.stringToInt(this.line.substring(this.s, this.s + 1));
                this.s += 20;
                return edbsPunkt;
            }
            if (this.line.charAt(this.s) == 'T') {
                edbsPunkt.oska = this.stringToInt(this.line.substring(this.s + 2, this.s + 4));
                this.s += 20;
                return edbsPunkt;
            }
        }
        edbsPunkt = this.readPoint(this.s);
        this.s += 20;
        return edbsPunkt;
    }

    private void readULO20ALF(EdbsPunkt edbsPunkt) throws StringIndexOutOfBoundsException {
        int n = this.stringToInt(this.line.substring(this.s, this.s += 4));
        for (int i = 0; i < n; ++i) {
            EdbsObjekt edbsObjekt = new EdbsObjekt();
            edbsObjekt = this.readULO20ALK(edbsObjekt);
            if (!this.isFolieRead(edbsObjekt.folie)) {
                return;
            }
            edbsObjekt.x = edbsPunkt.x;
            edbsObjekt.y = edbsPunkt.y;
            int n2 = this.stringToInt(this.line.substring(this.s, this.s += 4));
            for (int j = 0; j < n2; ++j) {
                this.readULO21ALF(edbsObjekt);
            }
            this.insertObject(edbsObjekt);
        }
    }

    private void readULOB200F(EdbsPunkt edbsPunkt) throws StringIndexOutOfBoundsException {
        int n;
        int n2 = this.stringToInt(this.line.substring(this.s, this.s += 4));
        EdbsObjekt edbsObjekt = new EdbsObjekt();
        for (n = 0; n < n2; ++n) {
            edbsObjekt = this.readULOB2000(edbsObjekt);
            edbsObjekt.x = edbsPunkt.x;
            edbsObjekt.y = edbsPunkt.y;
        }
        n = this.stringToInt(this.line.substring(this.s, this.s += 4));
        for (int i = 0; i < n; ++i) {
            this.readULOB210F(edbsObjekt);
        }
        if (this.isFolieRead(edbsObjekt.folie)) {
            this.insertObject(edbsObjekt);
        }
    }

    private EdbsObjekt readULO21ALF(EdbsObjekt edbsObjekt) {
        int n;
        int n2 = this.stringToInt(this.line.substring(this.s, this.s += 4));
        for (n = 0; n < n2; ++n) {
            edbsObjekt = this.readULO21ALK(edbsObjekt);
        }
        n = this.stringToInt(this.line.substring(this.s, this.s += 4));
        Vector<EdbsPunkt> vector = new Vector<EdbsPunkt>();
        for (int i = 0; i < n; ++i) {
            vector.addElement(this.readULOB2110(edbsObjekt.adG));
        }
        this.createObjectGeom(edbsObjekt, vector);
        return edbsObjekt;
    }

    private EdbsObjekt readULOB210F(EdbsObjekt edbsObjekt) {
        int n;
        int n2 = this.stringToInt(this.line.substring(this.s, this.s += 4));
        for (n = 0; n < n2; ++n) {
            edbsObjekt = this.readULOB2100(edbsObjekt);
        }
        n = this.stringToInt(this.line.substring(this.s, this.s += 4));
        Vector<EdbsPunkt> vector = new Vector<EdbsPunkt>();
        for (int i = 0; i < n; ++i) {
            vector.addElement(this.readULOB2110(edbsObjekt.adG));
        }
        this.createObjectGeom(edbsObjekt, vector);
        return edbsObjekt;
    }

    private EdbsObjekt readULO20ALK(EdbsObjekt edbsObjekt) throws StringIndexOutOfBoundsException {
        edbsObjekt.folie = this.stringToInt(this.line.substring(this.s, this.s + 3));
        edbsObjekt.oska = this.stringToInt(this.line.substring(this.s + 3, this.s + 7));
        edbsObjekt.typ = this.line.charAt(this.s + 9);
        edbsObjekt.nr = this.line.substring(this.s + 10, this.s + 17).trim();
        this.s += 23;
        EdbsObjekt edbsObjekt2 = (EdbsObjekt)this.O.get(edbsObjekt.nr);
        return edbsObjekt2 == null ? edbsObjekt : edbsObjekt2;
    }

    private EdbsObjekt readULOB2000(EdbsObjekt edbsObjekt) throws StringIndexOutOfBoundsException {
        edbsObjekt.folie = this.stringToInt(this.line.substring(this.s, this.s + 3));
        edbsObjekt.oska = this.stringToInt(this.line.substring(this.s + 3, this.s + 7));
        edbsObjekt.typ = this.line.charAt(this.s + 9);
        edbsObjekt.nr = this.line.substring(this.s + 10, this.s + 17).trim();
        this.s += 26;
        EdbsObjekt edbsObjekt2 = (EdbsObjekt)this.O.get(edbsObjekt.nr);
        return edbsObjekt2 == null ? edbsObjekt : edbsObjekt2;
    }

    private EdbsObjekt readULO21ALK(EdbsObjekt edbsObjekt) throws StringIndexOutOfBoundsException {
        edbsObjekt.adI = (byte)this.stringToInt(this.line.substring(this.s, this.s + 2));
        if (edbsObjekt.adI == 22 || edbsObjekt.adI == 23) {
            edbsObjekt.text = UnixIOConstants.unix2Java(this.line.substring(this.s + 10, this.s + 27).trim());
        } else if (edbsObjekt.adI == 24) {
            edbsObjekt.text = UnixIOConstants.unix2Java(this.line.substring(this.s + 14, this.s + 43).trim());
        } else if (edbsObjekt.adI >= 10 && edbsObjekt.adI <= 19) {
            switch (edbsObjekt.adI) {
                case 11: 
                case 13: 
                case 15: 
                case 16: {
                    edbsObjekt.name = UnixIOConstants.unix2Java(this.line.substring(this.s + 10, this.s + 43).trim());
                    break;
                }
                case 12: 
                case 14: {
                    edbsObjekt.name = UnixIOConstants.unix2Java(this.line.substring(this.s + 10, this.s + 43).trim());
                    break;
                }
                case 17: {
                    edbsObjekt.text = UnixIOConstants.unix2Java(this.line.substring(this.s + 10, this.s + 43).trim());
                    break;
                }
            }
        } else if (edbsObjekt.adI >= 20 && edbsObjekt.adI <= 29) {
            edbsObjekt.text = UnixIOConstants.unix2Java(this.line.substring(this.s + 10, this.s + 41).trim());
        } else if (edbsObjekt.adI >= 60 && edbsObjekt.adI <= 69) {
            edbsObjekt.text = UnixIOConstants.unix2Java(this.line.substring(this.s + 10, this.s + 43).trim());
        } else if (edbsObjekt.adI == 80) {
            this.readFachAttribut(edbsObjekt, this.line.substring(this.s + 10, this.s + 43));
        }
        if (edbsObjekt.adI <= 39 || edbsObjekt.adI >= 60 && edbsObjekt.adI <= 69) {
            edbsObjekt.iOska = this.stringToInt(this.line.substring(this.s + 6, this.s + 10));
        }
        edbsObjekt.adG = (byte)this.stringToInt(this.line.substring(this.s + 43, this.s + 45));
        this.s += 45;
        return edbsObjekt;
    }

    private void readFachAttribut(EdbsObjekt edbsObjekt, String string) {
        int n = string.indexOf("$");
        int n2 = string.indexOf("$", n + 1);
        int n3 = string.indexOf("$", n2 + 1);
        String string2 = string.substring(n + 1, n2);
        String string3 = string.substring(n2 + 1, n2 + 2);
        String string4 = string.substring(n2 + 2, n3);
        Object object = null;
        try {
            object = string3.equals("G") ? new Integer(string4) : (string3.equals("R") ? new Float(string4) : string4);
        }
        catch (Exception exception) {
            object = string4;
        }
        edbsObjekt.setAttribute(string2, object);
    }

    private EdbsObjekt readULOB2100(EdbsObjekt edbsObjekt) throws StringIndexOutOfBoundsException {
        edbsObjekt.adI = (byte)this.stringToInt(this.line.substring(this.s, this.s + 2));
        if (edbsObjekt.adI == 22 || edbsObjekt.adI == 23) {
            edbsObjekt.text = UnixIOConstants.unix2Java(this.line.substring(this.s + 10, this.s + 27).trim());
        } else if (edbsObjekt.adI == 24) {
            edbsObjekt.text = UnixIOConstants.unix2Java(this.line.substring(this.s + 14, this.s + 43).trim());
        } else if (edbsObjekt.adI >= 10 && edbsObjekt.adI <= 19) {
            switch (edbsObjekt.adI) {
                case 11: 
                case 13: 
                case 15: 
                case 16: {
                    edbsObjekt.name = UnixIOConstants.unix2Java(this.line.substring(this.s + 10, this.s + 43).trim());
                    break;
                }
                case 12: 
                case 14: {
                    edbsObjekt.name = UnixIOConstants.unix2Java(this.line.substring(this.s + 10, this.s + 43).trim());
                    break;
                }
                case 17: {
                    edbsObjekt.text = UnixIOConstants.unix2Java(this.line.substring(this.s + 10, this.s + 43).trim());
                    break;
                }
            }
        } else if (edbsObjekt.adI >= 20 && edbsObjekt.adI <= 29) {
            edbsObjekt.text = UnixIOConstants.unix2Java(this.line.substring(this.s + 10, this.s + 41).trim());
        } else if (edbsObjekt.adI >= 60 && edbsObjekt.adI <= 69) {
            edbsObjekt.text = UnixIOConstants.unix2Java(this.line.substring(this.s + 10, this.s + 43).trim());
        }
        if (edbsObjekt.adI <= 39 || edbsObjekt.adI >= 60 && edbsObjekt.adI <= 69) {
            edbsObjekt.iOska = this.stringToInt(this.line.substring(this.s + 6, this.s + 10));
        }
        edbsObjekt.adG = (byte)this.stringToInt(this.line.substring(this.s + 43, this.s + 45));
        this.s += 48;
        return edbsObjekt;
    }

    private EdbsPunkt readULOB2110(int n) {
        EdbsPunkt edbsPunkt = new EdbsPunkt(0L, 0L);
        if (n == 41 && this.line.charAt(this.s + 1) == ' ') {
            edbsPunkt.oska = this.stringToInt(this.line.substring(this.s, this.s + 1));
        } else if (n == 53 && this.line.charAt(this.s) == 'T') {
            edbsPunkt.w = (int)Math.rint(this.stringToInt(this.line.substring(this.s + 2, this.s + 7)));
        } else if (n == 92 && this.line.charAt(this.s) == 'T') {
            edbsPunkt.oska = this.stringToInt(this.line.substring(this.s + 2, this.s + 4));
        } else if (this.line.charAt(this.s) == 'T') {
            try {
                edbsPunkt.w = (int)Math.rint(this.stringToInt(this.line.substring(this.s + 2, this.s + 7)));
            }
            catch (Exception exception) {}
        } else {
            edbsPunkt = this.readPoint(this.s);
        }
        this.s += 20;
        return edbsPunkt;
    }

    private EdbsPunkt readPoint(int n) throws StringIndexOutOfBoundsException {
        EdbsPunkt edbsPunkt = new EdbsPunkt();
        edbsPunkt.y = Long.parseLong(this.line.substring(n + 0, n + 2).trim() + this.line.substring(n + 4, n + 6).trim() + this.line.substring(n + 8, n + 14).trim());
        edbsPunkt.x = Long.parseLong(this.line.substring(n + 2, n + 4).trim() + this.line.substring(n + 6, n + 8).trim() + this.line.substring(n + 14, n + 20).trim());
        return edbsPunkt;
    }

    private void createLineGeom(EdbsLinie edbsLinie, Vector vector, boolean bl) {
        if (vector.size() == 0) {
            return;
        }
        switch (edbsLinie.adG) {
            case 11: {
                break;
            }
            case 15: {
                int n;
                int n2 = vector.size();
                int n3 = n = bl ? 0 : 2;
                while (n < n2) {
                    edbsLinie.addPoint((EdbsPunkt)vector.elementAt(n));
                    ++n;
                }
                break;
            }
            case 21: 
            case 22: {
                edbsLinie.r = this.getRadius(edbsLinie.pa, edbsLinie.pe, (EdbsPunkt)vector.firstElement(), edbsLinie.adG == 21);
                if (edbsLinie.pa.equals(edbsLinie.pe)) {
                    edbsLinie.pa = (EdbsPunkt)vector.firstElement();
                    edbsLinie.pe = (EdbsPunkt)vector.firstElement();
                    break;
                }
                int n = this.getMidpointDist(edbsLinie.pa, edbsLinie.pe, (EdbsPunkt)vector.firstElement(), edbsLinie.adG == 21, edbsLinie.r);
                if ((n >= 0 || edbsLinie.r <= 0) && (n <= 0 || edbsLinie.r >= 0)) break;
                double d = Math.sqrt((edbsLinie.pa.x - edbsLinie.pe.x) * (edbsLinie.pa.x - edbsLinie.pe.x) + (edbsLinie.pa.y - edbsLinie.pe.y) * (edbsLinie.pa.y - edbsLinie.pe.y));
                double d2 = (double)(edbsLinie.pe.x - edbsLinie.pa.x) / d;
                double d3 = (double)(edbsLinie.pe.y - edbsLinie.pa.y) / d;
                double d4 = (double)edbsLinie.pa.y + d3 * (d / 2.0) + d2 * (double)(-n + edbsLinie.r);
                double d5 = (double)edbsLinie.pa.x + d2 * (d / 2.0) - d3 * (double)(-n + edbsLinie.r);
                edbsLinie.addPoint(new EdbsPunkt((long)d5, (long)d4));
                break;
            }
            case 41: {
                EdbsPunkt edbsPunkt = (EdbsPunkt)vector.firstElement();
                int n = 0;
                int n4 = 0;
                switch (edbsPunkt.oska) {
                    case 2: {
                        n = 1;
                        break;
                    }
                    case 3: {
                        n4 = 1;
                        break;
                    }
                    case 4: {
                        n = 1;
                        n4 = 1;
                    }
                }
                for (int i = (bl ? 1 : 3) + n; i < vector.size() - n4; ++i) {
                    edbsLinie.addPoint((EdbsPunkt)vector.elementAt(i));
                }
                if (edbsPunkt.oska != 5) break;
                edbsLinie.addPoint((EdbsPunkt)vector.elementAt(1));
                break;
            }
        }
    }

    private void createObjectGeom(EdbsObjekt edbsObjekt, Vector vector) {
        if (vector.size() == 0 || edbsObjekt.adI == 15) {
            return;
        }
        block0 : switch (edbsObjekt.adI / 10) {
            case 1: {
                EdbsPunkt edbsPunkt;
                EdbsPunkt edbsPunkt2 = (EdbsPunkt)vector.elementAt(0);
                EdbsPunkt edbsPunkt3 = edbsPunkt = vector.size() > 1 ? (EdbsPunkt)vector.elementAt(1) : edbsPunkt2;
                if (edbsObjekt.adI == 13 || edbsObjekt.adI == 16) {
                    edbsObjekt.addElement(new EdbsName(edbsPunkt.x, edbsPunkt.y, edbsPunkt2.w, edbsObjekt.name, edbsObjekt.adI));
                    break;
                }
                if (edbsObjekt.adI != 14 && edbsObjekt.adI != 17) break;
                edbsObjekt.addElement(new EdbsName(edbsPunkt.x, edbsPunkt.y, edbsPunkt2.w, edbsObjekt.text, edbsObjekt.adI));
                break;
            }
            case 2: {
                switch (edbsObjekt.adG) {
                    case 11: {
                        EdbsPunkt edbsPunkt = (EdbsPunkt)vector.elementAt(0);
                        EdbsPunkt edbsPunkt4 = (EdbsPunkt)vector.elementAt(1);
                        edbsObjekt.addElement(new EdbsText(edbsPunkt.x, edbsPunkt.y, this.textWinkel(edbsPunkt, edbsPunkt4), edbsObjekt.folie, edbsObjekt.iOska, edbsObjekt.text));
                        break block0;
                    }
                    case 51: {
                        EdbsPunkt edbsPunkt = (EdbsPunkt)vector.elementAt(0);
                        edbsObjekt.addElement(new EdbsText(edbsPunkt.x, edbsPunkt.y, 0, edbsObjekt.folie, edbsObjekt.iOska, edbsObjekt.text));
                        break block0;
                    }
                    case 53: {
                        EdbsPunkt edbsPunkt = (EdbsPunkt)vector.elementAt(0);
                        EdbsPunkt edbsPunkt5 = (EdbsPunkt)vector.elementAt(1);
                        edbsObjekt.addElement(new EdbsText(edbsPunkt5.x, edbsPunkt5.y, edbsPunkt.w, edbsObjekt.folie, edbsObjekt.iOska, edbsObjekt.text));
                        break block0;
                    }
                }
                edbsObjekt.addElement(new EdbsText(edbsObjekt.x, edbsObjekt.y, 0, edbsObjekt.folie, edbsObjekt.iOska, edbsObjekt.text));
                break;
            }
            case 3: {
                if (edbsObjekt.adG <= 41) {
                    EdbsPunkt edbsPunkt = this.insertPunkt((EdbsPunkt)vector.elementAt(0));
                    EdbsPunkt edbsPunkt6 = this.insertPunkt((EdbsPunkt)vector.elementAt(1));
                    EdbsLinie edbsLinie = new EdbsLinie(edbsPunkt, edbsPunkt6, 0, edbsObjekt.adG, edbsObjekt.folie, edbsObjekt.iOska, false);
                    this.createLineGeom(edbsLinie, vector, false);
                    edbsObjekt.addElement(edbsLinie);
                    break;
                }
                this.createObjectPoints(edbsObjekt, vector);
                break;
            }
        }
    }

    private void createObjectPoints(EdbsObjekt edbsObjekt, Vector vector) {
        switch (edbsObjekt.adG) {
            case 51: 
            case 52: {
                for (int i = 0; i < vector.size(); ++i) {
                    EdbsPunkt edbsPunkt = (EdbsPunkt)vector.elementAt(i);
                    edbsObjekt.addElement(new EdbsPunkt(edbsPunkt.x, edbsPunkt.y, edbsObjekt.folie, edbsObjekt.iOska));
                }
                break;
            }
            case 53: {
                EdbsPunkt edbsPunkt = (EdbsPunkt)vector.firstElement();
                for (int i = 1; i < vector.size(); ++i) {
                    EdbsPunkt edbsPunkt2 = (EdbsPunkt)vector.elementAt(i);
                    edbsObjekt.addElement(new EdbsPunkt(edbsPunkt2.x, edbsPunkt2.y, edbsPunkt.w, edbsObjekt.folie, edbsObjekt.iOska));
                }
                break;
            }
        }
    }

    private int stringToInt(String string) throws NumberFormatException {
        String string2 = IFormat.getDigits(string);
        if (string2.length() == 0) {
            return 0;
        }
        return Integer.parseInt(string2);
    }

    private EdbsPunkt insertPunkt(EdbsPunkt edbsPunkt) {
        EdbsPunkt edbsPunkt2 = this.P.put(edbsPunkt, edbsPunkt);
        return edbsPunkt2 != null ? edbsPunkt2 : edbsPunkt;
    }

    private EdbsObjekt insertObject(EdbsObjekt edbsObjekt) {
        return this.O.put(edbsObjekt.nr, edbsObjekt);
    }

    private int getRadius(EdbsPunkt edbsPunkt, EdbsPunkt edbsPunkt2, EdbsPunkt edbsPunkt3, boolean bl) {
        double d = (double)(edbsPunkt.x - edbsPunkt3.x) * (double)(edbsPunkt.x - edbsPunkt3.x) + (double)(edbsPunkt.y - edbsPunkt3.y) * (double)(edbsPunkt.y - edbsPunkt3.y);
        double d2 = (double)(edbsPunkt2.x - edbsPunkt3.x) * (double)(edbsPunkt2.x - edbsPunkt3.x) + (double)(edbsPunkt2.y - edbsPunkt3.y) * (double)(edbsPunkt2.y - edbsPunkt3.y);
        int n = (int)Math.rint(Math.sqrt((d + d2) / 2.0));
        return bl ? n : -n;
    }

    private int getMidpointDist(EdbsPunkt edbsPunkt, EdbsPunkt edbsPunkt2, EdbsPunkt edbsPunkt3, boolean bl, int n) {
        double d = Math.atan2(edbsPunkt2.x - edbsPunkt.x, edbsPunkt2.y - edbsPunkt.y);
        double d2 = -Math.sin(d);
        double d3 = Math.cos(d);
        return (int)Math.rint(d2 * (double)(edbsPunkt3.y - edbsPunkt.y) + d3 * (double)(edbsPunkt3.x - edbsPunkt.x));
    }

    private int textWinkel(EdbsPunkt edbsPunkt, EdbsPunkt edbsPunkt2) {
        return (int)(Math.rint(Math.atan2(edbsPunkt2.y - edbsPunkt.y, edbsPunkt2.x - edbsPunkt.x) * 200.0 / Math.PI) * 100.0);
    }

    private void fillObjects() {
        Enumeration enumeration = this.L.elements();
        while (enumeration.hasMoreElements()) {
            EdbsLinie edbsLinie = (EdbsLinie)enumeration.nextElement();
            if (edbsLinie.objRechts != null || edbsLinie.objLinks != null) continue;
            System.out.println(edbsLinie);
        }
        enumeration = this.L.elements();
        while (enumeration.hasMoreElements()) {
            EdbsObjekt edbsObjekt;
            boolean bl = false;
            EdbsLinie edbsLinie = (EdbsLinie)enumeration.nextElement();
            if (edbsLinie.objRechts != null && (edbsObjekt = (EdbsObjekt)this.O.get(edbsLinie.objRechts)) != null) {
                edbsObjekt.addElement(edbsLinie);
            }
            if (edbsLinie.objLinks == null || edbsLinie.objLinks.equals(edbsLinie.objRechts) || (edbsObjekt = (EdbsObjekt)this.O.get(edbsLinie.objLinks)) == null) continue;
            edbsObjekt.addElement(edbsLinie);
        }
    }
}

