/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.DrawFieldSearchResult;
import de.geocalc.awt.IInscription;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.text.AttributedCharacterIterator;

public class DrawField
extends Graphics {
    public static final byte VOID = 0;
    public static final byte WRITABLE = 10;
    public static final byte RESERVED = 99;
    public static final byte MAX_VALUE = 99;
    private static final int STEP = 2;
    private static final int STEP_R = 2;
    private byte[][] field;
    private byte drawByte = 0;
    private Rectangle clip = new Rectangle();
    private Font font = new Font("SansSerif", 0, 12);
    private Color color = Color.white;
    private int maxX;
    private int maxY;
    private int startX;
    private int startY;

    public DrawField(int n, int n2) {
        this.field = new byte[n][n2];
        this.maxX = n;
        this.maxY = n2;
        this.clip = new Rectangle(0, 0, n, n2);
    }

    public void setFill(byte by) {
        this.drawByte = by;
    }

    @Override
    public void clearRect(int n, int n2, int n3, int n4) {
        this.fillRect(n, n2, n3, n4, (byte)0);
    }

    @Override
    public void clipRect(int n, int n2, int n3, int n4) {
        this.clip = new Rectangle(n, n2, n3, n4);
    }

    @Override
    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        System.out.println("copyArea nicht implementiert");
    }

    @Override
    public Graphics create() {
        return this.create(0, 0, 0, 0);
    }

    @Override
    public Graphics create(int n, int n2, int n3, int n4) {
        return new DrawField(n3, n4);
    }

    @Override
    public void dispose() {
        this.field = null;
    }

    @Override
    public void draw3DRect(int n, int n2, int n3, int n4, boolean bl) {
        this.drawRect(n, n2, n3, n4);
        this.drawRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
    }

    @Override
    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        System.out.println("drawArc nicht implementiert");
    }

    @Override
    public void drawBytes(byte[] byArray, int n, int n2, int n3, int n4) {
        System.out.println("drawBytes nicht implementiert");
    }

    @Override
    public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
        System.out.println("drawBytes nicht implementiert");
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, image.getWidth(imageObserver), image.getHeight(imageObserver), 0, 0, 0, 0, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, image.getWidth(imageObserver), image.getHeight(imageObserver), 0, 0, 0, 0, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, 0, 0, 0, 0, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, 0, 0, 0, 0, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        this.fillRect(n, n2, n3 - n, n4 - n2, this.drawByte);
        return true;
    }

    @Override
    public void drawLine(int n, int n2, int n3, int n4) {
        this.drawLine(n, n2, n3, n4, this.drawByte);
    }

    @Override
    public void drawOval(int n, int n2, int n3, int n4) {
        System.out.println("drawOval nicht implementiert");
    }

    @Override
    public void drawPolygon(Polygon polygon) {
        this.drawPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    @Override
    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.drawPolyline(nArray, nArray2, n, this.drawByte);
        if (n > 2) {
            this.drawLine(nArray[0], nArray2[0], nArray[n - 1], nArray2[n - 1], this.drawByte);
        }
    }

    @Override
    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        this.drawPolyline(nArray, nArray2, n, this.drawByte);
    }

    @Override
    public void drawRect(int n, int n2, int n3, int n4) {
        this.drawLine(n, n2, n + n3, n2, this.drawByte);
        this.drawLine(n, n2 + n4, n + n3, n2 + n4, this.drawByte);
        this.drawLine(n, n2, n, n2 + n4, this.drawByte);
        this.drawLine(n + n3, n2 + n4, n + n3, n2 + n4, this.drawByte);
    }

    @Override
    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        System.out.println("drawRoundRect nicht implementiert");
    }

    @Override
    public void drawString(String string, int n, int n2) {
        FontMetrics fontMetrics = this.getFontMetrics(this.font);
        this.fillRect(n, n2 - fontMetrics.getAscent(), fontMetrics.stringWidth(string), fontMetrics.getHeight());
    }

    @Override
    public void fill3DRect(int n, int n2, int n3, int n4, boolean bl) {
        this.fillRect(n, n2, n3, n4, this.drawByte);
    }

    @Override
    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        System.out.println("fillArc nicht implementiert");
    }

    @Override
    public void fillOval(int n, int n2, int n3, int n4) {
        System.out.println("fillOval nicht implementiert");
    }

    @Override
    public void fillPolygon(Polygon polygon) {
        this.fillPolygon(polygon, this.drawByte);
    }

    @Override
    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.fillPolygon(new Polygon(nArray, nArray2, n));
    }

    @Override
    public void fillRect(int n, int n2, int n3, int n4) {
        this.fillRect(n, n2, n3, n4, this.drawByte);
    }

    @Override
    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        System.out.println("fillRoundRect nicht implementiert");
    }

    @Override
    public void finalize() {
        this.field = null;
        super.finalize();
    }

    @Override
    public Shape getClip() {
        return this.clip;
    }

    @Override
    public Rectangle getClipBounds() {
        return this.clip;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    @Override
    public void setClip(int n, int n2, int n3, int n4) {
        this.clip.x = n;
        this.clip.y = n2;
        this.clip.width = n3;
        this.clip.height = n4;
    }

    @Override
    public void setClip(Shape shape) {
        this.clip = shape.getBounds();
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
    }

    @Override
    public void setPaintMode() {
    }

    @Override
    public void setXORMode(Color color) {
    }

    @Override
    public void translate(int n, int n2) {
        this.startX = n;
        this.startY = n2;
    }

    public void fillPolygon(Polygon polygon, byte by) {
        this.drawPolygon(polygon);
        Rectangle rectangle = polygon.getBounds();
        int n = rectangle.x + rectangle.width;
        int n2 = rectangle.y + rectangle.height;
        for (int i = rectangle.x; i < n; ++i) {
            for (int j = rectangle.y; j < n2; ++j) {
                if (!polygon.contains(i, j)) continue;
                this.setPixel(i, j, by);
            }
        }
    }

    private void fillRect(int n, int n2, int n3, int n4, byte by) {
        n = Math.max(0, n + this.startX);
        n2 = Math.max(0, n2 + this.startY);
        int n5 = Math.min(n + n3, this.maxX);
        int n6 = Math.min(n2 + n4, this.maxY);
        for (int i = n; i < n5; ++i) {
            for (int j = n2; j < n6; ++j) {
                this.setPixel(i, j, by);
            }
        }
    }

    private void drawLine(int n, int n2, int n3, int n4, byte by) {
        double d = Math.sqrt((n3 - n) * (n3 - n) + (n4 - n2) * (n4 - n2));
        double d2 = (double)(n3 - n) / d;
        double d3 = (double)(n4 - n2) / d;
        int n5 = (int)Math.rint(d);
        for (int i = 0; i < n5; ++i) {
            this.setPixel(n + (int)Math.rint(d2 * (double)i), n2 + (int)Math.rint(d3 * (double)i), by);
        }
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n, byte by) {
        for (int i = 1; i < n; ++i) {
            this.drawLine(nArray[i - 1], nArray2[i - 1], nArray[i], nArray2[i], by);
        }
    }

    private void setPixel(int n, int n2, byte by) {
        if ((n += this.startX) < 0 || n >= this.maxX || (n2 += this.startY) < 0 || n2 >= this.maxY) {
            return;
        }
        if (this.field[n][n2] < by) {
            this.field[n][n2] = by;
        }
    }

    public byte getState(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        if (n3 >= 0) {
            var5_5 = Math.max(0, n);
            n6 = Math.min(n + n3, this.maxX);
        } else {
            var5_5 = Math.max(0, n + n3);
            n6 = Math.min(n, this.maxX);
        }
        if (n4 >= 0) {
            var7_7 = Math.max(0, n2);
            n5 = Math.min(n2 + n4, this.maxY);
        } else {
            var7_7 = Math.max(0, n2 + n4);
            n5 = Math.min(n2, this.maxY);
        }
        byte by = 0;
        for (int i = var5_5; i < n6; ++i) {
            for (int j = var7_7; j < n5; ++j) {
                by = (byte)Math.max(by, this.field[i][j]);
            }
            if (by != 99) continue;
            return by;
        }
        return by;
    }

    public boolean hasState(Rectangle rectangle, byte by) {
        return this.hasState(rectangle.x, rectangle.y, rectangle.width, rectangle.height, by);
    }

    public boolean hasState(int n, int n2, int n3, int n4, byte by) {
        int n5;
        int n6;
        if (n3 >= 0) {
            var6_6 = Math.max(0, n);
            n6 = Math.min(n + n3, this.maxX);
        } else {
            var6_6 = Math.max(0, n + n3);
            n6 = Math.min(n, this.maxX);
        }
        if (n4 >= 0) {
            var8_8 = Math.max(0, n2);
            n5 = Math.min(n2 + n4, this.maxY);
        } else {
            var8_8 = Math.max(0, n2 + n4);
            n5 = Math.min(n2, this.maxY);
        }
        for (int i = var6_6; i < n6; ++i) {
            for (int j = var8_8; j < n5; ++j) {
                if (this.field[i][j] < by) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasState(IInscription iInscription, byte by) {
        int n = iInscription.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = iInscription.getComponent(i);
            Rectangle rectangle = component.getBounds();
            if (rectangle.x < 0 || rectangle.x + rectangle.width > this.maxX) {
                return true;
            }
            if (rectangle.y < 0 || rectangle.y + rectangle.height > this.maxY) {
                return true;
            }
            if (!this.hasState(rectangle, by)) continue;
            return true;
        }
        return false;
    }

    public DrawFieldSearchResult getOptimizedPosition(IInscription iInscription, int n, int n2) {
        DrawFieldSearchResult drawFieldSearchResult = null;
        for (int i = n; i < n2; i += 2) {
            drawFieldSearchResult = this.getTextPosition(iInscription, i, i + 2, (byte)10);
            if (drawFieldSearchResult.locationFound()) {
                drawFieldSearchResult.setDistance(drawFieldSearchResult.getDistance() - n);
                return drawFieldSearchResult;
            }
            drawFieldSearchResult = this.getTextPosition(iInscription, i, i + 2, (byte)99);
            if (!drawFieldSearchResult.locationFound()) continue;
            drawFieldSearchResult.setDistance(drawFieldSearchResult.getDistance() - n);
            drawFieldSearchResult.setOverwrite(true);
            return drawFieldSearchResult;
        }
        return new DrawFieldSearchResult(n, false, false);
    }

    private DrawFieldSearchResult getTextPosition(IInscription iInscription, int n, int n2, byte by) {
        Object var5_5 = null;
        Point point = iInscription.getInsertPoint();
        int n3 = iInscription.getSize().height;
        int n4 = iInscription.getSize().width;
        for (int i = n; i <= n2; i += 2) {
            int n5;
            for (n5 = 0; n5 <= i; n5 += 2) {
                iInscription.computeOrientation(point.x + i, point.y - n3 / 2 + n5);
                iInscription.setLocation(point.x + i, point.y - n3 / 2 + n5);
                if (!this.hasState(iInscription, by)) {
                    return new DrawFieldSearchResult(i);
                }
                iInscription.computeOrientation(point.x + i, point.y - n3 / 2 - n5);
                iInscription.setLocation(point.x + i, point.y - n3 / 2 - n5);
                if (!this.hasState(iInscription, by)) {
                    return new DrawFieldSearchResult(i);
                }
                iInscription.computeOrientation(point.x - i - n4, point.y - n3 / 2 + n5);
                iInscription.setLocation(point.x - i - n4, point.y - n3 / 2 + n5);
                if (!this.hasState(iInscription, by)) {
                    return new DrawFieldSearchResult(i);
                }
                iInscription.computeOrientation(point.x - i - n4, point.y - n3 / 2 - n5);
                iInscription.setLocation(point.x - i - n4, point.y - n3 / 2 - n5);
                if (this.hasState(iInscription, by)) continue;
                return new DrawFieldSearchResult(i);
            }
            n5 = point.x - n4 / 2;
            for (int j = 0; j <= i; j += 2) {
                iInscription.computeOrientation(n5 + j + i, point.y - i - n3);
                iInscription.setLocation(n5 + j + i, point.y - i - n3);
                if (!this.hasState(iInscription, by)) {
                    return new DrawFieldSearchResult(i);
                }
                iInscription.computeOrientation(n5 + j - i, point.y - i - n3);
                iInscription.setLocation(n5 + j - i, point.y - i - n3);
                if (!this.hasState(iInscription, by)) {
                    return new DrawFieldSearchResult(i);
                }
                iInscription.computeOrientation(n5 + j + i, point.y + i);
                iInscription.setLocation(n5 + j + i, point.y + i);
                if (!this.hasState(iInscription, by)) {
                    return new DrawFieldSearchResult(i);
                }
                iInscription.computeOrientation(n5 + j - i, point.y + i);
                iInscription.setLocation(n5 + j - i, point.y + i);
                if (this.hasState(iInscription, by)) continue;
                return new DrawFieldSearchResult(i);
            }
        }
        return new DrawFieldSearchResult(n, false, false);
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
    }
}

