/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.ExceptionList;
import de.geocalc.awt.IBorder;
import de.geocalc.awt.IDialog;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IPanel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class ErrorDialog
extends IDialog
implements ActionListener {
    public static final String TITLE = "ErrorDialog";
    public static final String VERSION = "1.0.0";
    private static final String OK_COMMAND = "ok";
    private static final String DETAIL_COMMAND = "detail";
    private static final String DIALOG_TITLE = "Fehler";
    private static final String DEFAULT_MESSAGE = "Es sind Fehler aufgetreten!";
    private static final int MAX_TEXT_LENGTH = 80;
    private Button okButton;
    private TextArea textArea;
    private String message = null;
    private ExceptionList exceptionList = null;

    public ErrorDialog(IFrame iFrame) {
        this(iFrame, DIALOG_TITLE, DEFAULT_MESSAGE, null);
    }

    public ErrorDialog(IFrame iFrame, Exception exception) {
        this(iFrame, DIALOG_TITLE, exception.getMessage() != null ? exception.getMessage() : exception.getClass().getName(), null);
    }

    public ErrorDialog(IFrame iFrame, ExceptionList exceptionList) {
        this(iFrame, DIALOG_TITLE, DEFAULT_MESSAGE, exceptionList);
    }

    public ErrorDialog(IFrame iFrame, String string) {
        this(iFrame, DIALOG_TITLE, string, null);
    }

    public ErrorDialog(IFrame iFrame, String string, ExceptionList exceptionList) {
        this(iFrame, DIALOG_TITLE, string, exceptionList);
    }

    public ErrorDialog(IFrame iFrame, String string, String string2) {
        this(iFrame, string, string2, null);
    }

    public ErrorDialog(IFrame iFrame, String string, String string2, ExceptionList exceptionList) {
        super(iFrame, string, false);
        Enumeration enumeration;
        Object object;
        this.message = string2 != null ? string2 : "unbekannter Fehler";
        this.exceptionList = exceptionList;
        this.setLayout(new BorderLayout());
        IPanel iPanel = new IPanel(new BorderLayout());
        iPanel.setBorder(new IBorder(1));
        IPanel iPanel2 = new IPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        iPanel2.setLayout(gridBagLayout);
        if (string2.length() > 80 && string2.indexOf("\n") < 0) {
            Object object2;
            object = new Vector();
            enumeration = new StringTokenizer(this.message);
            StringBuffer stringBuffer = new StringBuffer();
            while (((StringTokenizer)enumeration).hasMoreTokens()) {
                object2 = ((StringTokenizer)enumeration).nextToken();
                if (stringBuffer.length() > 0 && stringBuffer.length() + ((String)object2).length() > 80) {
                    ((Vector)object).addElement(stringBuffer.toString());
                    stringBuffer.setLength(0);
                }
                stringBuffer.append((String)object2);
                stringBuffer.append(" ");
            }
            if (stringBuffer.length() > 0) {
                ((Vector)object).addElement(stringBuffer.toString());
            }
            object2 = ((Vector)object).elements();
            while (object2.hasMoreElements()) {
                Label label = new Label((String)object2.nextElement());
                gridBagLayout.setConstraints(label, gridBagConstraints);
                iPanel2.add(label);
                ++gridBagConstraints.gridy;
            }
        } else {
            object = new StringTokenizer(this.message, "\n\r\t");
            while (((StringTokenizer)object).hasMoreTokens()) {
                enumeration = new Label(((StringTokenizer)object).nextToken());
                gridBagLayout.setConstraints((Component)((Object)enumeration), gridBagConstraints);
                iPanel2.add((Component)((Object)enumeration));
                ++gridBagConstraints.gridy;
            }
        }
        iPanel.add("North", iPanel2);
        if (this.exceptionList != null && this.exceptionList.size() > 0) {
            this.textArea = new TextArea();
            object = new StringBuffer();
            enumeration = this.exceptionList.elements();
            while (enumeration.hasMoreElements()) {
                ((StringBuffer)object).append(((Exception)enumeration.nextElement()).getMessage());
                ((StringBuffer)object).append("\n");
            }
            this.textArea.setText(((StringBuffer)object).toString());
            this.textArea.setEditable(false);
            iPanel.add("Center", this.textArea);
        }
        this.add(iPanel);
        object = new Panel(new FlowLayout(1));
        this.okButton = new Button("OK");
        this.okButton.setActionCommand(OK_COMMAND);
        this.okButton.addActionListener(this);
        ((Container)object).add(this.okButton);
        this.add("South", (Component)object);
        this.pack();
        this.setResizable(this.exceptionList != null && this.exceptionList.size() > 0);
        this.setLocationOfParent(iFrame);
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        if (this.okButton != null) {
            this.okButton.requestFocus();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(OK_COMMAND)) {
            this.endDialog();
        }
    }

    @Override
    protected void doStandardAction() {
        this.endDialog();
    }

    @Override
    protected void doAbortAction() {
        this.endDialog();
    }
}

