/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import java.awt.Canvas;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.StringTokenizer;

public final class FlowText
extends Canvas {
    private static final int PREFERRED_WIDTH = 400;
    private String text;
    private int pos = -99;
    boolean isPreFormated = false;
    boolean isRezized = false;
    int lastWidth;
    int lastHeight;

    public FlowText(String string, boolean bl) {
        this(string, 400, bl);
    }

    public FlowText(String string, int n, boolean bl) {
        this.setText(string, bl);
        Dimension dimension = this.computePreferredSize(n > 0 ? n : 400);
        super.setMinimumSize(dimension);
        super.setPreferredSize(dimension);
    }

    private Dimension computePreferredSize(int n) {
        Font font = super.getFont();
        if (font == null) {
            font = new Font("Serif", 0, 12);
        }
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        int n2 = fontMetrics.stringWidth(" ");
        int n3 = 0;
        int n4 = fontMetrics.getHeight();
        int n5 = 0;
        if (this.text != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.text, this.isPreFormated ? "\n" : " \n", true);
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                if (string.equals("\n")) {
                    n3 = Math.max(n3, n5);
                    n4 += fontMetrics.getHeight();
                    n5 = 0;
                    continue;
                }
                if (string.equals(" ")) continue;
                int n6 = fontMetrics.stringWidth(string);
                if (n5 > 0) {
                    n5 += n2;
                }
                if (n5 + n6 > n) {
                    n3 = Math.max(n3, n5);
                    n4 += fontMetrics.getHeight();
                    n5 = n6;
                    n3 = Math.max(n3, n5);
                    continue;
                }
                n3 = Math.max(n3, n5 += n2 + n6);
            }
        } else {
            n3 = n2;
        }
        return new Dimension(n3 + 2, n4 + 2 * fontMetrics.getDescent());
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        Dimension dimension = this.computePreferredSize(n3);
        if (n3 == this.lastWidth && n4 == this.lastHeight) {
            super.setBounds(n, n2, n3, n4);
            this.isRezized = false;
        } else if (Math.abs(dimension.height - n4) > 2 || n3 < dimension.width) {
            super.setMinimumSize(dimension);
            super.setPreferredSize(dimension);
            super.setBounds(n, n2, n3, dimension.height);
            this.invalidate();
            this.isRezized = true;
        } else {
            super.setBounds(n, n2, n3, n4);
            this.isRezized = false;
        }
        this.lastWidth = n3;
        this.lastHeight = n4;
    }

    @Override
    public boolean isValid() {
        if (this.isRezized) {
            return false;
        }
        return super.isValid();
    }

    @Override
    public void validate() {
        if (this.isRezized) {
            this.isRezized = false;
            Container container = this.getParent();
            while (!(container instanceof Window)) {
                Container container2 = container.getParent();
                if (container2 == null) continue;
                container = container2;
            }
            if (container instanceof Window) {
                ((Window)container).pack();
            } else {
                container.doLayout();
            }
        }
        super.validate();
    }

    public void setText(String string, boolean bl) {
        this.isPreFormated = bl;
        this.setText(string);
    }

    private void setText(String string) {
        this.text = string;
    }

    public void setTextLocation(int n) {
        this.pos = n;
    }

    public int getTextLocation() {
        return this.pos;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.text == null) {
            return;
        }
        Font font = super.getFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        int n = fontMetrics.stringWidth(" ");
        int n2 = this.getSize().width - 2 * fontMetrics.getLeading();
        int n3 = 0;
        Point point = new Point(1, fontMetrics.getHeight());
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(this.text, this.isPreFormated ? "\n" : " \n", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.equals("\n")) {
                graphics.drawString(stringBuffer.toString(), point.x, point.y);
                stringBuffer = new StringBuffer();
                point.y += fontMetrics.getHeight();
                n3 = 0;
                continue;
            }
            if (string.equals(" ")) continue;
            int n4 = fontMetrics.stringWidth(string);
            if (n3 > 0) {
                n3 += n;
            }
            if (n3 + n4 > n2) {
                graphics.drawString(stringBuffer.toString(), point.x, point.y);
                stringBuffer = new StringBuffer(string);
                point.y += fontMetrics.getHeight();
                n3 = n4;
                continue;
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(string);
            n3 += n4;
        }
        graphics.drawString(stringBuffer.toString(), point.x, point.y);
    }

    @Override
    public String toString() {
        return new String("FlowText: " + this.text);
    }
}

