/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import java.awt.Adjustable;
import java.awt.Canvas;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.SystemColor;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class IAngleSlider
extends Canvas
implements Adjustable,
MouseListener,
MouseMotionListener {
    private int angle;
    private int lastAngle;
    private int prefSize;
    private AdjustmentListener adjustmentListener;
    private int CIRCLE_DIST;

    public IAngleSlider(int n) {
        this.lastAngle = this.angle = 0;
        this.prefSize = 140;
        this.adjustmentListener = null;
        this.CIRCLE_DIST = 5;
        this.angle = n;
        this.setForeground(SystemColor.controlText);
        this.setBackground(SystemColor.control);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void setValue(int n) {
        this.angle = n;
        this.repaint();
    }

    @Override
    public int getValue() {
        return this.angle;
    }

    @Override
    public void setVisibleAmount(int n) {
    }

    @Override
    public int getVisibleAmount() {
        return 360;
    }

    @Override
    public void setBlockIncrement(int n) {
    }

    @Override
    public int getBlockIncrement() {
        return 1;
    }

    @Override
    public void setUnitIncrement(int n) {
    }

    @Override
    public int getUnitIncrement() {
        return 1;
    }

    @Override
    public void setMinimum(int n) {
    }

    @Override
    public int getMinimum() {
        return 0;
    }

    @Override
    public void setMaximum(int n) {
    }

    @Override
    public int getMaximum() {
        return 360;
    }

    @Override
    public int getOrientation() {
        return 0;
    }

    @Override
    public void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.adjustmentListener = adjustmentListener;
    }

    @Override
    public void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        if (this.adjustmentListener == adjustmentListener) {
            adjustmentListener = null;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.prefSize, this.prefSize);
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        int n5 = Math.min(n3, n4);
        super.setBounds(n, n2, n5, n5);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseDragged(mouseEvent);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n;
        int n2 = this.getDistToMid(mouseEvent.getPoint());
        this.angle = n2 < (n = this.getRadius()) - this.CIRCLE_DIST ? this.getAngleToMid(mouseEvent.getPoint()) : (int)Math.rint((double)this.getAngleToMid(mouseEvent.getPoint()) / 45.0) * 45;
        this.repaint();
        if (this.adjustmentListener != null) {
            this.adjustmentListener.adjustmentValueChanged(new AdjustmentEvent(this, 601, 1, this.angle));
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.getDistToMid(mouseEvent.getPoint()) < this.getRadius() - this.CIRCLE_DIST) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private int getRadius() {
        Dimension dimension = this.getSize();
        return dimension.width / 2 - this.CIRCLE_DIST;
    }

    private int getDistToMid(Point point) {
        Dimension dimension = this.getSize();
        Point point2 = new Point(dimension.width / 2, dimension.width / 2);
        return (int)Math.sqrt((point2.x - point.x) * (point2.x - point.x) + (point2.y - point.y) * (point2.y - point.y));
    }

    private int getAngleToMid(Point point) {
        Dimension dimension = this.getSize();
        return (int)Math.rint(Math.atan2(point.x - dimension.width / 2, dimension.width / 2 - point.y) * 180.0 / Math.PI);
    }

    @Override
    public void update(Graphics graphics) {
        this.drawPfeil(graphics);
        this.lastAngle = this.angle;
    }

    @Override
    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        double d = (double)this.angle * Math.PI / 180.0;
        Point point = new Point(dimension.width / 2, dimension.width / 2);
        graphics.setColor(SystemColor.control);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(SystemColor.controlLtHighlight);
        graphics.drawOval(6, 6, dimension.width - 10, dimension.height - 10);
        graphics.drawOval(point.x - 4, point.y - 4, 8, 8);
        graphics.setColor(SystemColor.controlShadow);
        graphics.drawOval(5, 5, dimension.width - 10, dimension.height - 10);
        graphics.drawOval(point.x - 3, point.y - 3, 8, 8);
        double d2 = 0.7853981633974483;
        double d3 = this.getRadius();
        for (int i = 0; i < 9; ++i) {
            int n = (int)Math.rint(Math.sin(d2 * (double)i) * d3);
            int n2 = (int)Math.rint(Math.cos(d2 * (double)i) * d3);
            graphics.setColor(SystemColor.control);
            graphics.fillOval(point.x + n - 5, point.y + n2 - 5, 12, 12);
            graphics.setColor(SystemColor.controlShadow);
            graphics.fillOval(point.x + n - 1, point.y + n2 - 1, 6, 6);
            graphics.setColor(SystemColor.inactiveCaption);
            graphics.fillOval(point.x + n - 3, point.y + n2 - 3, 6, 6);
            graphics.setColor(SystemColor.controlText);
            graphics.drawOval(point.x + n - 3, point.y + n2 - 3, 6, 6);
            graphics.setColor(SystemColor.controlLtHighlight);
            graphics.drawLine(point.x + n, point.y + n2 - 1, point.x + n, point.y + n2);
        }
        this.drawPfeil(graphics);
    }

    private void drawPfeil(Graphics graphics) {
        Dimension dimension = this.getSize();
        Point point = new Point(dimension.width / 2, dimension.width / 2);
        double d = (double)(dimension.width - 10) / 2.0;
        double d2 = 0.0;
        for (int i = 0; i < 2; ++i) {
            if (i == 0) {
                d2 = (double)this.lastAngle * Math.PI / 180.0;
                graphics.setColor(SystemColor.control);
            } else {
                d2 = (double)this.angle * Math.PI / 180.0;
                graphics.setColor(SystemColor.controlShadow);
            }
            double d3 = (double)dimension.width / (double)this.prefSize;
            double d4 = d - 7.0;
            double d5 = d - 13.0 * Math.sqrt(d3);
            double d6 = 0.12 / Math.sqrt(d3);
            Polygon polygon = new Polygon();
            polygon.addPoint(point.x + (int)Math.rint(Math.sin(d2) * d4), point.y - (int)Math.rint(Math.cos(d2) * d4));
            polygon.addPoint(point.x + (int)Math.rint(Math.sin(d2 + d6) * d5), point.y - (int)Math.rint(Math.cos(d2 + d6) * d5));
            polygon.addPoint(point.x + (int)Math.rint(Math.sin(d2 - d6) * d5), point.y - (int)Math.rint(Math.cos(d2 - d6) * d5));
            polygon.addPoint(point.x + (int)Math.rint(Math.sin(d2) * 8.0), point.y - (int)Math.rint(Math.cos(d2) * 8.0));
            graphics.translate(2, 2);
            graphics.fillPolygon(polygon.xpoints, polygon.ypoints, 3);
            graphics.drawLine(polygon.xpoints[0], polygon.ypoints[0], polygon.xpoints[3], polygon.ypoints[3]);
            graphics.translate(-2, -2);
            if (i == 1) {
                graphics.setColor(SystemColor.controlText);
            }
            graphics.fillPolygon(polygon.xpoints, polygon.ypoints, 3);
            graphics.drawLine(polygon.xpoints[0], polygon.ypoints[0], polygon.xpoints[3], polygon.ypoints[3]);
        }
    }
}

