/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;

public class IBorder {
    public static final int EMPTY = 0;
    public static final int ETCHED = 1;
    public static final int ETCHED_SMALL = 101;
    public static final int RAISED = 2;
    public static final int LOWERED = 3;
    public static final int SIMPLE = 4;
    private static final int MIN_SIZE = 1;
    private static final int MAX_SIZE = 50;
    Insets insets = new Insets(0, 0, 0, 0);
    private String text;
    private int border;
    private Rectangle r;
    private boolean isEnabled = true;

    public IBorder() {
        this(0, null);
    }

    public IBorder(int n) {
        this(n, null);
    }

    public IBorder(int n, String string) {
        this.border = n;
        this.text = string;
        if (string != null) {
            this.insets = new Insets(18, 10, 10, 10);
        } else {
            switch (n) {
                case 4: {
                    this.insets = new Insets(1, 1, 1, 1);
                }
                case 0: 
                case 2: 
                case 3: 
                case 101: {
                    this.insets = new Insets(4, 4, 4, 4);
                    break;
                }
                case 1: {
                    this.insets = new Insets(10, 10, 10, 10);
                }
            }
        }
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setBorderSize(int n) {
        if (n >= 1 && n <= 50) {
            this.insets = new Insets(this.insets.top + n, this.insets.left + n, this.insets.bottom + n, this.insets.right + n);
        }
    }

    public void repaint(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setClip(n, n2, n3, n4);
        n += this.insets.left / 2;
        n2 += this.insets.top / 2;
        n3 -= (this.insets.left + this.insets.right) / 2;
        n4 -= (this.insets.top + this.insets.bottom) / 2;
        switch (this.border) {
            case 0: {
                break;
            }
            case 4: {
                graphics.setColor(SystemColor.controlShadow);
                graphics.drawRect(n, n2, n3, n4);
                break;
            }
            case 1: 
            case 101: {
                graphics.setColor(SystemColor.control);
                graphics.draw3DRect(n - 1, n2 - 1, n3 + 2, n4 + 2, false);
                graphics.draw3DRect(n, n2, n3, n4, true);
                break;
            }
            case 2: {
                graphics.setColor(SystemColor.control);
                graphics.draw3DRect(n, n2, n3, n4, true);
                break;
            }
            case 3: {
                graphics.setColor(SystemColor.control);
                graphics.draw3DRect(n, n2, n3, n4, false);
            }
        }
        if (this.text != null) {
            Font font = graphics.getFont();
            FontMetrics fontMetrics = graphics.getFontMetrics(font);
            graphics.clearRect(n + 5, 0, fontMetrics.stringWidth(this.text) + 4, fontMetrics.getHeight() + 4);
            if (this.isEnabled()) {
                graphics.setColor(SystemColor.controlText);
                graphics.drawString(this.text, n + 7, (this.insets.top + fontMetrics.getHeight()) / 2 - 2);
            } else {
                graphics.setColor(SystemColor.controlLtHighlight);
                graphics.drawString(this.text, n + 8, (this.insets.top + fontMetrics.getHeight()) / 2 - 1);
                graphics.setColor(SystemColor.controlShadow);
                graphics.drawString(this.text, n + 7, (this.insets.top + fontMetrics.getHeight()) / 2 - 2);
            }
        }
    }
}

