/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.IBorderFloatColorizer;
import de.geocalc.awt.IColorButton;
import de.geocalc.awt.IColorHueSliderDialog;
import de.geocalc.awt.IColorizer;
import de.geocalc.awt.IColorizerSlider;
import de.geocalc.awt.IFrame;
import de.geocalc.text.IFormat;
import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class IBorderColorizerSlider
extends IColorizerSlider
implements ActionListener,
TextListener,
Adjustable {
    private static final String OVER_COLOR = "\u00dcber dem Grenzwert";
    private static final String UNDER_COLOR = "Unter dem Grenzwert";
    private static final String IN_COLOR = "Grenzwert";
    private IBorderFloatColorizer colorizer;
    private AdjustmentListener adjustmentListener;
    private TextField valueField;
    private IColorButton bMin;
    private IColorButton bMax;
    private IColorButton bMid;

    public IBorderColorizerSlider() {
        this((IBorderFloatColorizer)null);
    }

    public IBorderColorizerSlider(IBorderFloatColorizer iBorderFloatColorizer) {
        this.colorizer = iBorderFloatColorizer;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.setLayout(gridBagLayout);
        Label label = null;
        this.bMax = new IColorButton(Color.getHSBColor(iBorderFloatColorizer.getMaxHue(), 1.0f, 1.0f));
        this.add(this.bMax);
        this.bMax.setActionCommand(OVER_COLOR);
        this.bMax.addActionListener(this);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.bMax, gridBagConstraints);
        label = new Label(OVER_COLOR);
        this.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.bMin = new IColorButton(Color.getHSBColor(iBorderFloatColorizer.getMinHue(), 1.0f, 1.0f));
        this.add(this.bMin);
        this.bMin.setActionCommand(UNDER_COLOR);
        this.bMin.addActionListener(this);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.bMin, gridBagConstraints);
        label = new Label(UNDER_COLOR);
        this.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.bMid = new IColorButton(Color.getHSBColor(iBorderFloatColorizer.getMidHue(), 1.0f, 1.0f));
        this.add(this.bMid);
        this.bMid.setActionCommand(IN_COLOR);
        this.bMid.addActionListener(this);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.bMid, gridBagConstraints);
        label = new Label(IN_COLOR);
        this.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.valueField = new TextField(IFormat.f_1.format(iBorderFloatColorizer.getMaxBorder()));
        this.add(this.valueField);
        this.valueField.addTextListener(this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.valueField, gridBagConstraints);
        label = new Label("%");
        this.add(label);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(label, gridBagConstraints);
    }

    @Override
    public void textValueChanged(TextEvent textEvent) {
        try {
            this.colorizer.setBorderScale(new Float(this.valueField.getText().trim()).floatValue());
            this.valueField.setForeground(Color.black);
            if (this.adjustmentListener != null) {
                this.adjustmentListener.adjustmentValueChanged(new AdjustmentEvent(this, 601, 5, 0));
            }
        }
        catch (Exception exception) {
            this.valueField.setForeground(Color.red);
        }
    }

    public IFrame getParentFrame() {
        Container container;
        Object var1_1 = null;
        for (container = this.getParent(); container != null && !(container instanceof IFrame); container = container.getParent()) {
        }
        return container instanceof IFrame ? (IFrame)container : null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        IFrame iFrame = this.getParentFrame();
        if (iFrame == null) {
            return;
        }
        String string = actionEvent.getActionCommand();
        IColorHueSliderDialog iColorHueSliderDialog = new IColorHueSliderDialog(iFrame, "Farbwert (" + actionEvent.getActionCommand() + ")");
        if (string.equals(OVER_COLOR)) {
            iColorHueSliderDialog.setValue(this.colorizer.getMaxHue());
        } else if (string.equals(UNDER_COLOR)) {
            iColorHueSliderDialog.setValue(this.colorizer.getMinHue());
        } else if (string.equals(IN_COLOR)) {
            iColorHueSliderDialog.setValue(this.colorizer.getMidHue());
        }
        iColorHueSliderDialog.setVisible(true);
        if (iColorHueSliderDialog.getReturnType() == 1) {
            if (string.equals(OVER_COLOR)) {
                this.colorizer.setMaxHue(iColorHueSliderDialog.getValue());
                this.bMax.setColor(Color.getHSBColor(this.colorizer.getMaxHue(), 1.0f, 1.0f));
            } else if (string.equals(UNDER_COLOR)) {
                this.colorizer.setMinHue(iColorHueSliderDialog.getValue());
                this.bMin.setColor(Color.getHSBColor(this.colorizer.getMinHue(), 1.0f, 1.0f));
            } else if (string.equals(IN_COLOR)) {
                this.colorizer.setMidHue(iColorHueSliderDialog.getValue());
                this.bMid.setColor(Color.getHSBColor(this.colorizer.getMidHue(), 1.0f, 1.0f));
            }
            if (this.adjustmentListener != null) {
                this.adjustmentListener.adjustmentValueChanged(new AdjustmentEvent(this, 601, 5, 0));
            }
        }
    }

    @Override
    public int getOrientation() {
        return 0;
    }

    @Override
    public void setMinimum(int n) {
    }

    @Override
    public int getMinimum() {
        return 0;
    }

    @Override
    public void setMaximum(int n) {
    }

    @Override
    public int getMaximum() {
        return 1;
    }

    @Override
    public void setUnitIncrement(int n) {
    }

    @Override
    public int getUnitIncrement() {
        return 1;
    }

    @Override
    public void setBlockIncrement(int n) {
    }

    @Override
    public int getBlockIncrement() {
        return 1;
    }

    @Override
    public void setVisibleAmount(int n) {
    }

    @Override
    public int getVisibleAmount() {
        return 1;
    }

    @Override
    public void setValue(int n) {
    }

    @Override
    public int getValue() {
        return 1;
    }

    @Override
    public void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.adjustmentListener = adjustmentListener;
    }

    @Override
    public void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        if (this.adjustmentListener == adjustmentListener) {
            this.adjustmentListener = null;
        }
    }

    private void setColorizerParameter() {
    }

    @Override
    public void setColorizer(IColorizer iColorizer) {
    }
}

