/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.IBorderColorizerSlider;
import de.geocalc.awt.IColorizer;
import de.geocalc.awt.IColorizerSlider;
import de.geocalc.awt.IFloatColorizer;
import java.awt.Color;
import java.util.StringTokenizer;

public class IBorderFloatColorizer
extends IFloatColorizer {
    private double a = 1.0;
    private float midHue;

    public IBorderFloatColorizer() {
    }

    public IBorderFloatColorizer(float f, float f2, float f3, double d) {
        this.setHue(f, f3);
        this.midHue = f2;
        this.setBorderScale((float)d);
    }

    @Override
    public IColorizerSlider getSlider() {
        return new IBorderColorizerSlider(this);
    }

    @Override
    public Object clone() {
        IBorderFloatColorizer iBorderFloatColorizer = new IBorderFloatColorizer();
        iBorderFloatColorizer.minHue = this.minHue;
        iBorderFloatColorizer.midHue = this.midHue;
        iBorderFloatColorizer.maxHue = this.maxHue;
        iBorderFloatColorizer.minSaturation = this.minSaturation;
        iBorderFloatColorizer.maxSaturation = this.maxSaturation;
        iBorderFloatColorizer.minBrightness = this.minBrightness;
        iBorderFloatColorizer.maxBrightness = this.maxBrightness;
        iBorderFloatColorizer.a = this.a;
        iBorderFloatColorizer.minValue = this.minValue;
        iBorderFloatColorizer.maxValue = this.maxValue;
        iBorderFloatColorizer.minBorder = this.minBorder;
        iBorderFloatColorizer.maxBorder = this.maxBorder;
        return iBorderFloatColorizer;
    }

    @Override
    public void copyParameters(IColorizer iColorizer) {
        IBorderFloatColorizer iBorderFloatColorizer = (IBorderFloatColorizer)iColorizer;
        iBorderFloatColorizer.a = this.a;
        iBorderFloatColorizer.minHue = this.minHue;
        iBorderFloatColorizer.midHue = this.midHue;
        iBorderFloatColorizer.maxHue = this.maxHue;
        iBorderFloatColorizer.minBorder = this.minBorder;
        iBorderFloatColorizer.maxBorder = this.maxBorder;
    }

    @Override
    public void setExtends(double d, double d2) {
        double d3 = Math.max(Math.abs(d), Math.abs(d2));
        this.minValue = -d3;
        this.maxValue = d3;
    }

    public float getMidHue() {
        return this.midHue;
    }

    public void setMidHue(float f) {
        this.midHue = f;
    }

    @Override
    public void setBorderScale(float f) {
        f = Math.abs(f);
        this.maxBorder = f;
        this.minBorder = -f;
    }

    @Override
    public float getBorderScale() {
        return (float)this.maxBorder;
    }

    @Override
    public void setParameter(double d, double d2) {
    }

    @Override
    public Color getColor(double d) {
        d = Math.min(d, this.maxValue);
        d = Math.max(d, this.minValue);
        float f = 0.0f;
        if (d > this.maxBorder) {
            f = (float)((d - this.maxBorder) / (this.maxValue - this.maxBorder));
        } else if (d < this.minBorder) {
            f = (float)(-((d - this.minBorder) / (this.minValue - this.minBorder)));
        }
        return this.getSpectrum(this.getValue(f));
    }

    @Override
    public float getValue(float f) {
        return f;
    }

    @Override
    public Color getSpectrum(float f) {
        float f2 = 0.0f;
        f2 = f < 0.0f ? this.minHue : (f > 0.0f ? this.maxHue : this.midHue);
        return Color.getHSBColor(f2, 0.65f, 1.0f);
    }

    @Override
    public String getParameterString() {
        return this.minHue + "," + this.midHue + "," + this.maxHue + "," + (float)this.maxBorder + "," + (float)this.a;
    }

    @Override
    public void parseParameterString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.hasMoreTokens()) {
            this.minHue = new Float(stringTokenizer.nextToken()).floatValue();
        }
        if (stringTokenizer.hasMoreTokens()) {
            this.midHue = new Float(stringTokenizer.nextToken()).floatValue();
        }
        if (stringTokenizer.hasMoreTokens()) {
            this.maxHue = new Float(stringTokenizer.nextToken()).floatValue();
        }
        if (stringTokenizer.hasMoreTokens()) {
            this.maxBorder = new Float(stringTokenizer.nextToken()).doubleValue();
        }
        if (stringTokenizer.hasMoreTokens()) {
            this.a = new Float(stringTokenizer.nextToken()).doubleValue();
        }
        this.minBorder = -this.maxBorder;
    }
}

