/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.ICanvas;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;

public class IButton
extends ICanvas {
    private static final int WIDTH = 28;
    private static final int HEIGHT = 28;
    public static final int TEXT = 0;
    public static final int MOUSE = 1;
    public static final int CENTER = 2;
    public static final int ZOOM = 3;
    public static final int ELLIPSE = 4;
    public static final int CIRCLE = 5;
    public static final int RULER = 6;
    public static final int AMOUNT = 7;
    public static final int CLIP = 8;
    public static final int PENCIL = 9;
    public static final int FILE_NEW = 101;
    public static final int FILE_OPEN = 102;
    public static final int FILE_RELOAD = 103;
    public static final int FILE_IMPORT = 104;
    public static final int FILE_EXPORT = 105;
    public static final int FILE_SAVE = 106;
    public static final int FILE_CLOSE = 107;
    public static final int FILE_TRAFO = 108;
    public static final int MOD_PUNKTART = 201;
    public static final int MOD_POLAR = 202;
    public static final int MOD_ORTHO = 203;
    public static final int MOD_BEDINGUNG = 204;
    public static final int MOD_FLAECHE = 205;
    public static final int MOD_PUNKTTX = 206;
    public static final int MOD_MASZE = 207;
    public static final int MOD_ELLIPSE = 208;
    public static final int MOD_GITTER = 209;
    public static final int MOD_INFOTEXT = 210;
    public static final int MOD_IMAGE = 211;
    public static final int SYMBOL = 301;
    public static final int PUNKT = 302;
    public static final int LINIE = 303;
    public static final int LINIE_TEILEN = 3031;
    public static final int LINIE_VERBINDEN = 3032;
    public static final int MESSUNG = 304;
    public static final int BEDINGUNG = 305;
    public static final int OBJECT = 310;
    public static final int OBJECT_TEILEN = 3101;
    public static final int OBJECT_VERBINDEN = 3102;
    public static final int FLST = 311;
    public static final int NUTZ = 312;
    public static final int BODEN = 313;
    public static final int RECHT = 314;
    public static final int GEB = 315;
    public static final int TOP = 316;
    public static final int BEMERKUNG = 321;
    public static final int BOGEN = 331;
    public static final int AREA = 332;
    public static final int POLY = 333;
    public static final int GPS = 421;
    public static final int POLAR = 422;
    public static final int ORTHO = 423;
    public static final int FLUCHT = 424;
    public static final int STRECKE = 425;
    public static final int BOGENSCHLAG = 426;
    public static final int PUNKTMOVE = 461;
    public static final int IDENT = 462;
    public static final int GERADE = 463;
    public static final int RECHTER_WINKEL = 464;
    public static final int PARALLELE = 465;
    public static final int ABST_GERADE = 466;
    public static final int ABST_PUNKT = 467;
    public static final int KREISBOGEN = 468;
    public static final int CROSSHAIR = 901;
    public static final int SWITCH = 902;
    public static final int NEW = 903;
    public static final int NUMMER = 904;
    public static final int IMAGE = 1001;
    public static final int ARROW_NORTH = 1102;
    public static final int ARROW_WEST = 1104;
    public static final int ARROW_EAST = 1106;
    public static final int ARROW_SOUTH = 1108;
    public static final int ARROW_RIGHT_NORTH = 1201;
    public static final int ARROW_RIGHT_EAST = 1202;
    public static final int ARROW_RIGHT_SOUTH = 1203;
    public static final int ARROW_RIGHT_WEST = 1204;
    public static final int ARROW_LEFT_NORTH = 1205;
    public static final int ARROW_LEFT_EAST = 1206;
    public static final int ARROW_LEFT_SOUTH = 1207;
    public static final int ARROW_LEFT_WEST = 1208;
    public static final int YES = 2001;
    public static final int NO = 2002;
    public static final int YES_NO = 2003;
    private static Font FONT = new Font("Dialog", 0, 12);
    protected int id;
    protected boolean state = false;
    protected boolean raised = false;
    protected boolean isEnabled = true;
    protected String actionCommand;
    protected String text;
    protected String toolTipText;
    protected ActionListener actionListener;

    public IButton(int n) {
        this(n, null);
    }

    public IButton(int n, String string) {
        this.id = n;
        this.actionCommand = string;
        this.enableEvents(16L);
    }

    public IButton(String string) {
        this(string, string);
    }

    public IButton(String string, String string2) {
        this.id = 0;
        this.text = string;
        this.actionCommand = string2;
        this.enableEvents(16L);
    }

    public void setState(boolean bl) {
        this.state = bl;
        this.repaint();
    }

    public boolean getState() {
        return this.state;
    }

    protected void setRaised(boolean bl) {
        this.raised = bl;
        this.repaint();
    }

    protected boolean getRaised() {
        return this.raised;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
        if (bl) {
            this.enableEvents(16L);
        } else {
            this.disableEvents(16L);
        }
        this.repaint();
    }

    public void setText(String string) {
        this.text = string;
        this.repaint();
    }

    public String getText() {
        return this.text;
    }

    public boolean getEnabled() {
        return this.isEnabled;
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.id == 0) {
            Font font = this.getFont();
            if (font == null) {
                font = FONT;
            }
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
            return new Dimension(Math.max(28, fontMetrics.stringWidth(this.text) + 8), 28);
        }
        return new Dimension(28, 28);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    private void drawString(Graphics graphics, String string) {
        Font font = this.getFont() != null ? this.getFont() : FONT;
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getHeight();
        graphics.setFont(font);
        graphics.drawString(string, -n / 2, -n2 / 2 + fontMetrics.getAscent());
    }

    @Override
    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(SystemColor.control);
        int n = 0;
        if (this.isEnabled) {
            if (this.state) {
                graphics.draw3DRect(0, 0, dimension.width - 1, dimension.height - 1, false);
                ++n;
            } else if (this.raised) {
                graphics.fill3DRect(0, 0, dimension.width, dimension.height, true);
            } else {
                graphics.fillRect(0, 0, dimension.width, dimension.height);
            }
        } else {
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        graphics.translate(dimension.width / 2 + n, dimension.height / 2 + n);
        boolean bl = true;
        for (int i = 0; i < 2; ++i) {
            SystemColor systemColor;
            SystemColor systemColor2;
            if (this.isEnabled) {
                if (this.state || this.raised) {
                    systemColor2 = SystemColor.controlLtHighlight;
                    systemColor = SystemColor.activeCaption;
                } else {
                    systemColor2 = SystemColor.controlHighlight;
                    systemColor = SystemColor.inactiveCaption;
                }
            } else if (i == 0) {
                graphics.translate(1, 1);
                systemColor2 = SystemColor.control;
                systemColor = SystemColor.controlLtHighlight;
            } else {
                graphics.translate(-1, -1);
                systemColor2 = SystemColor.control;
                systemColor = SystemColor.controlShadow;
                bl = false;
            }
            switch (this.id) {
                case 0: {
                    graphics.setColor(systemColor);
                    this.drawString(graphics, this.text);
                    break;
                }
                case 1: {
                    Object object = new int[]{-4, -4, -2, 2, 5, 1, 4};
                    int[] nArray = new int[]{-8, 2, 0, 8, 7, -1, -3};
                    if (bl) {
                        graphics.setColor(systemColor2);
                        graphics.fillPolygon((int[])object, nArray, 7);
                    }
                    graphics.setColor(systemColor);
                    graphics.drawPolygon((int[])object, nArray, 7);
                    break;
                }
                case 2: {
                    if (bl) {
                        graphics.setColor(systemColor2);
                        graphics.fillOval(-5, -5, 10, 10);
                    }
                    graphics.setColor(systemColor);
                    graphics.drawOval(-8, -8, 16, 16);
                    graphics.drawOval(-5, -5, 10, 10);
                    graphics.drawLine(-9, 0, 9, 0);
                    graphics.drawLine(0, -9, 0, 9);
                    break;
                }
                case 3: {
                    Object object = new int[]{3, 7, 9, 5};
                    int[] nArray = new int[]{4, 8, 6, 2};
                    if (bl) {
                        graphics.setColor(systemColor2);
                        graphics.fillOval(-5, -5, 10, 10);
                    }
                    graphics.setColor(systemColor);
                    graphics.drawOval(-5, -5, 10, 10);
                    graphics.fillPolygon((int[])object, nArray, 4);
                    break;
                }
                case 4: {
                    if (bl) {
                        graphics.setColor(systemColor2);
                        graphics.fillArc(-8, -4, 16, 8, 0, 360);
                    }
                    graphics.setColor(systemColor);
                    graphics.drawArc(-8, -4, 16, 8, 0, 360);
                    graphics.drawLine(0, -4, 0, -8);
                    graphics.drawLine(0, 4, 0, 8);
                    graphics.drawLine(-1, -7, 1, -7);
                    graphics.drawLine(-1, 7, 1, 7);
                    break;
                }
                case 5: {
                    if (bl) {
                        graphics.setColor(systemColor2);
                        graphics.fillArc(-10, 10, 20, 20, 0, 45);
                    }
                    graphics.setColor(systemColor);
                    graphics.drawArc(-10, 10, 20, 20, 0, 45);
                    graphics.drawLine(-8, 5, 8, 5);
                    graphics.drawLine(-8, 5, 3, 6);
                    break;
                }
                case 6: {
                    Object object = new int[]{-9, 5, 9, -5};
                    int[] nArray = new int[]{-5, 9, 5, -9};
                    if (bl) {
                        graphics.setColor(systemColor2);
                        graphics.fillPolygon((int[])object, nArray, 4);
                    }
                    graphics.setColor(systemColor);
                    graphics.drawPolygon((int[])object, nArray, 4);
                    graphics.drawLine(-6, -2, -4, -4);
                    graphics.drawLine(-3, 1, -1, -1);
                    graphics.drawLine(0, 4, 2, 2);
                    graphics.drawLine(3, 7, 5, 5);
                    break;
                }
                case 7: {
                    Object object = new int[]{-3, 1, 6, 4, 6, 0, -4, -4, -9, -4};
                    int[] nArray = new int[]{-9, -4, -6, 0, 6, 3, 9, 3, 0, -2};
                    if (bl) {
                        graphics.setColor(systemColor2);
                        graphics.fillPolygon((int[])object, nArray, 10);
                    }
                    graphics.setColor(systemColor);
                    graphics.drawPolygon((int[])object, nArray, 10);
                    break;
                }
                case 8: {
                    if (bl) {
                        graphics.setColor(systemColor2);
                        graphics.fillRect(-7, -8, 14, 16);
                    }
                    graphics.setColor(systemColor);
                    graphics.drawRect(-7, -8, 14, 16);
                    break;
                }
                case 9: {
                    Object object = new int[]{-8, 2, 4, 6, 6, -4, -4, -6};
                    int[] nArray = new int[]{-4, 6, 6, 4, 2, -8, -6, -4};
                    if (bl) {
                        graphics.setColor(systemColor2);
                        graphics.fillPolygon((int[])object, nArray, 8);
                    }
                    graphics.setColor(systemColor);
                    graphics.drawLine(-4, -8, -6, -8);
                    graphics.drawLine(-6, -8, -8, -6);
                    graphics.drawLine(-8, -6, -8, -4);
                    graphics.drawLine(-6, -4, 4, 6);
                    graphics.drawLine(-4, -6, 6, 4);
                    graphics.drawLine(2, 6, 8, 8);
                    graphics.drawLine(6, 2, 8, 8);
                    graphics.drawPolygon((int[])object, nArray, 8);
                    break;
                }
                case 101: {
                    Object object = new int[]{-5, 1, 1, 5, 5, -5};
                    int[] nArray = new int[]{-7, -7, -3, -3, 7, 7};
                    if (bl) {
                        graphics.setColor(systemColor2);
                        graphics.fillPolygon((int[])object, nArray, 6);
                    }
                    graphics.setColor(systemColor);
                    graphics.drawPolygon((int[])object, nArray, 6);
                    graphics.drawLine(1, -7, 5, -3);
                    break;
                }
                case 102: {
                    Object object = new int[]{-6, -6, -4, 0, 2, 6, 6};
                    int[] nArray = new int[]{6, -3, -5, -5, -3, -3, 0};
                    if (bl) {
                        graphics.setColor(systemColor2);
                        graphics.fillPolygon((int[])object, nArray, 7);
                    }
                    graphics.setColor(systemColor);
                    graphics.drawPolygon((int[])object, nArray, 7);
                    object = new int[]{-2, 9, 6, -6};
                    nArray = new int[]{0, 0, 7, 7};
                    graphics.fillPolygon((int[])object, nArray, 4);
                    break;
                }
                case 103: {
                    Object object = new int[]{-5, 1, 1, 5, 5, -5};
                    int[] nArray = new int[]{-7, -7, -3, -3, 7, 7};
                    if (bl) {
                        graphics.setColor(systemColor2);
                        graphics.fillPolygon((int[])object, nArray, 6);
                    }
                    graphics.setColor(systemColor);
                    graphics.drawPolygon((int[])object, nArray, 6);
                    graphics.drawLine(1, -7, 5, -3);
                    graphics.drawArc(-3, -3, 6, 6, -45, 270);
                    object = new int[]{1, 5, 0};
                    nArray = new int[]{0, 5, 5};
                    graphics.fillPolygon((int[])object, nArray, 3);
                    break;
                }
                case 106: {
                    if (bl) {
                        graphics.setColor(systemColor);
                        graphics.fillRect(-7, -7, 14, 14);
                    }
                    graphics.drawRect(-7, -7, 14, 14);
                    graphics.fillRect(-4, 2, 6, 5);
                    graphics.setColor(systemColor2);
                    graphics.fillRect(2, 2, 3, 5);
                    graphics.fillRect(-5, -6, 11, 7);
                    graphics.drawLine(-4, 3, -4, 5);
                    graphics.drawLine(-4, 2, 3, 2);
                    break;
                }
                case 104: {
                    Object object = new int[]{-5, 1, 1, 5, 5, -5};
                    int[] nArray = new int[]{-7, -7, -3, -3, 7, 7};
                    if (bl) {
                        graphics.setColor(systemColor2);
                        graphics.fillPolygon((int[])object, nArray, 6);
                    }
                    graphics.setColor(systemColor);
                    graphics.drawPolygon((int[])object, nArray, 6);
                    graphics.drawLine(1, -7, 5, -3);
                    object = new int[]{-1, 1, 1, 3, 0, -3, -1};
                    nArray = new int[]{-8, -8, -3, -3, 3, -3, -3};
                    graphics.fillPolygon((int[])object, nArray, 7);
                    break;
                }
                case 105: {
                    Object object = new int[]{-5, 2, 1, 5, 5, -5};
                    int[] nArray = new int[]{-7, -7, -3, -3, 7, 7};
                    if (bl) {
                        graphics.setColor(systemColor2);
                        graphics.fillPolygon((int[])object, nArray, 6);
                    }
                    graphics.setColor(systemColor);
                    graphics.drawPolygon((int[])object, nArray, 6);
                    graphics.drawLine(1, -7, 5, -3);
                    object = new int[]{0, 3, 1, 1, -1, -1, -3};
                    nArray = new int[]{-8, -2, -2, 3, 3, -2, -2};
                    graphics.fillPolygon((int[])object, nArray, 7);
                    break;
                }
                case 108: {
                    Object object = new int[]{-5, 5, 5, 1, 1, -2, -2, -5};
                    int[] nArray = new int[]{-7, -7, -4, -4, 7, 7, -4, -4};
                    graphics.setColor(systemColor);
                    graphics.fillPolygon((int[])object, nArray, ((int[])object).length);
                    break;
                }
                case 107: {
                    Object object = new int[]{-5, 1, 1, 5, 5, -5};
                    int[] nArray = new int[]{-7, -7, -3, -3, 7, 7};
                    if (bl) {
                        graphics.setColor(systemColor2);
                        graphics.fillPolygon((int[])object, nArray, 6);
                    }
                    graphics.setColor(systemColor);
                    graphics.drawPolygon((int[])object, nArray, 6);
                    graphics.drawLine(1, -7, 5, -3);
                    object = new int[]{-7, -6, 7, 6};
                    nArray = new int[]{-6, -7, 6, 7};
                    graphics.fillPolygon((int[])object, nArray, 4);
                    object = new int[]{6, 7, -6, -7};
                    nArray = new int[]{-7, -6, 7, 6};
                    graphics.fillPolygon((int[])object, nArray, 4);
                    break;
                }
                case 201: {
                    if (bl) {
                        graphics.setColor(systemColor2);
                        graphics.fillRect(-6, -6, 12, 12);
                    }
                    graphics.setColor(systemColor);
                    graphics.drawRect(-6, -6, 12, 12);
                    graphics.fillRect(-1, -1, 2, 2);
                    break;
                }
                case 202: {
                    Object object = new int[]{-2, 2, 6};
                    int[] nArray = new int[]{2, -2, 6};
                    graphics.setColor(systemColor);
                    graphics.fillPolygon((int[])object, nArray, ((int[])object).length);
                    graphics.drawLine(0, 0, -6, -6);
                    break;
                }
                case 203: 
                case 423: {
                    graphics.setColor(systemColor);
                    graphics.drawOval(-7, 5, 2, 2);
                    graphics.drawOval(5, -7, 2, 2);
                    graphics.drawOval(5, 5, 2, 2);
                    graphics.drawLine(-5, 5, 5, -5);
                    graphics.drawLine(0, 0, 5, 5);
                    graphics.drawLine(-2, 2, 2, 2);
                    break;
                }
                case 204: {
                    graphics.setColor(systemColor);
                    graphics.drawOval(-9, -9, 2, 2);
                    graphics.drawOval(7, 7, 2, 2);
                    graphics.drawLine(-5, -5, -5, -3);
                    graphics.drawLine(-5, -5, -3, -5);
                    graphics.drawLine(5, 5, 5, 3);
                    graphics.drawLine(5, 5, 3, 5);
                    graphics.drawLine(-5, -5, 5, 5);
                    break;
                }
                case 205: {
                    Object object = new int[]{-3, 3, 2, 5, 4, -6};
                    int[] nArray = new int[]{-8, -7, 0, 1, 8, 6};
                    if (bl) {
                        graphics.setColor(systemColor2);
                        graphics.fillPolygon((int[])object, nArray, ((int[])object).length);
                    }
                    graphics.setColor(systemColor);
                    graphics.drawPolygon((int[])object, nArray, ((int[])object).length);
                    break;
                }
                case 206: {
                    graphics.setColor(systemColor);
                    graphics.drawString("Pnr", -9, 6);
                    break;
                }
                case 207: {
                    graphics.setColor(systemColor);
                    graphics.drawString("MZ", -8, 6);
                    break;
                }
                case 208: {
                    if (bl) {
                        graphics.setColor(systemColor2);
                        graphics.fillArc(-8, -4, 16, 8, 0, 360);
                    }
                    graphics.setColor(systemColor);
                    graphics.drawArc(-8, -4, 16, 8, 0, 360);
                    break;
                }
                case 209: {
                    graphics.setColor(systemColor);
                    graphics.drawLine(-3, -8, -3, 8);
                    graphics.drawLine(-8, -3, 8, -3);
                    graphics.drawLine(5, -8, 5, 8);
                    graphics.drawLine(-8, 5, 8, 5);
                    break;
                }
                case 210: {
                    if (bl) {
                        graphics.setColor(systemColor2);
                        graphics.fillRect(-7, -8, 14, 16);
                    }
                    graphics.setColor(systemColor);
                    graphics.drawRect(-7, -8, 14, 16);
                    graphics.drawLine(-5, -4, 5, -4);
                    graphics.drawLine(-5, -2, -1, -2);
                    graphics.drawLine(1, -2, 5, -2);
                    graphics.drawLine(-5, 0, 2, 0);
                    graphics.drawLine(-5, 2, 5, 2);
                    graphics.drawLine(-5, 4, 2, 4);
                    break;
                }
                case 301: {
                    if (bl) {
                        graphics.setColor(systemColor2);
                        graphics.fillRect(-5, -5, 10, 10);
                    }
                    graphics.setColor(systemColor);
                    graphics.drawRect(-5, -5, 10, 10);
                    graphics.fillRect(-1, -1, 2, 2);
                    break;
                }
                case 302: {
                    if (bl) {
                        graphics.setColor(systemColor2);
                        graphics.fillOval(-2, -2, 4, 4);
                    }
                    graphics.setColor(systemColor);
                    graphics.drawOval(-2, -2, 4, 4);
                    break;
                }
                case 303: {
                    if (bl) {
                        graphics.setColor(systemColor2);
                        graphics.fillOval(5, -8, 3, 3);
                        graphics.fillOval(-8, 5, 3, 3);
                    }
                    graphics.setColor(systemColor);
                    graphics.drawOval(5, -8, 3, 3);
                    graphics.drawOval(-8, 5, 3, 3);
                    graphics.drawLine(5, -5, -5, 5);
                    break;
                }
                case 3031: {
                    if (bl) {
                        graphics.setColor(systemColor2);
                        graphics.fillOval(5, -8, 3, 3);
                        graphics.fillOval(-8, 5, 3, 3);
                        graphics.fillOval(5, 5, 3, 3);
                    }
                    graphics.setColor(systemColor);
                    graphics.drawOval(5, -8, 3, 3);
                    graphics.drawOval(-8, 5, 3, 3);
                    graphics.drawOval(5, 5, 3, 3);
                    graphics.drawLine(-5, 7, -3, 7);
                    graphics.drawLine(-1, 7, 1, 7);
                    graphics.drawLine(3, 7, 5, 7);
                    graphics.drawLine(7, -5, 7, -3);
                    graphics.drawLine(7, -1, 7, 1);
                    graphics.drawLine(7, 3, 7, 5);
                    graphics.drawLine(-3, -3, 3, 3);
                    graphics.drawLine(3, 1, 3, 3);
                    graphics.drawLine(1, 3, 3, 3);
                    graphics.drawLine(5, -5, -5, 5);
                    break;
                }
                case 3032: {
                    if (bl) {
                        graphics.setColor(systemColor2);
                        graphics.fillOval(5, -8, 3, 3);
                        graphics.fillOval(-8, 5, 3, 3);
                        graphics.fillOval(5, 5, 3, 3);
                    }
                    graphics.setColor(systemColor);
                    graphics.drawOval(5, -8, 3, 3);
                    graphics.drawOval(-8, 5, 3, 3);
                    graphics.drawOval(5, 5, 3, 3);
                    graphics.drawLine(5, -5, 3, -3);
                    graphics.drawLine(1, -1, -1, 1);
                    graphics.drawLine(-3, 3, -5, 5);
                    graphics.drawLine(-3, -3, 3, 3);
                    graphics.drawLine(-3, -3, -1, -3);
                    graphics.drawLine(-3, -3, -3, -1);
                    graphics.drawLine(7, -5, 7, 5);
                    graphics.drawLine(-5, 7, 5, 7);
                    break;
                }
                case 304: {
                    if (bl) {
                        graphics.setColor(systemColor2);
                        graphics.fillOval(-2, -6, 4, 4);
                    }
                    graphics.setColor(systemColor);
                    graphics.drawOval(-2, -6, 4, 4);
                    graphics.drawLine(-8, 8, -3, -2);
                    graphics.drawLine(-6, 1, -3, -2);
                    graphics.drawLine(-4, 3, -3, -2);
                    graphics.drawLine(8, 8, 3, -2);
                    graphics.drawLine(6, 1, 3, -2);
                    graphics.drawLine(3, 3, 3, -2);
                    break;
                }
                case 305: {
                    graphics.setColor(systemColor);
                    graphics.drawOval(-7, -7, 2, 2);
                    graphics.drawOval(5, 5, 2, 2);
                    graphics.drawLine(-3, -3, -3, -1);
                    graphics.drawLine(-3, -3, -1, -3);
                    graphics.drawLine(3, 3, 3, 1);
                    graphics.drawLine(3, 3, 1, 3);
                    graphics.drawLine(-3, -3, 3, 3);
                    break;
                }
                case 310: {
                    if (bl) {
                        graphics.setColor(systemColor2);
                        graphics.fillRect(-6, -8, 13, 17);
                    }
                    graphics.setColor(systemColor);
                    graphics.drawOval(-7, -9, 2, 2);
                    graphics.drawOval(5, -9, 2, 2);
                    graphics.drawOval(5, 7, 2, 2);
                    graphics.drawOval(-7, 7, 2, 2);
                    graphics.drawLine(-4, -8, 4, -8);
                    graphics.drawLine(-4, 8, 4, 8);
                    graphics.drawLine(-6, -6, -6, 6);
                    graphics.drawLine(6, -6, 6, 6);
                    graphics.drawLine(-3, -1, -3, 4);
                    graphics.drawLine(-3, 4, 3, 4);
                    graphics.drawLine(3, 4, 3, -1);
                    graphics.drawLine(3, -1, -3, -1);
                    break;
                }
                case 3101: {
                    if (bl) {
                        graphics.setColor(systemColor2);
                        graphics.fillRect(-6, -8, 13, 17);
                    }
                    graphics.setColor(systemColor);
                    graphics.drawOval(-7, -9, 2, 2);
                    graphics.drawOval(5, -9, 2, 2);
                    graphics.drawOval(5, 7, 2, 2);
                    graphics.drawOval(-7, 7, 2, 2);
                    graphics.drawLine(-4, -8, 4, -8);
                    graphics.drawLine(-4, 8, 4, 8);
                    graphics.drawLine(-6, -6, -6, 6);
                    graphics.drawLine(6, -6, 6, 6);
                    graphics.drawLine(-4, 2, -3, 2);
                    graphics.drawLine(-1, 2, 1, 2);
                    graphics.drawLine(3, 2, 4, 2);
                    graphics.drawLine(-2, -3, 2, -3);
                    graphics.drawLine(0, -5, 0, -1);
                    break;
                }
                case 3102: {
                    if (bl) {
                        graphics.setColor(systemColor2);
                        graphics.fillRect(-6, -8, 13, 17);
                    }
                    graphics.setColor(systemColor);
                    graphics.drawOval(-7, -9, 2, 2);
                    graphics.drawOval(5, -9, 2, 2);
                    graphics.drawOval(5, 7, 2, 2);
                    graphics.drawOval(-7, 7, 2, 2);
                    graphics.drawLine(-4, -8, 4, -8);
                    graphics.drawLine(-4, 8, 4, 8);
                    graphics.drawLine(-6, -6, -6, 6);
                    graphics.drawLine(6, -6, 6, 6);
                    graphics.drawLine(-4, 2, -3, 2);
                    graphics.drawLine(-1, 2, 1, 2);
                    graphics.drawLine(3, 2, 4, 2);
                    graphics.drawLine(-2, -3, 2, -3);
                    break;
                }
                case 311: {
                    if (bl) {
                        graphics.setColor(systemColor2);
                        graphics.fillRect(-6, -8, 13, 17);
                    }
                    graphics.setColor(systemColor);
                    graphics.drawOval(-7, -9, 2, 2);
                    graphics.drawOval(5, -9, 2, 2);
                    graphics.drawOval(5, 7, 2, 2);
                    graphics.drawOval(-7, 7, 2, 2);
                    graphics.drawLine(-4, -8, 4, -8);
                    graphics.drawLine(-4, 8, 4, 8);
                    graphics.drawLine(-6, -6, -6, 6);
                    graphics.drawLine(6, -6, 6, 6);
                    graphics.drawLine(-1, -1, 0, -2);
                    graphics.drawLine(1, -3, 0, 2);
                    break;
                }
                case 312: 
                case 313: 
                case 314: {
                    if (bl) {
                        graphics.setColor(systemColor2);
                        graphics.fillRect(-8, -8, 16, 16);
                    }
                    graphics.setColor(systemColor);
                    graphics.drawLine(-7, -8, -6, -8);
                    graphics.drawLine(-2, -8, 2, -8);
                    graphics.drawLine(6, -8, 7, -8);
                    graphics.drawLine(7, -8, 7, -6);
                    graphics.drawLine(7, -2, 7, 2);
                    graphics.drawLine(7, 6, 7, 8);
                    graphics.drawLine(-7, 8, -6, 8);
                    graphics.drawLine(-2, 8, 2, 8);
                    graphics.drawLine(6, 8, 7, 8);
                    graphics.drawLine(-7, -8, -7, -6);
                    graphics.drawLine(-7, -2, -7, 2);
                    graphics.drawLine(-7, 6, -7, 8);
                    Object object = "";
                    if (this.id == 312) {
                        object = "N";
                    } else if (this.id == 313) {
                        object = "B";
                    } else if (this.id == 314) {
                        object = "R";
                    }
                    this.drawString(graphics, (String)object);
                    break;
                }
                case 315: {
                    int[] nArray = new int[]{-6, -6, 6, 6, 2, 2};
                    int[] nArray2 = new int[]{-6, 6, 6, -2, -2, -6};
                    if (bl) {
                        graphics.setColor(systemColor2);
                        graphics.fillPolygon(nArray, nArray2, nArray.length);
                    }
                    graphics.setColor(systemColor);
                    graphics.drawPolygon(nArray, nArray2, nArray.length);
                    graphics.drawLine(-4, -1, -1, -1);
                    graphics.drawLine(-4, 1, -1, 1);
                    break;
                }
                case 316: {
                    graphics.setColor(systemColor);
                    graphics.drawLine(-7, -7, 0, -7);
                    graphics.drawLine(0, -7, 0, 0);
                    graphics.drawLine(0, 0, 5, 0);
                    graphics.drawLine(5, 0, 5, 5);
                    break;
                }
                case 321: {
                    if (bl) {
                        graphics.setColor(systemColor2);
                        graphics.fillRect(-7, -8, 14, 16);
                    }
                    graphics.setColor(systemColor);
                    graphics.drawRect(-7, -8, 14, 16);
                    graphics.drawLine(-5, -4, 5, -4);
                    graphics.drawLine(-5, -2, -1, -2);
                    graphics.drawLine(1, -2, 5, -2);
                    graphics.drawLine(-5, 0, 2, 0);
                    graphics.drawLine(-5, 2, 5, 2);
                    graphics.drawLine(-5, 4, 2, 4);
                    break;
                }
                case 331: {
                    graphics.setColor(systemColor);
                    graphics.drawOval(-7, 0, 2, 2);
                    graphics.drawOval(5, 0, 2, 2);
                    graphics.drawArc(-6, -3, 12, 12, -190, -160);
                    break;
                }
                case 332: {
                    int[] nArray = new int[]{-6, -6, 6, 6, 2, 2};
                    int[] nArray2 = new int[]{-6, 6, 6, -2, -2, -6};
                    if (bl) {
                        graphics.setColor(systemColor2);
                        graphics.fillPolygon(nArray, nArray2, nArray.length);
                    }
                    graphics.setColor(systemColor);
                    graphics.drawPolygon(nArray, nArray2, nArray.length);
                    break;
                }
                case 333: {
                    int[] nArray = new int[]{-6, -2, 2, 6};
                    int[] nArray2 = new int[]{6, -6, 6, -6};
                    graphics.setColor(systemColor);
                    graphics.drawOval(-7, 6, 2, 2);
                    graphics.drawOval(5, -6, 2, 2);
                    graphics.drawLine(-6, 6, -2, -4);
                    graphics.drawLine(-2, -4, 2, 4);
                    graphics.drawLine(2, 4, 6, -6);
                    break;
                }
                case 901: {
                    graphics.setColor(systemColor);
                    graphics.drawLine(-5, 0, 5, 0);
                    graphics.drawLine(0, -5, 0, 5);
                    break;
                }
                case 421: {
                    if (bl) {
                        graphics.setColor(systemColor2);
                        graphics.fillOval(-2, 2, 3, 3);
                    }
                    graphics.setColor(systemColor);
                    graphics.drawOval(-2, 2, 3, 3);
                    int[] nArray = new int[]{-3, 3, 0};
                    int[] nArray2 = new int[]{-4, -4, 2};
                    graphics.fillPolygon(nArray, nArray2, nArray.length);
                    graphics.drawPolygon(nArray, nArray2, nArray.length);
                    break;
                }
                case 422: {
                    if (bl) {
                        graphics.setColor(systemColor2);
                        graphics.fillOval(6, 6, 3, 3);
                    }
                    int[] nArray = new int[]{0, 2, 5};
                    int[] nArray2 = new int[]{2, 0, 5};
                    graphics.setColor(systemColor);
                    graphics.drawOval(5, 5, 3, 3);
                    graphics.fillPolygon(nArray, nArray2, nArray.length);
                    graphics.drawPolygon(nArray, nArray2, nArray.length);
                    graphics.drawLine(0, 0, -4, -4);
                    break;
                }
                case 425: {
                    graphics.setColor(systemColor);
                    graphics.drawOval(-8, 6, 2, 2);
                    graphics.drawOval(6, -8, 2, 2);
                    graphics.drawLine(-6, 6, 6, -6);
                    break;
                }
                case 426: {
                    graphics.setColor(systemColor);
                    graphics.drawOval(-8, 6, 2, 2);
                    graphics.drawOval(6, 6, 2, 2);
                    graphics.drawLine(-6, 6, -1, -6);
                    graphics.drawLine(6, 6, 1, -6);
                    graphics.drawLine(-4, -9, 4, -5);
                    graphics.drawLine(4, -9, -4, -5);
                    break;
                }
                case 461: {
                    if (bl) {
                        graphics.setColor(systemColor2);
                        graphics.fillOval(-8, 4, 4, 4);
                    }
                    graphics.setColor(systemColor);
                    graphics.drawOval(-8, 4, 4, 4);
                    graphics.drawLine(-4, 4, 8, -8);
                    graphics.drawLine(8, -8, 3, -5);
                    graphics.drawLine(8, -8, 5, -3);
                    break;
                }
                case 462: {
                    if (bl) {
                        graphics.setColor(systemColor2);
                        graphics.fillOval(-8, 4, 4, 4);
                        graphics.fillOval(4, -8, 4, 4);
                    }
                    graphics.setColor(systemColor);
                    graphics.drawOval(-8, 4, 4, 4);
                    graphics.drawOval(4, -8, 4, 4);
                    graphics.drawLine(-4, 4, 4, -4);
                    graphics.drawLine(-2, 0, -2, 2);
                    graphics.drawLine(0, 2, -2, 2);
                    graphics.drawLine(0, -2, 2, -2);
                    graphics.drawLine(2, 0, 2, -2);
                    break;
                }
                case 424: 
                case 463: {
                    graphics.setColor(systemColor);
                    graphics.drawOval(-8, 6, 2, 2);
                    graphics.drawOval(-1, -1, 2, 2);
                    graphics.drawOval(6, -8, 2, 2);
                    graphics.drawLine(-6, 6, -2, 2);
                    graphics.drawLine(2, -2, 6, -6);
                    graphics.drawLine(-3, 3, -3, -3);
                    graphics.drawLine(-3, -3, 3, -3);
                    break;
                }
                case 464: {
                    graphics.setColor(systemColor);
                    graphics.drawOval(-4, 6, 2, 2);
                    graphics.drawOval(3, -1, 2, 2);
                    graphics.drawOval(-4, -8, 2, 2);
                    graphics.drawLine(-2, 6, 3, 1);
                    graphics.drawLine(-2, -6, 3, -1);
                    graphics.drawLine(1, 3, 1, -3);
                    break;
                }
                case 465: {
                    graphics.setColor(systemColor);
                    graphics.drawOval(-8, 2, 2, 2);
                    graphics.drawOval(2, -8, 2, 2);
                    graphics.drawOval(-4, 6, 2, 2);
                    graphics.drawOval(6, -4, 2, 2);
                    graphics.drawLine(-6, 2, 2, -6);
                    graphics.drawLine(-2, 6, 6, -2);
                    graphics.drawLine(-1, -1, 1, 1);
                    break;
                }
                case 466: {
                    graphics.setColor(systemColor);
                    graphics.drawOval(-8, 2, 2, 2);
                    graphics.drawOval(2, -8, 2, 2);
                    graphics.drawLine(-6, 2, 2, -6);
                    graphics.drawOval(4, 4, 2, 2);
                    graphics.drawLine(0, 0, 2, 2);
                    break;
                }
                case 467: {
                    graphics.setColor(systemColor);
                    graphics.drawOval(-6, -6, 2, 2);
                    graphics.drawOval(4, 4, 2, 2);
                    graphics.drawLine(-2, -2, 2, 2);
                    break;
                }
                case 468: {
                    graphics.setColor(systemColor);
                    graphics.drawArc(-7, -7, 14, 14, 65, 55);
                    graphics.drawArc(-7, -7, 14, 14, 155, 95);
                    graphics.drawOval(4, -6, 2, 2);
                    graphics.drawOval(-1, 6, 2, 2);
                    graphics.drawOval(-6, -6, 2, 2);
                    break;
                }
                case 902: {
                    graphics.setColor(systemColor);
                    graphics.drawLine(-3, 4, -3, 4);
                    graphics.drawLine(0, 4, 0, 4);
                    graphics.drawLine(3, 4, 3, 4);
                    break;
                }
                case 904: {
                    graphics.setColor(systemColor);
                    graphics.drawString("Nr.", -8, 5);
                    break;
                }
                case 211: 
                case 1001: {
                    int[] nArray = new int[]{-5, 1, 1, 5, 5, -5};
                    int[] nArray2 = new int[]{-7, -7, -3, -3, 7, 7};
                    if (bl) {
                        graphics.setColor(systemColor2);
                        graphics.fillPolygon(nArray, nArray2, 6);
                    }
                    graphics.setColor(systemColor);
                    graphics.drawPolygon(nArray, nArray2, 6);
                    graphics.drawLine(1, -7, 5, -3);
                    graphics.drawRect(-3, -5, 3, 3);
                    graphics.drawOval(0, -1, 3, 3);
                    int[] nArray3 = new int[]{-4, -2, 0};
                    int[] nArray4 = new int[]{5, 2, 5};
                    graphics.drawPolygon(nArray3, nArray4, 3);
                    break;
                }
                case 1102: {
                    this.paintPolygon(graphics, systemColor2, systemColor, bl, new int[]{0, 8, 4, 4, -4, -4, -8, 0}, new int[]{-8, 0, 0, 8, 8, 0, 0, -8});
                    break;
                }
                case 1104: {
                    this.paintPolygon(graphics, systemColor2, systemColor, bl, new int[]{-8, 0, 0, 8, 8, 0, 0, -8}, new int[]{0, -8, -4, -4, 4, 4, 8, 0});
                    break;
                }
                case 1106: {
                    this.paintPolygon(graphics, systemColor2, systemColor, bl, new int[]{8, 0, 0, -8, -8, 0, 0, 8}, new int[]{0, -8, -4, -4, 4, 4, 8, 0});
                    break;
                }
                case 1108: {
                    this.paintPolygon(graphics, systemColor2, systemColor, bl, new int[]{0, 8, 4, 4, -4, -4, -8, 0}, new int[]{8, 0, 0, -8, -8, 0, 0, 8});
                    break;
                }
                case 1201: {
                    this.paintPolygon(graphics, systemColor2, systemColor, bl, new int[]{0, 7, 3, 3, 4, 8, 8, 4, 1, -2, -3, -3, -7, 0}, new int[]{-9, -2, -2, 1, 2, 2, 8, 8, 7, 4, 1, -2, -2, -9});
                    break;
                }
                case 1202: {
                    this.paintPolygon(graphics, systemColor2, systemColor, bl, new int[]{9, 2, 2, -1, -2, -2, -8, -8, -7, -4, -1, 2, 2, 9}, new int[]{0, 7, 3, 3, 4, 8, 8, 4, 1, -2, -3, -3, -7, 0});
                    break;
                }
                case 1203: {
                    this.paintPolygon(graphics, systemColor2, systemColor, bl, new int[]{0, -7, -3, -3, -4, -8, -8, -4, -1, 2, 3, 3, 7, 0}, new int[]{9, 2, 2, -1, -2, -2, -8, -8, -7, -4, -1, 2, 2, 9});
                    break;
                }
                case 1204: {
                    this.paintPolygon(graphics, systemColor2, systemColor, bl, new int[]{-9, -2, -2, 1, 2, 2, 8, 8, 7, 4, 1, -2, -2, -9}, new int[]{0, -7, -3, -3, -4, -8, -8, -4, -1, 2, 3, 3, 7, 0});
                    break;
                }
                case 1205: {
                    this.paintPolygon(graphics, systemColor2, systemColor, bl, new int[]{0, 7, 3, 3, 2, -1, -4, -8, -8, -4, -3, -3, -7, 0}, new int[]{-9, -2, -2, 1, 4, 7, 8, 8, 2, 2, 1, -2, -2, -9});
                    break;
                }
                case 1206: {
                    this.paintPolygon(graphics, systemColor2, systemColor, bl, new int[]{9, 2, 2, -1, -4, -7, -8, -8, -2, -2, -1, 2, 2, 9}, new int[]{0, 7, 3, 3, 2, -1, -4, -8, -8, -4, -3, -3, -7, 0});
                    break;
                }
                case 1207: {
                    this.paintPolygon(graphics, systemColor2, systemColor, bl, new int[]{0, -7, -3, -3, -2, 1, 4, 8, 8, 4, 3, 3, 7, 0}, new int[]{9, 2, 2, -1, -4, -7, -8, -8, -2, -2, -1, 2, 2, 9});
                    break;
                }
                case 1208: {
                    this.paintPolygon(graphics, systemColor2, systemColor, bl, new int[]{-9, -2, -2, 1, 4, 7, 8, 8, 2, 2, 1, -2, -2, -9}, new int[]{0, -7, -3, -3, -2, 1, 4, 8, 8, 4, 3, 3, 7, 0});
                    break;
                }
                case 2001: {
                    this.paintPolygon(graphics, systemColor2, systemColor, bl, new int[]{-5, -2, 5, 9, -2, -9, -5}, new int[]{-5, -2, -9, -5, 6, -1, -5});
                    break;
                }
                case 2002: {
                    this.paintPolygon(graphics, systemColor2, systemColor, bl, new int[]{-4, 0, 4, 8, 4, 8, 4, 0, -4, -8, -4, -8, -4}, new int[]{-8, -4, -8, -4, 0, 4, 8, 4, 8, 4, 0, -4, -8});
                    break;
                }
                case 2003: {
                    if (this.state) {
                        this.paintPolygon(graphics, systemColor2, systemColor, bl, new int[]{-5, -2, 5, 9, -2, -9, -5}, new int[]{-5, -2, -9, -5, 6, -1, -5});
                        break;
                    }
                    this.paintPolygon(graphics, systemColor2, systemColor, bl, new int[]{-4, 0, 4, 8, 4, 8, 4, 0, -4, -8, -4, -8, -4}, new int[]{-8, -4, -8, -4, 0, 4, 8, 4, 8, 4, 0, -4, -8});
                    break;
                }
                default: {
                    graphics.draw3DRect(-9, 0, 18, 1, false);
                }
            }
            if (this.isEnabled) break;
        }
    }

    private void paintPolygon(Graphics graphics, Color color, Color color2, boolean bl, int[] nArray, int[] nArray2) {
        if (bl) {
            graphics.setColor(color);
            graphics.fillPolygon(nArray, nArray2, nArray.length);
        }
        graphics.setColor(color2);
        graphics.drawPolygon(nArray, nArray2, nArray.length);
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.isEnabled) {
            if (mouseEvent.getID() == 504) {
                this.setRaised(true);
            } else if (mouseEvent.getID() == 505) {
                this.setRaised(false);
            } else if (mouseEvent.getID() == 501) {
                this.setState(true);
            } else if (mouseEvent.getID() == 502 && this.state) {
                this.setState(false);
                if (this.actionListener != null && this.actionCommand != null) {
                    this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand, mouseEvent.getModifiers()));
                }
            }
        }
        super.processMouseEvent(mouseEvent);
    }
}

