/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.TextComponent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class ICardPanel
extends Panel
implements ItemSelectable,
MouseListener,
KeyListener {
    private static Insets tableInsets = new Insets(5, 7, 3, 7);
    private static int tRaised = 2;
    private static int tBorder = 2;
    private Insets insets = new Insets(2, 0, 0, 0);
    private CardLayout layout = new CardLayout(2, 2);
    private String visibleCard = null;
    private int[] cellWidth = null;
    private Dimension tableDim = null;
    private ItemListener itemListener;

    public ICardPanel() {
        super.setLayout(this.layout);
        this.addMouseListener(this);
        this.addKeyListener(this);
    }

    @Override
    public void addItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
    }

    @Override
    public void removeItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            this.getComponent(i).addKeyListener(keyListener);
        }
        super.addKeyListener(keyListener);
    }

    public void addCard(String string, Component component) {
        if (this.getComponentCount() == 0) {
            this.visibleCard = string;
        }
        component.setName(string);
        component.addKeyListener(this);
        this.add(component, string);
        this.tableDim = null;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.tableDim == null) {
            this.calculateTableSize();
        }
        Dimension dimension = this.layout.preferredLayoutSize(this);
        return new Dimension(this.insets.left + Math.max(this.tableDim.width, dimension.width) + this.insets.right, this.insets.top + this.tableDim.height + dimension.height + this.insets.bottom);
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    @Override
    public Insets getInsets() {
        if (this.tableDim == null) {
            this.calculateTableSize();
        }
        return new Insets(this.insets.top + this.tableDim.height + this.layout.getVgap(), this.insets.left + this.layout.getHgap(), this.insets.bottom + this.layout.getVgap(), this.insets.right + this.layout.getHgap());
    }

    public void showCard(String string) {
        this.visibleCard = string;
        this.repaint();
        this.layout.show(this, string);
        this.requestFocus();
    }

    private void showCard(int n) {
        if (n < 0) {
            n = this.getComponentCount() - 1;
        } else if (n > this.getComponentCount() - 1) {
            n = 0;
        }
        this.showCard(this.getComponent(n).getName());
    }

    public String getVisibleCard() {
        return this.visibleCard;
    }

    @Override
    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        dimension.width -= this.insets.left + this.insets.right;
        dimension.height -= this.insets.top + this.insets.bottom;
        if (this.tableDim == null) {
            this.calculateTableSize();
        }
        int n = this.tableDim.height;
        int n2 = this.insets.left;
        int n3 = this.insets.top;
        graphics.setColor(SystemColor.controlLtHighlight);
        graphics.drawLine(n2, n3 + n, n2, n3 + dimension.height - 1);
        graphics.drawLine(n2, n3 + n, n2 + dimension.width - 1, n3 + n);
        graphics.setColor(SystemColor.controlHighlight);
        graphics.drawLine(n2 + 1, n3 + n + 1, n2 + 1, n3 + dimension.height - 2);
        graphics.drawLine(n2 + 1, n3 + n + 1, n2 + dimension.width - 2, n3 + n + 1);
        graphics.setColor(SystemColor.controlDkShadow);
        graphics.drawLine(n2 + dimension.width - 1, n3 + n, n2 + dimension.width - 1, n3 + dimension.height - 1);
        graphics.drawLine(n2, n3 + dimension.height - 1, n2 + dimension.width - 1, n3 + dimension.height - 1);
        graphics.setColor(SystemColor.controlShadow);
        graphics.drawLine(n2 + 1, n3 + dimension.height - 2, n2 + dimension.width - 2, n3 + dimension.height - 2);
        graphics.drawLine(n2 + dimension.width - 2, n3 + n + 1, n2 + dimension.width - 2, n3 + dimension.height - 2);
        n2 = this.insets.left + tBorder;
        n3 = this.insets.top;
        int n4 = n2;
        int n5 = 0;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            String string = this.getComponent(i).getName();
            if (string.equals(this.visibleCard)) {
                n4 = n2;
                n5 = i;
            }
            graphics.setColor(SystemColor.controlLtHighlight);
            graphics.drawLine(n2, n3 + 2, n2, n3 + n - 1);
            graphics.drawLine(n2 + 2, n3, n2 + this.cellWidth[i] - 3, n3);
            graphics.drawLine(n2 + 1, n3 + 1, n2 + 1, n3 + 1);
            graphics.setColor(SystemColor.controlHighlight);
            graphics.drawLine(n2 + 1, n3 + 2, n2 + 1, n3 + n - 1);
            graphics.drawLine(n2 + 2, n3 + 1, n2 + this.cellWidth[i] - 2, n3 + 1);
            graphics.setColor(SystemColor.controlDkShadow);
            graphics.drawLine(n2 + this.cellWidth[i] - 1, n3 + 2, n2 + this.cellWidth[i] - 1, n3 + n - 1);
            graphics.drawLine(n2 + this.cellWidth[i] - 2, n3 + 1, n2 + this.cellWidth[i] - 2, n3 + 1);
            graphics.setColor(SystemColor.controlShadow);
            graphics.drawLine(n2 + this.cellWidth[i] - 2, n3 + 2, n2 + this.cellWidth[i] - 2, n3 + n - 1);
            graphics.setColor(SystemColor.textText);
            graphics.drawString(string, n2 + ICardPanel.tableInsets.left, n3 + n - ICardPanel.tableInsets.bottom - 1);
            n2 += this.cellWidth[i];
        }
        n2 = n4;
        n3 = this.insets.top;
        graphics.setColor(this.getBackground());
        graphics.fillRect(n2 - tBorder + 2, n3, this.cellWidth[n5] + 2 * tBorder - 3, n + 2);
        graphics.setColor(SystemColor.controlLtHighlight);
        graphics.drawLine(n2 - tBorder, n3 + 2 - tRaised, n2 - tBorder, n3 + n);
        graphics.drawLine(n2 - tBorder + 2, n3 - tRaised, n2 + this.cellWidth[n5] + tBorder - 3, n3 - tRaised);
        graphics.drawLine(n2 - tBorder + 1, n3 + 1 - tRaised, n2 - tBorder + 1, n3 + 1 - tRaised);
        graphics.setColor(SystemColor.controlHighlight);
        graphics.drawLine(n2 - tBorder + 1, n3 + 2 - tRaised, n2 - tBorder + 1, n3 + n);
        graphics.drawLine(n2 - tBorder + 2, n3 + 1 - tRaised, n2 + this.cellWidth[n5] + tBorder - 2, n3 + 1 - tRaised);
        graphics.setColor(SystemColor.controlShadow);
        graphics.drawLine(n2 + this.cellWidth[n5] + tBorder - 2, n3 + 1 - tRaised, n2 + this.cellWidth[n5] + tBorder - 2, n3 + n);
        graphics.setColor(SystemColor.controlDkShadow);
        graphics.drawLine(n2 + this.cellWidth[n5] + tBorder - 1, n3 + 2 - tRaised, n2 + this.cellWidth[n5] + tBorder - 1, n3 + n);
        graphics.drawLine(n2 + this.cellWidth[n5] + tBorder - 2, n3 + 1 - tRaised, n2 + this.cellWidth[n5] + tBorder - 2, n3 + 1 - tRaised);
        graphics.setColor(SystemColor.textText);
        graphics.drawString(this.visibleCard, n2 + ICardPanel.tableInsets.left, n3 + n - ICardPanel.tableInsets.bottom - 1 - tRaised);
        this.getComponent(n5).repaint();
    }

    private void calculateTableSize() {
        this.tableDim = new Dimension();
        if (this.getFont() == null) {
            return;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (this.cellWidth == null) {
            this.cellWidth = new int[this.getComponentCount()];
        }
        for (int i = 0; i < this.getComponentCount(); ++i) {
            this.cellWidth[i] = ICardPanel.tableInsets.left + fontMetrics.stringWidth(this.getComponent(i).getName()) + ICardPanel.tableInsets.right;
            this.tableDim.width += this.cellWidth[i];
        }
        this.tableDim.width += 2 * tBorder;
        this.tableDim.height = ICardPanel.tableInsets.top + fontMetrics.getAscent() + ICardPanel.tableInsets.bottom;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        if (point.x < this.insets.left || point.x > this.getSize().width - this.insets.right) {
            return;
        }
        if (point.y < this.insets.top || point.y > this.insets.top + this.tableDim.height) {
            return;
        }
        if (this.cellWidth == null) {
            return;
        }
        int n = this.insets.left + tBorder;
        for (int i = 0; i < this.cellWidth.length; ++i) {
            if (point.x <= n || point.x >= (n += this.cellWidth[i])) continue;
            this.showCard(this.getComponent(i).getName());
            if (this.itemListener != null) {
                this.itemListener.itemStateChanged(new ItemEvent(this, 1, this.visibleCard, 701));
            }
            return;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        Component component = keyEvent.getComponent();
        if (component instanceof TextComponent || component instanceof Scrollbar || component instanceof Canvas) {
            return;
        }
        block0 : switch (keyEvent.getKeyCode()) {
            case 39: 
            case 227: {
                for (int i = 0; i < this.getComponentCount(); ++i) {
                    if (!this.getComponent(i).getName().equals(this.visibleCard)) continue;
                    this.showCard(i + 1);
                    break block0;
                }
                break;
            }
            case 37: 
            case 226: {
                for (int i = 0; i < this.getComponentCount(); ++i) {
                    if (!this.getComponent(i).getName().equals(this.visibleCard)) continue;
                    this.showCard(i - 1);
                    break block0;
                }
                break;
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public Object[] getSelectedObjects() {
        Object[] objectArray = new Object[]{this.visibleCard};
        return objectArray;
    }
}

