/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.ICanvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;

public class IChecker
extends ICanvas {
    private static final int WIDTH = 15;
    private static final int HEIGHT = 15;
    private static final int L = 5;
    public static final int NONE = 0;
    public static final int ON_NO_ERROR = 10;
    public static final int ON_WITH_ERROR = 11;
    public static final int OFF_NO_ERROR = 20;
    public static final int OFF_WITH_ERROR = 21;
    private int state = 0;

    public IChecker() {
        this(0);
    }

    public IChecker(int n) {
        this.state = n;
    }

    public void setState(int n) {
        this.state = n;
        this.paint(this.getGraphics());
    }

    public int getState() {
        return this.state;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(15, 15);
    }

    @Override
    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        Point point = new Point(dimension.width / 2, dimension.height / 2);
        switch (this.state) {
            case 0: {
                break;
            }
            case 10: {
                graphics.setColor(Color.green);
                this.drawON(graphics, point);
                break;
            }
            case 11: {
                graphics.setColor(Color.red);
                this.drawON(graphics, point);
                break;
            }
            case 20: {
                graphics.setColor(Color.green);
                this.drawOFF(graphics, point);
                break;
            }
            case 21: {
                graphics.setColor(Color.red);
                this.drawOFF(graphics, point);
            }
        }
    }

    private void drawON(Graphics graphics, Point point) {
        graphics.drawLine(point.x - 1, point.y + 5, point.x - 5, point.y + 1);
        graphics.drawLine(point.x - 1, point.y + 5 - 1, point.x - 5 + 1, point.y + 1);
        graphics.drawLine(point.x - 1, point.y + 5 - 2, point.x - 5 + 1, point.y);
        graphics.drawLine(point.x - 1, point.y + 5, point.x + 5 - 1, point.y - 5 + 2);
        graphics.drawLine(point.x - 1, point.y + 5 - 1, point.x + 5 - 1, point.y - 5 + 1);
        graphics.drawLine(point.x - 1, point.y + 5 - 2, point.x + 5 - 1, point.y - 5);
    }

    private void drawOFF(Graphics graphics, Point point) {
        graphics.drawLine(point.x - 5, point.y + 5 - 1, point.x + 5 - 1, point.y - 5);
        graphics.drawLine(point.x - 5 + 1, point.y + 5 - 1, point.x + 5 - 1, point.y - 5 + 1);
        graphics.drawLine(point.x - 5 + 1, point.y + 5, point.x + 5, point.y - 5 + 1);
        graphics.drawLine(point.x - 5, point.y - 5 + 1, point.x + 5 - 1, point.y + 5);
        graphics.drawLine(point.x - 5 + 1, point.y - 5 + 1, point.x + 5 - 1, point.y + 5 - 1);
        graphics.drawLine(point.x - 5 + 1, point.y - 5, point.x + 5, point.y + 5 - 1);
    }
}

