/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.ICanvas;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;

public class IColorButton
extends ICanvas {
    private static final int WIDTH = 23;
    private static final int HEIGHT = 23;
    protected boolean state = false;
    protected boolean raised = false;
    protected boolean isEnabled = true;
    protected String actionCommand;
    protected ActionListener actionListener;
    protected Color color;

    public IColorButton(Color color) {
        this.color = color;
        this.enableEvents(16L);
    }

    public void setColor(Color color) {
        this.color = color;
        this.repaint();
    }

    public Color getColor() {
        return this.color;
    }

    public void setState(boolean bl) {
        this.state = bl;
        this.repaint();
    }

    public boolean getState() {
        return this.state;
    }

    protected void setRaised(boolean bl) {
        this.raised = bl;
        this.repaint();
    }

    protected boolean getRaised() {
        return this.raised;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
        if (bl) {
            this.enableEvents(16L);
        } else {
            this.disableEvents(16L);
        }
        this.repaint();
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(23, 23);
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    @Override
    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(SystemColor.control);
        int n = 0;
        if (this.isEnabled) {
            if (this.state) {
                graphics.draw3DRect(0, 0, dimension.width - 1, dimension.height - 1, false);
                ++n;
            } else if (this.raised) {
                graphics.fill3DRect(0, 0, dimension.width, dimension.height, true);
            } else {
                graphics.fillRect(0, 0, dimension.width, dimension.height);
            }
        } else {
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        boolean bl = true;
        for (int i = 0; i < 2; ++i) {
            SystemColor systemColor;
            if (this.isEnabled) {
                if (this.state || this.raised) {
                    var4_6 = SystemColor.controlLtHighlight;
                    systemColor = SystemColor.activeCaption;
                } else {
                    var4_6 = SystemColor.controlHighlight;
                    systemColor = SystemColor.inactiveCaption;
                }
            } else if (i == 0) {
                graphics.translate(1, 1);
                var4_6 = SystemColor.control;
                systemColor = SystemColor.controlLtHighlight;
            } else {
                graphics.translate(-1, -1);
                var4_6 = SystemColor.control;
                systemColor = SystemColor.controlShadow;
                bl = false;
            }
            graphics.setColor(this.color);
            graphics.fillRect(3, 3, dimension.width - 7, dimension.height - 7);
            graphics.setColor(systemColor);
            graphics.drawRect(3, 3, dimension.width - 7, dimension.height - 7);
            if (this.isEnabled) break;
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.isEnabled) {
            if (mouseEvent.getID() == 504) {
                this.setRaised(true);
            } else if (mouseEvent.getID() == 505) {
                this.setRaised(false);
            } else if (mouseEvent.getID() == 501) {
                this.setState(true);
            } else if (mouseEvent.getID() == 502 && this.state) {
                this.setState(false);
                if (this.actionListener != null && this.actionCommand != null) {
                    this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand, mouseEvent.getModifiers()));
                }
            }
        }
        super.processMouseEvent(mouseEvent);
    }
}

