/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.IColorSlider;
import java.awt.Color;
import java.awt.event.KeyEvent;

public class IColorHueSlider
extends IColorSlider {
    public IColorHueSlider(int n) {
        super(n);
    }

    public IColorHueSlider(int n, float f) {
        super(n, f);
    }

    @Override
    public void setValue(int n) {
        this.setHue(n);
    }

    @Override
    public int getValue() {
        return this.getHue();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (!this.isEnabled()) {
            return;
        }
        int n = 0;
        switch (keyEvent.getKeyCode()) {
            case 66: {
                this.setColor(Color.blue);
                n = 5;
                break;
            }
            case 67: {
                this.setColor(Color.cyan);
                n = 5;
                break;
            }
            case 71: {
                this.setColor(Color.green);
                n = 5;
                break;
            }
            case 77: {
                this.setColor(Color.magenta);
                n = 5;
                break;
            }
            case 79: {
                this.setColor(Color.orange);
                n = 5;
                break;
            }
            case 80: {
                this.setColor(Color.pink);
                n = 5;
                break;
            }
            case 82: {
                this.setColor(Color.red);
                n = 5;
                break;
            }
            case 89: {
                this.setColor(Color.yellow);
                n = 5;
            }
        }
        if (n != 0) {
            this.repaint();
            this.sendAdjustmentEvent(n);
        } else {
            super.keyPressed(keyEvent);
        }
    }

    @Override
    protected Color getColor(float f) {
        return new Color(Color.HSBtoRGB(this.getColorComponent(f), (float)this.getSaturation() / 255.0f, (float)this.getBrightness() / 255.0f));
    }
}

