/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.IColorHueSlider;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IOptionDialog;
import de.geocalc.awt.IPanel;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentListener;

public class IColorHueSliderDialog
extends IOptionDialog
implements ActionListener,
AdjustmentListener {
    IColorHueSlider slider;

    public IColorHueSliderDialog(IFrame iFrame, String string) {
        super(iFrame, string, 5);
        this.setLocationOfParent(iFrame, 11);
        this.setResizable(true);
        this.slider.requestFocus();
        this.pack();
    }

    public void setValue(float f) {
        if (this.slider != null) {
            this.slider.setValue((int)Math.rint(f * 255.0f));
        }
    }

    public float getValue() {
        return this.slider != null ? (float)this.slider.getValue() / 255.0f : 0.0f;
    }

    public void setColor(Color color) {
        if (this.slider != null) {
            this.slider.setColor(color);
        }
    }

    public Color getColor() {
        return this.slider != null ? this.slider.getColor() : new Color(0, 0, 0);
    }

    @Override
    protected IPanel layoutDialogPanel() {
        IPanel iPanel = new IPanel();
        iPanel.setBorder(new IBorder(1));
        iPanel.setLayout(new GridLayout(1, 1));
        this.slider = new IColorHueSlider(0);
        iPanel.add(this.slider);
        this.slider.addAdjustmentListener(this);
        return iPanel;
    }

    @Override
    public void setOptions() {
    }
}

