/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public abstract class IColorSlider
extends Canvas
implements Adjustable,
KeyListener,
MouseListener,
MouseMotionListener {
    private static final int SIZE = 16;
    protected boolean isEnabled = true;
    protected String actionCommand;
    protected ActionListener actionListener;
    protected int orientation = 0;
    protected AdjustmentListener adjustmentListener;
    private boolean mouseDrag = false;
    private float sizeF = 1.0f;
    private int min = 0;
    private int max = 255;
    private int uinc = 2;
    private int binc = 20;
    private int vam = 8;
    protected int hue = 255;
    protected int saturation = 255;
    protected int brightness = 255;

    protected IColorSlider(int n) {
        this(n, 1.0f);
    }

    protected IColorSlider(int n, float f) {
        this.orientation = n;
        this.sizeF = f;
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public int getOrientation() {
        return this.orientation;
    }

    @Override
    public void setMinimum(int n) {
        this.min = n;
    }

    @Override
    public int getMinimum() {
        return this.min;
    }

    @Override
    public void setMaximum(int n) {
        this.max = n;
    }

    @Override
    public int getMaximum() {
        return this.max;
    }

    @Override
    public void setUnitIncrement(int n) {
        this.uinc = n;
    }

    @Override
    public int getUnitIncrement() {
        return this.uinc;
    }

    @Override
    public void setBlockIncrement(int n) {
        this.binc = n;
    }

    @Override
    public int getBlockIncrement() {
        return this.binc;
    }

    @Override
    public void setVisibleAmount(int n) {
        this.vam = n;
    }

    @Override
    public int getVisibleAmount() {
        return this.vam;
    }

    @Override
    public abstract void setValue(int var1);

    @Override
    public abstract int getValue();

    public void setHue(int n) {
        this.hue = this.normalize(n);
        this.repaint();
    }

    public int getHue() {
        return this.hue;
    }

    public void setSaturation(int n) {
        this.saturation = this.normalize(n);
        this.repaint();
    }

    public int getSaturation() {
        return this.saturation;
    }

    public void setBrightness(int n) {
        this.brightness = this.normalize(n);
        this.repaint();
    }

    public int getBrightness() {
        return this.brightness;
    }

    public void setColor(Color color) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), new float[3]);
        this.setHue((int)Math.rint(fArray[0] * 255.0f));
        this.setSaturation((int)Math.rint(fArray[1] * 255.0f));
        this.setBrightness((int)Math.rint(fArray[2] * 255.0f));
    }

    public Color getColor() {
        return Color.getHSBColor(this.getHue(), this.getSaturation(), this.getBrightness());
    }

    protected int normalize(int n) {
        n = Math.max(n, 0);
        n = Math.min(n, 255);
        return n;
    }

    @Override
    public void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.adjustmentListener = adjustmentListener;
    }

    @Override
    public void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        if (this.adjustmentListener == adjustmentListener) {
            this.adjustmentListener = null;
        }
    }

    protected void sendAdjustmentEvent(int n) {
        if (this.adjustmentListener != null) {
            this.adjustmentListener.adjustmentValueChanged(new AdjustmentEvent(this, 601, n, this.getValue()));
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
        this.repaint();
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    public Insets getInsets() {
        return new Insets(5, 5, 5, 5);
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        int n = (int)Math.rint((float)(this.max - this.min) * this.sizeF) + insets.left + insets.right;
        int n2 = 16 + insets.top + insets.bottom;
        return this.orientation == 0 ? new Dimension(n, n2) : new Dimension(n2, n);
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (!this.isEnabled()) {
            return;
        }
        int n = 0;
        switch (keyEvent.getKeyCode()) {
            case 36: {
                this.setValue(this.min);
                n = 5;
                break;
            }
            case 39: 
            case 40: 
            case 107: {
                this.setValue(this.getValue() + this.uinc);
                n = 1;
                break;
            }
            case 34: {
                this.setValue(this.getValue() + this.binc);
                n = 4;
                break;
            }
            case 35: {
                this.setValue(this.max);
                n = 5;
                break;
            }
            case 37: 
            case 38: 
            case 109: {
                this.setValue(this.getValue() - this.uinc);
                n = 2;
                break;
            }
            case 33: {
                this.setValue(this.getValue() - this.binc);
                n = 3;
            }
        }
        if (n != 0) {
            this.repaint();
            this.sendAdjustmentEvent(n);
        }
    }

    private int getMouseValue(int n, int n2) {
        Insets insets = this.getInsets();
        Dimension dimension = this.getSize();
        if (this.orientation == 0) {
            return this.min + (n -= insets.left) * (this.max - this.min) / (dimension.width - insets.left - insets.right - this.vam);
        }
        return this.min + (n2 -= insets.top) * (this.max - this.min) / (dimension.height - insets.top - insets.bottom - this.vam);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = this.getMouseValue(mouseEvent.getX(), mouseEvent.getY());
        boolean bl = false;
        if (n < this.getValue() - this.vam || n > this.getValue() + this.vam * 2) {
            this.setValue(n);
            this.sendAdjustmentEvent(5);
            this.repaint();
        } else {
            this.mouseDrag = true;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseDrag = false;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n = this.getMouseValue(mouseEvent.getX(), mouseEvent.getY());
        if (this.mouseDrag && n != this.getValue()) {
            this.setValue(n);
            this.sendAdjustmentEvent(5);
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    protected abstract Color getColor(float var1);

    protected final float getColorComponent(float f) {
        float f2 = (float)this.min + f * (float)(this.max - this.min) / 255.0f;
        return f2 / 255.0f;
    }

    @Override
    public void paint(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        graphics.setColor(SystemColor.control);
        int n = dimension.width - insets.left - insets.right;
        int n2 = dimension.height - insets.top - insets.bottom;
        int n3 = insets.left;
        int n4 = insets.top;
        graphics.draw3DRect(n3, n4, n, n2, false);
        ++n3;
        ++n4;
        n -= 2;
        n2 -= 2;
        if (this.orientation == 0) {
            int n5;
            float f = 255.0f / (float)n;
            for (n5 = 0; n5 < n; ++n5) {
                graphics.setColor(this.getColor((float)n5 * f));
                graphics.drawLine(n3 + n5, n4, n3 + n5, n4 + n2);
            }
            n5 = n3 + (this.getValue() - this.min) * (n - this.vam) / (this.max - this.min);
            n5 = Math.max(n3, n5);
            n5 = Math.min(n3 + n - this.vam, n5);
            graphics.setColor(SystemColor.control);
            graphics.fill3DRect(n5, n4, this.vam, n2 + 1, true);
        } else {
            int n6;
            float f = 255.0f / (float)n2;
            for (n6 = 0; n6 < n2; ++n6) {
                graphics.setColor(this.getColor((float)n6 * f));
                graphics.drawLine(n3, n4 + n6, n3 + n, n4 + n6);
            }
            n6 = n4 + (this.getValue() - this.min) * (n2 - this.vam) / (this.max - this.min);
            n6 = Math.max(n4, n6);
            n6 = Math.min(n4 + n2 - this.vam, n6);
            graphics.setColor(SystemColor.control);
            graphics.fill3DRect(n3, n6, n + 1, this.vam, true);
        }
    }

    @Override
    public void repaint() {
        this.paint(this.getGraphics());
    }
}

