/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.IColorBrightnessSlider;
import de.geocalc.awt.IColorHueSlider;
import de.geocalc.awt.IColorPane;
import de.geocalc.awt.IColorSaturationSlider;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IOptionDialog;
import de.geocalc.awt.IPanel;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;

public class IColorSliderDialog
extends IOptionDialog
implements ActionListener,
AdjustmentListener {
    IColorHueSlider hueSlider;
    IColorSaturationSlider satSlider;
    IColorBrightnessSlider brigSlider;
    IColorPane iPanel;
    Label redLabel;
    Label greenLabel;
    Label blueLabel;
    Label hueLabel;
    Label satLabel;
    Label brigLabel;

    public IColorSliderDialog(IFrame iFrame, String string) {
        this(iFrame, string, false, (Color)null);
    }

    public IColorSliderDialog(IFrame iFrame, String string, Color color) {
        this(iFrame, string, false, color);
    }

    public IColorSliderDialog(IFrame iFrame, String string, boolean bl, Color color) {
        super(iFrame, string, bl);
        this.setColor(color);
        this.setLocationOfParent(iFrame, 11);
        this.setResizable(true);
        this.pack();
    }

    public void setColor(Color color) {
        if (color != null) {
            this.iPanel.setColor(color);
            this.redLabel.setText(Integer.toString(color.getRed()));
            this.greenLabel.setText(Integer.toString(color.getGreen()));
            this.blueLabel.setText(Integer.toString(color.getBlue()));
            float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), new float[3]);
            int n = (int)Math.rint(fArray[0] * 255.0f);
            int n2 = (int)Math.rint(fArray[1] * 255.0f);
            int n3 = (int)Math.rint(fArray[2] * 255.0f);
            this.hueLabel.setText(Integer.toString(n));
            this.satLabel.setText(Integer.toString(n2));
            this.brigLabel.setText(Integer.toString(n3));
            this.hueSlider.setHue(n);
            this.hueSlider.setSaturation(n2);
            this.hueSlider.setBrightness(n3);
            this.satSlider.setHue(n);
            this.satSlider.setSaturation(n2);
            this.satSlider.setBrightness(n3);
            this.brigSlider.setHue(n);
            this.brigSlider.setSaturation(n2);
            this.brigSlider.setBrightness(n3);
            if (this.isVisible()) {
                this.iPanel.repaint();
                this.hueSlider.repaint();
                this.satSlider.repaint();
                this.brigSlider.repaint();
            }
        }
    }

    public Color getColor() {
        return Color.getHSBColor((float)this.hueSlider.getValue() / 255.0f, (float)this.satSlider.getValue() / 255.0f, (float)this.brigSlider.getValue() / 255.0f);
    }

    @Override
    protected IPanel layoutDialogPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1));
        this.iPanel = new IColorPane();
        iPanel.add(this.iPanel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.iPanel, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        Label label = new Label("Rot:");
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("Gr\u00fcn:");
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("Blau:");
        iPanel.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.redLabel = new Label("255");
        iPanel.add(this.redLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.redLabel, gridBagConstraints);
        this.greenLabel = new Label("255");
        iPanel.add(this.greenLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.greenLabel, gridBagConstraints);
        this.blueLabel = new Label("255");
        iPanel.add(this.blueLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.blueLabel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        label = new Label("Farbton:");
        iPanel.add(label);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("S\u00e4ttigung:");
        iPanel.add(label);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("Helligkeit:");
        iPanel.add(label);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.hueLabel = new Label("255");
        iPanel.add(this.hueLabel);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.hueLabel, gridBagConstraints);
        this.satLabel = new Label("255");
        iPanel.add(this.satLabel);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.satLabel, gridBagConstraints);
        this.brigLabel = new Label("255");
        iPanel.add(this.brigLabel);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.brigLabel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 1;
        this.hueSlider = new IColorHueSlider(0);
        iPanel.add(this.hueSlider);
        this.hueSlider.addAdjustmentListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.hueSlider, gridBagConstraints);
        this.satSlider = new IColorSaturationSlider(0);
        iPanel.add(this.satSlider);
        this.satSlider.addAdjustmentListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.satSlider, gridBagConstraints);
        this.brigSlider = new IColorBrightnessSlider(0);
        iPanel.add(this.brigSlider);
        this.brigSlider.addAdjustmentListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(this.brigSlider, gridBagConstraints);
        return iPanel;
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Color color = Color.getHSBColor((float)this.hueSlider.getValue() / 255.0f, (float)this.satSlider.getValue() / 255.0f, (float)this.brigSlider.getValue() / 255.0f);
        this.iPanel.setColor(color);
        this.iPanel.repaint();
        this.redLabel.setText(Integer.toString(color.getRed()));
        this.greenLabel.setText(Integer.toString(color.getGreen()));
        this.blueLabel.setText(Integer.toString(color.getBlue()));
        if (adjustmentEvent.getSource() == this.hueSlider) {
            int n = this.hueSlider.getHue();
            this.hueLabel.setText(Integer.toString(n));
            this.satSlider.setHue(n);
            this.brigSlider.setHue(n);
        } else if (adjustmentEvent.getSource() == this.satSlider) {
            int n = this.satSlider.getSaturation();
            this.satLabel.setText(Integer.toString(n));
            this.hueSlider.setSaturation(n);
            this.brigSlider.setSaturation(n);
        } else if (adjustmentEvent.getSource() == this.brigSlider) {
            int n = this.brigSlider.getBrightness();
            this.brigLabel.setText(Integer.toString(n));
            this.hueSlider.setBrightness(n);
            this.satSlider.setBrightness(n);
        }
        super.adjustmentValueChanged(adjustmentEvent);
    }

    @Override
    public void setOptions() {
    }
}

