/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.IFrame;
import de.geocalc.awt.IToolTipManager;
import java.awt.AWTEventMulticaster;
import java.awt.Container;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class IComponent
extends Container
implements ContainerListener,
MouseListener {
    private Insets insets = new Insets(0, 0, 0, 0);
    private String toolTipText;
    private MouseListener mouseListener;

    public IComponent() {
        this.setForeground(SystemColor.controlText);
        this.setBackground(SystemColor.control);
        this.addContainerListener(this);
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        this.mouseListener = mouseListener;
    }

    public void removeActionListener(MouseListener mouseListener) {
        this.mouseListener = AWTEventMulticaster.remove(this.mouseListener, mouseListener);
    }

    public void setToolTipText(String string) {
        this.toolTipText = string;
        IToolTipManager iToolTipManager = IFrame.getToolTipManager();
        if (string != null) {
            iToolTipManager.registerComponent(this);
        } else {
            iToolTipManager.unregisterComponent(this);
        }
        super.addMouseListener(this);
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.mouseListener != null) {
            this.mouseListener.mouseEntered(mouseEvent);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.mouseListener != null) {
            this.mouseListener.mouseExited(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void componentAdded(ContainerEvent containerEvent) {
        if (containerEvent.getChild() instanceof Container) {
            Container container = (Container)containerEvent.getChild();
            container.addContainerListener(this);
        }
        containerEvent.getChild().addMouseListener(this);
    }

    @Override
    public void componentRemoved(ContainerEvent containerEvent) {
        if (containerEvent.getChild() instanceof Container) {
            Container container = (Container)containerEvent.getChild();
            container.removeContainerListener(this);
        }
        containerEvent.getChild().addMouseListener(this);
    }

    @Override
    public Insets getInsets() {
        return this.insets;
    }

    public void setInsets(int n, int n2, int n3, int n4) {
        this.insets = new Insets(n, n2, n3, n4);
    }
}

