/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.IFrame;
import de.geocalc.awt.event.IMessageListener;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;

public abstract class IDialog
extends Dialog
implements KeyListener {
    public static final String VERSION = "1.0.0";
    public static final int RETURN_ABORT = 0;
    public static final int RETURN_OK = 1;
    protected IFrame parent;
    protected String title;
    protected ActionListener actionListener;
    protected IMessageListener messageListener;
    protected String actionCommand;
    protected int returnType = 0;
    private Point lastScreenLoc = new Point();
    private static final Hashtable<String, Rectangle> dialogLocations = new Hashtable();

    public IDialog(IFrame iFrame, String string, boolean bl) {
        this(iFrame, string, bl, true);
    }

    public IDialog(IFrame iFrame, String string, boolean bl, boolean bl2) {
        super(iFrame, string, bl);
        this.parent = iFrame;
        this.title = string;
        this.setBackground(SystemColor.control);
        this.addKeyListener(this);
        if (bl2) {
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    if (!IDialog.this.dialogAbort()) {
                        IDialog.this.endDialog();
                    }
                }
            });
        }
    }

    protected boolean dialogAbort() {
        return false;
    }

    public IFrame getParentFrame() {
        return this.parent;
    }

    @Override
    public void pack() {
        super.pack();
        this.setMinimumSize(this.getSize());
        this.registerKeyListener(this);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            Cloneable cloneable;
            if (!super.isVisible() && (cloneable = dialogLocations.get(this.getClass().getName())) != null) {
                if (this.isResizable()) {
                    Dimension dimension = this.getSize();
                    if (dimension.width > ((Rectangle)cloneable).width) {
                        ((Rectangle)cloneable).width = dimension.width;
                    }
                    if (dimension.height > ((Rectangle)cloneable).height) {
                        ((Rectangle)cloneable).height = dimension.height;
                    }
                    this.setBounds((Rectangle)cloneable);
                } else {
                    this.setLocation(((Rectangle)cloneable).x, ((Rectangle)cloneable).y);
                }
            }
            cloneable = super.getLocation();
            if (cloneable.x < 0) {
                cloneable.x = 0;
            }
            if (cloneable.y < 0) {
                cloneable.y = 0;
            }
            super.setLocation(cloneable.x, cloneable.y);
        } else {
            dialogLocations.put(this.getClass().getName(), this.getBounds());
        }
        super.setVisible(bl);
    }

    private void registerKeyListener(Component component) {
        component.addKeyListener(this);
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                this.registerKeyListener(container.getComponent(i));
            }
        }
    }

    protected void setLocationOfParent(IFrame iFrame) {
        this.setLocationOfParent(iFrame, 10);
    }

    protected void setLocationOfParent(IFrame iFrame, int n) {
        Rectangle rectangle = iFrame.getDialogPlace();
        Point point = new Point();
        Dimension dimension = this.getSize();
        switch (n) {
            case -11: 
            case -10: 
            case -9: {
                point.x = rectangle.x;
                break;
            }
            case -1: 
            case 0: 
            case 1: {
                point.x = rectangle.x + (rectangle.width - dimension.width) / 2;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                point.x = rectangle.x + rectangle.width - dimension.width;
            }
        }
        switch (n) {
            case -11: 
            case -1: 
            case 9: {
                point.y = rectangle.y;
                break;
            }
            case -10: 
            case 0: 
            case 10: {
                point.y = rectangle.y + (rectangle.height - dimension.height) / 2;
                break;
            }
            case -9: 
            case 1: 
            case 11: {
                point.y = rectangle.y + rectangle.height - dimension.height;
            }
        }
        this.setLocation(point);
    }

    public int getReturnType() {
        return this.returnType;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public void addMessageListener(IMessageListener iMessageListener) {
        this.messageListener = iMessageListener;
    }

    public void removeMessageListener(IMessageListener iMessageListener) {
        this.messageListener = null;
    }

    public ActionListener getActionListener() {
        return this.actionListener;
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    protected abstract void doStandardAction();

    protected abstract void doAbortAction();

    protected void endDialog() {
        try {
            Thread.sleep(10L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setVisible(false);
        this.dispose();
        this.parent.show();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (!(keyEvent.isControlDown() || keyEvent.isShiftDown() || keyEvent.isAltDown())) {
            switch (keyEvent.getKeyCode()) {
                case 10: {
                    this.returnType = 1;
                    this.doStandardAction();
                    break;
                }
                case 27: {
                    this.returnType = 0;
                    this.doAbortAction();
                }
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }
}

