/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.IPanel;
import java.awt.AWTEventMulticaster;
import java.awt.Button;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Vector;

public class IFileDialogPanel
extends IPanel
implements ActionListener,
ItemSelectable {
    private static final String DEFAULT_NAME = "Dateiname";
    private static final String VOID_TEXT = "               ";
    GridBagLayout gbl;
    GridBagConstraints gbc;
    Vector entries;
    int elements;
    transient ItemListener itemListener;

    public IFileDialogPanel() {
        this.setBackground(SystemColor.control);
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.insets = new Insets(1, 1, 1, 1);
        this.gbc.ipadx = 0;
        this.gbc.ipady = 0;
        this.gbc.weighty = 0.0;
        this.gbc.anchor = 17;
        this.gbc.fill = 2;
        this.setLayout(this.gbl);
        this.entries = new Vector();
    }

    @Override
    public Object[] getSelectedObjects() {
        Object[] objectArray = new File[this.elements];
        for (int i = 0; i < this.elements; ++i) {
            String string = ((TextField)this.getComponent(i * 3 + 1)).getText();
            if (string == null || string.length() <= 0) continue;
            objectArray[i] = new File(string);
        }
        return objectArray;
    }

    @Override
    public void addItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
    }

    @Override
    public void removeItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    public void addFile(String string, File file, int n) {
        if (string == null) {
            string = DEFAULT_NAME;
        }
        Label label = new Label(string + ": ");
        this.add(label);
        this.gbc.gridx = 0;
        this.gbc.gridy = this.elements;
        this.gbc.weightx = 0.0;
        this.gbl.setConstraints(label, this.gbc);
        TextField textField = new TextField(file != null ? file.getAbsolutePath() : VOID_TEXT);
        this.add(textField);
        this.gbc.gridx = 1;
        this.gbc.gridy = this.elements;
        this.gbc.weightx = 1.0;
        this.gbl.setConstraints(textField, this.gbc);
        Button button = new Button("...");
        this.add(button);
        button.setActionCommand(Integer.toString(this.elements));
        button.addActionListener(this);
        this.gbc.gridx = 2;
        this.gbc.gridy = this.elements++;
        this.gbc.weightx = 0.0;
        this.gbl.setConstraints(button, this.gbc);
        this.entries.addElement(new Entry(this, string, file, n));
    }

    public void setEnabled(int n, boolean bl) {
        try {
            this.getComponent(n * 3 + 0).setEnabled(bl);
            this.getComponent(n * 3 + 1).setEnabled(bl);
            ((TextField)this.getComponent(n * 3 + 1)).setEditable(bl);
            this.getComponent(n * 3 + 2).setEnabled(bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public File getFile(int n) {
        try {
            String string = ((TextField)this.getComponent(n * 3 + 1)).getText().trim();
            if (string != null && string.length() > 0) {
                return new File(string);
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Frame getParentFrame() {
        Container container = this;
        while (!((container = container.getParent()) instanceof Frame)) {
        }
        return (Frame)container;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        int n = Integer.parseInt(actionEvent.getActionCommand());
        Entry entry = (Entry)this.entries.elementAt(n);
        Point point = ((Button)actionEvent.getSource()).getLocationOnScreen();
        FileDialog fileDialog = new FileDialog(this.getParentFrame(), entry.getName(), entry.getMode());
        fileDialog.setLocation(point.x, point.y);
        if (entry.getFile() != null) {
            object = entry.getFile();
            if (((File)object).isDirectory()) {
                fileDialog.setDirectory(((File)object).getAbsolutePath());
            } else {
                fileDialog.setFile(((File)object).getAbsolutePath());
            }
        }
        fileDialog.setVisible(true);
        object = fileDialog.getDirectory();
        Object object2 = fileDialog.getFile();
        if (object2 != null) {
            if (object != null) {
                object2 = (String)object + (String)object2;
            }
            entry.setFile(new File((String)object2));
            TextField textField = (TextField)this.getComponent(n * 3 + 1);
            textField.setText((String)object2);
        }
    }

    class Entry {
        String name;
        File file;
        int mode;

        Entry(IFileDialogPanel iFileDialogPanel, String string, File file, int n) {
            this.name = string;
            this.file = file;
            this.mode = n;
        }

        String getName() {
            return this.name;
        }

        void setFile(File file) {
            this.file = file;
        }

        File getFile() {
            return this.file;
        }

        int getMode() {
            return this.mode;
        }

        public boolean equals(Object object) {
            return object instanceof Entry && ((Entry)object).name.equals(this.name);
        }
    }
}

