/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.IPanel;
import java.awt.AWTEventMulticaster;
import java.awt.Button;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

public class IFilePanel
extends IPanel
implements ActionListener {
    private static final String DEFAULT_NAME = "Dateiname";
    private static final String VOID_TEXT = "         ";
    TextField textField;
    File file;
    String name;
    int mode;
    protected ActionListener actionListener;
    protected String actionCommand;

    public IFilePanel(String string, File file, int n) {
        this.file = file;
        this.name = string;
        this.mode = n;
        this.setBackground(SystemColor.control);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.setLayout(gridBagLayout);
        this.textField = new TextField(file != null ? file.getAbsolutePath() : VOID_TEXT);
        this.add(this.textField);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.textField, gridBagConstraints);
        Button button = new Button("...");
        this.add(button);
        button.setActionCommand("FILE");
        button.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(button, gridBagConstraints);
    }

    private Frame getParentFrame() {
        Container container = this;
        while (!((container = container.getParent()) instanceof Frame)) {
        }
        return (Frame)container;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public File getFile() {
        try {
            String string = this.textField.getText().trim();
            if (string != null && string.length() > 0) {
                return new File(string);
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("FILE")) {
            Point point = ((Button)actionEvent.getSource()).getLocationOnScreen();
            FileDialog fileDialog = new FileDialog(this.getParentFrame(), this.name, this.mode);
            fileDialog.setLocation(point.x, point.y);
            if (this.file == null) {
                fileDialog.setFile("");
            } else if (this.file.isDirectory()) {
                fileDialog.setDirectory(this.file.getAbsolutePath());
            } else {
                fileDialog.setFile(this.file.getAbsolutePath());
            }
            fileDialog.setVisible(true);
            String string = fileDialog.getDirectory();
            Object object = fileDialog.getFile();
            if (object != null) {
                if (string != null) {
                    object = string + (String)object;
                }
                this.file = new File((String)object);
                this.textField.setText((String)object);
                if (this.actionListener != null && this.actionCommand != null) {
                    this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand, 0));
                }
            }
        }
    }
}

