/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.IColorizer;
import de.geocalc.awt.IColorizerSlider;
import de.geocalc.awt.IFloatColorizerValueSlider;
import java.awt.Color;

public abstract class IFloatColorizer
extends IColorizer {
    protected static final float MIN = 0.0f;
    protected static final float MAX = 1.0f;
    protected float minHue = 0.0f;
    protected float maxHue = 1.0f;
    protected float minSaturation = 1.0f;
    protected float maxSaturation = 1.0f;
    protected float minBrightness = 1.0f;
    protected float maxBrightness = 1.0f;
    protected double minValue = 0.0;
    protected double maxValue = 1.0;
    protected double minBorder = 0.0;
    protected double maxBorder = 1.0;

    public IFloatColorizer() {
    }

    public IFloatColorizer(float f, float f2) {
        this.setHue(f, f2);
    }

    @Override
    public IColorizerSlider getSlider() {
        return new IFloatColorizerValueSlider();
    }

    public void setExtends(double d, double d2) {
        if (d == d2) {
            return;
        }
        if (this.minValue == 0.0 && this.maxValue == 1.0) {
            this.minBorder = d;
            this.maxBorder = d2;
        } else {
            this.minBorder = Math.max(this.minBorder, d);
            this.maxBorder = Math.min(this.maxBorder, d2);
        }
        this.minValue = d;
        this.maxValue = d2;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxBorder() {
        return this.maxBorder;
    }

    public double getMinBorder() {
        return this.minBorder;
    }

    public void setBorderScale(float f) {
        this.maxBorder = Math.max(this.minValue + (this.maxValue - this.minValue) * (double)f, (this.maxValue - this.minValue) / 1000.0);
    }

    public float getBorderScale() {
        return (float)((this.maxBorder - this.minBorder) / (this.maxValue - this.minValue));
    }

    public void setMinHue(float f) {
        this.minHue = this.normalize(f);
    }

    public float getMinHue() {
        return this.minHue;
    }

    public void setMaxHue(float f) {
        this.maxHue = this.normalize(f);
    }

    public float getMaxHue() {
        return this.maxHue;
    }

    public void setHue(float f, float f2) {
        this.setMinHue(f);
        this.setMaxHue(f2);
    }

    public void setMinSaturation(float f) {
        this.minSaturation = this.normalize(f);
    }

    public float getMinSaturation() {
        return this.minSaturation;
    }

    public void setMaxSaturation(float f) {
        this.maxSaturation = this.normalize(f);
    }

    public float getMaxSaturation() {
        return this.maxSaturation;
    }

    public void setSaturation(float f, float f2) {
        this.setMinSaturation(f);
        this.setMaxSaturation(f2);
    }

    public void setMinBrightness(float f) {
        this.minBrightness = this.normalize(f);
    }

    public float getMinBrightness() {
        return this.minBrightness;
    }

    public void setMaxBrightness(float f) {
        this.maxBrightness = this.normalize(f);
    }

    public float getMaxBrightness() {
        return this.maxBrightness;
    }

    public void setBrightness(float f, float f2) {
        this.setMinBrightness(f);
        this.setMaxBrightness(f2);
    }

    public abstract void setParameter(double var1, double var3);

    public Color getColor(double d) {
        d = Math.min(d, this.maxBorder);
        d = Math.max(d, this.minBorder);
        float f = (float)((d - this.minBorder) / (this.maxBorder - this.minBorder));
        return this.getSpectrum(this.normalize(this.getValue(f)));
    }

    public abstract float getValue(float var1);

    public Color getSpectrum(float f) {
        float f2 = this.minHue + f * (this.maxHue - this.minHue);
        float f3 = this.minSaturation + f * (this.maxSaturation - this.minSaturation);
        float f4 = this.minBrightness + f * (this.maxBrightness - this.minBrightness);
        return Color.getHSBColor(f2, f3, f4);
    }

    protected float normalize(float f) {
        if (f < 0.0f) {
            return 0.0f;
        }
        if (f > 1.0f) {
            return 1.0f;
        }
        return f;
    }

    public String toString() {
        return super.toString() + "(" + this.minBorder + " > " + this.maxBorder + ")";
    }
}

