/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.IColorizer;
import de.geocalc.awt.IColorizerSlider;
import de.geocalc.awt.IFloatColorizer;
import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class IFloatColorizerSlider
extends IColorizerSlider
implements MouseListener,
MouseMotionListener,
Adjustable {
    private static final int POINT_O = 0;
    private static final int POINT_M = 1;
    private static final int CAPTURE_DIST = 20;
    private static final float MIN = 0.0f;
    private static final float MAX = 1.0f;
    private static final float MD = 0.01f;
    private IFloatColorizer colorizer;
    private int dragPoint = 0;
    private float xm = 0.5f;
    private float ym = 0.5f;
    private AdjustmentListener adjustmentListener;
    private static final int W = 6;
    private static final int W2 = 3;

    public IFloatColorizerSlider() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setForeground(SystemColor.controlText);
        this.setBackground(SystemColor.control);
    }

    @Override
    public void setColorizer(IColorizer iColorizer) {
        IFloatColorizer iFloatColorizer;
        this.colorizer = iFloatColorizer = (IFloatColorizer)iColorizer;
        this.xm = 0.5f;
        this.ym = iFloatColorizer.getValue(this.xm);
    }

    @Override
    public int getOrientation() {
        return 0;
    }

    @Override
    public void setMinimum(int n) {
    }

    @Override
    public int getMinimum() {
        return 0;
    }

    @Override
    public void setMaximum(int n) {
    }

    @Override
    public int getMaximum() {
        return 1;
    }

    @Override
    public void setUnitIncrement(int n) {
    }

    @Override
    public int getUnitIncrement() {
        return 1;
    }

    @Override
    public void setBlockIncrement(int n) {
    }

    @Override
    public int getBlockIncrement() {
        return 1;
    }

    @Override
    public void setVisibleAmount(int n) {
    }

    @Override
    public int getVisibleAmount() {
        return 1;
    }

    @Override
    public void setValue(int n) {
    }

    @Override
    public int getValue() {
        return 1;
    }

    @Override
    public void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.adjustmentListener = adjustmentListener;
    }

    @Override
    public void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        if (this.adjustmentListener == adjustmentListener) {
            this.adjustmentListener = null;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(200, 200);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(2000, 2000);
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.colorizer == null) {
            return;
        }
        Dimension dimension = this.getSize();
        for (int i = 0; i <= dimension.height; ++i) {
            graphics.setColor(this.colorizer.getSpectrum((float)((double)i / (double)dimension.height)));
            int n = dimension.height - i;
            graphics.drawLine(0, n, dimension.width, n);
        }
        this.drawLine(graphics, false);
    }

    private void drawLine(Graphics graphics, boolean bl) {
        Dimension dimension = this.getSize();
        if (bl) {
            graphics.setColor(Color.white);
            graphics.setXORMode(Color.magenta);
        } else {
            graphics.setColor(this.getForeground());
            graphics.setPaintMode();
        }
        int n = 0;
        int n2 = dimension.height;
        for (int i = 0; i < dimension.width; i += 3) {
            int n3 = i;
            int n4 = dimension.height - (int)Math.rint(this.normalize(this.colorizer.getValue((float)i / (float)dimension.width)) * (float)dimension.height);
            if (n4 == dimension.height) {
                --n4;
            }
            graphics.drawLine(n, n2, n3, n4);
            n = n3;
            n2 = n4;
        }
        this.drawMarker(graphics, this.xm, this.ym, dimension);
    }

    private void drawMarker(Graphics graphics, float f, float f2, Dimension dimension) {
        Point point = new Point((int)Math.rint(f * (float)dimension.width), dimension.height - (int)Math.rint(f2 * (float)dimension.height));
        point.x = Math.max(3, point.x);
        point.x = Math.min(point.x, dimension.width - 3);
        point.y = Math.max(3, point.y);
        point.y = Math.min(point.y, dimension.height - 3);
        graphics.fillRect(point.x - 3, point.y - 3, 6, 6);
    }

    private Point getGraphicPoint(float f, float f2) {
        Dimension dimension = this.getSize();
        return new Point((int)Math.rint(f * (float)dimension.width), dimension.height - (int)Math.rint(f2 * (float)dimension.height));
    }

    private int getGraphicDist(Point point, Point point2) {
        return (int)Math.rint(Math.sqrt((point2.x - point.x) * (point2.x - point.x) + (point2.y - point.y) * (point2.y - point.y)));
    }

    private float getX(int n) {
        return (float)((double)n / (double)this.getSize().width);
    }

    private float getY(int n) {
        double d = this.getSize().height;
        return (float)((d - (double)n) / d);
    }

    private float normalize(float f) {
        if (f < 0.0f) {
            return 0.0f;
        }
        if (f > 1.0f) {
            return 1.0f;
        }
        return f;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        if (this.getGraphicDist(point, this.getGraphicPoint(this.xm, this.ym)) < 20) {
            this.dragPoint = 1;
            this.drawLine(this.getGraphics(), true);
        } else {
            this.dragPoint = 0;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.dragPoint != 0) {
            this.drawLine(this.getGraphics(), true);
            if (this.adjustmentListener != null) {
                this.adjustmentListener.adjustmentValueChanged(new AdjustmentEvent(this, 601, 1, 0));
            }
        }
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.dragPoint == 0) {
            return;
        }
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        float f = this.normalize(this.getX(point.x));
        float f2 = this.normalize(this.getY(point.y));
        this.drawLine(this.getGraphics(), true);
        if (this.dragPoint == 1) {
            f2 = Math.max(0.01f, f2);
            f2 = Math.min(0.99f, f2);
            f = Math.max(0.01f, f);
            this.xm = f = Math.min(0.99f, f);
            this.ym = f2;
        }
        this.colorizer.setParameter(this.xm, this.ym);
        this.ym = this.normalize(this.colorizer.getValue(this.xm));
        this.drawLine(this.getGraphics(), true);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

