/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.IColorizer;
import de.geocalc.awt.IColorizerSlider;
import de.geocalc.awt.IFloatColorizer;
import de.geocalc.awt.IFloatColorizerSlider;
import de.geocalc.text.DecimalFormat;
import de.geocalc.text.IFormat;
import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;

public class IFloatColorizerValueSlider
extends IColorizerSlider
implements AdjustmentListener,
Adjustable {
    private static final int SCALE_DIST = 1;
    private static final int TEXT_DIST = 2;
    private static final Font DEFAULT_FONT = new Font("Serif", 0, 12);
    private IFloatColorizer colorizer;
    private IFloatColorizerSlider slider = null;
    private Scrollbar bar;
    private double minValue = 0.0;
    private double maxValue = 1.0;
    private int scaleHeight = 10;
    private AdjustmentListener adjustmentListener;

    public IFloatColorizerValueSlider() {
        this((IFloatColorizer)null);
    }

    public IFloatColorizerValueSlider(IFloatColorizer iFloatColorizer) {
        this.setColorizer(iFloatColorizer);
        this.setBackground(SystemColor.control);
        this.setLayout(new BorderLayout());
        this.slider = new IFloatColorizerSlider();
        this.add((Component)this.slider, "Center");
        this.slider.addAdjustmentListener(this);
        this.bar = new Scrollbar(0, 100, 10, 0, 100);
        this.add((Component)this.bar, "South");
        this.bar.addAdjustmentListener(this);
        this.setColorizerParameter();
        if (iFloatColorizer != null) {
            this.bar.setValue((int)Math.rint(iFloatColorizer.getBorderScale() * 100.0f));
        }
    }

    @Override
    public int getOrientation() {
        return this.bar.getOrientation();
    }

    @Override
    public void setMinimum(int n) {
        this.bar.setMinimum(n);
    }

    @Override
    public int getMinimum() {
        return this.bar.getMinimum();
    }

    @Override
    public void setMaximum(int n) {
        this.bar.setMaximum(n);
    }

    @Override
    public int getMaximum() {
        return this.bar.getMaximum();
    }

    @Override
    public void setUnitIncrement(int n) {
        this.bar.setUnitIncrement(n);
    }

    @Override
    public int getUnitIncrement() {
        return this.bar.getUnitIncrement();
    }

    @Override
    public void setBlockIncrement(int n) {
        this.bar.setBlockIncrement(n);
    }

    @Override
    public int getBlockIncrement() {
        return this.bar.getBlockIncrement();
    }

    @Override
    public void setVisibleAmount(int n) {
        this.bar.setVisibleAmount(n);
    }

    @Override
    public int getVisibleAmount() {
        return this.bar.getVisibleAmount();
    }

    @Override
    public void setValue(int n) {
        this.bar.setValue(n);
    }

    @Override
    public int getValue() {
        return this.bar.getValue();
    }

    @Override
    public void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.adjustmentListener = adjustmentListener;
    }

    @Override
    public void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        if (this.adjustmentListener == adjustmentListener) {
            this.adjustmentListener = null;
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getAdjustable() == this.bar) {
            this.colorizer.setBorderScale((float)this.bar.getValue() / 100.0f);
            this.setColorizerParameter();
            this.repaint();
        }
        if (this.adjustmentListener != null) {
            this.adjustmentListener.adjustmentValueChanged(adjustmentEvent);
        }
    }

    private void setColorizerParameter() {
        if (this.colorizer != null) {
            this.minValue = this.colorizer.getMinBorder();
            this.maxValue = this.colorizer.getMaxBorder();
        }
    }

    @Override
    public void setColorizer(IColorizer iColorizer) {
        IFloatColorizer iFloatColorizer;
        this.colorizer = iFloatColorizer = (IFloatColorizer)iColorizer;
        this.setColorizerParameter();
        if (this.slider != null) {
            this.slider.setColorizer(iFloatColorizer);
        }
        if (iFloatColorizer != null && this.bar != null) {
            int n = (int)((iFloatColorizer.getMaxBorder() - iFloatColorizer.getMinBorder()) * 100.0 / (iFloatColorizer.getMaxValue() - iFloatColorizer.getMinValue()));
            this.bar.setValue(n);
        }
    }

    public void setScaleHight(int n) {
        this.scaleHeight = n;
    }

    @Override
    public Insets getInsets() {
        Font font = this.getFont() != null ? this.getFont() : DEFAULT_FONT;
        FontMetrics fontMetrics = this.getFontMetrics(font);
        return new Insets(1, 1, 2 + this.scaleHeight + 2 + fontMetrics.getHeight() + 1, 1);
    }

    private double computeScaleDist(double d) {
        if (d < 1.0E-4) {
            return 1.0E-5;
        }
        if (d < 2.0E-4) {
            return 2.0E-5;
        }
        if (d < 5.0E-4) {
            return 5.0E-5;
        }
        if (d < 0.001) {
            return 1.0E-4;
        }
        if (d < 0.002) {
            return 2.0E-4;
        }
        if (d < 0.005) {
            return 5.0E-4;
        }
        if (d < 0.01) {
            return 0.001;
        }
        if (d < 0.02) {
            return 0.002;
        }
        if (d < 0.05) {
            return 0.005;
        }
        if (d < 0.1) {
            return 0.01;
        }
        if (d < 0.2) {
            return 0.02;
        }
        if (d < 0.5) {
            return 0.05;
        }
        if (d < 1.0) {
            return 0.1;
        }
        if (d < 2.0) {
            return 0.2;
        }
        if (d < 5.0) {
            return 0.5;
        }
        if (d < 10.0) {
            return 1.0;
        }
        if (d < 20.0) {
            return 2.0;
        }
        if (d < 50.0) {
            return 5.0;
        }
        if (d < 100.0) {
            return 10.0;
        }
        if (d < 200.0) {
            return 20.0;
        }
        if (d < 500.0) {
            return 50.0;
        }
        if (d < 1000.0) {
            return 100.0;
        }
        if (d < 2000.0) {
            return 200.0;
        }
        if (d < 5000.0) {
            return 500.0;
        }
        if (d < 10000.0) {
            return 1000.0;
        }
        if (d < 20000.0) {
            return 2000.0;
        }
        if (d < 50000.0) {
            return 5000.0;
        }
        if (d < 100000.0) {
            return 10000.0;
        }
        if (d < 200000.0) {
            return 20000.0;
        }
        if (d < 500000.0) {
            return 50000.0;
        }
        return 100000.0;
    }

    private int computeScaleDigits(double d) {
        if (d < 5.0E-4) {
            return 5;
        }
        if (d < 0.005) {
            return 4;
        }
        if (d < 0.05) {
            return 3;
        }
        if (d < 0.5) {
            return 2;
        }
        if (d < 5.0) {
            return 1;
        }
        return 0;
    }

    private DecimalFormat computeFormat(int n) {
        if (n >= 5) {
            return IFormat.f_5;
        }
        if (n == 4) {
            return IFormat.f_4;
        }
        if (n == 3) {
            return IFormat.f_3;
        }
        if (n == 2) {
            return IFormat.f_2;
        }
        if (n == 1) {
            return IFormat.f_1;
        }
        return IFormat.i;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Font font = this.getFont() != null ? this.getFont() : DEFAULT_FONT;
        FontMetrics fontMetrics = this.getFontMetrics(font);
        Dimension dimension = this.getSize();
        int n = dimension.height - (2 + this.scaleHeight + 2 + fontMetrics.getHeight() + 1);
        graphics.setColor(SystemColor.controlShadow);
        graphics.drawRect(0, 0, dimension.width - 1, n);
        graphics.setColor(SystemColor.controlLtHighlight);
        graphics.drawLine(dimension.width - 1, 0, dimension.width - 1, n);
        graphics.drawLine(1, n, dimension.width, n);
        double d = this.computeScaleDist(this.maxValue - this.minValue);
        int n2 = this.computeScaleDigits(this.maxValue - this.minValue);
        DecimalFormat decimalFormat = this.computeFormat(n2);
        DecimalFormat decimalFormat2 = this.computeFormat(n2 + 1);
        int n3 = ++n + this.scaleHeight + 2 + fontMetrics.getHeight();
        int n4 = -4;
        int n5 = dimension.width - fontMetrics.stringWidth(decimalFormat2.format(this.maxValue)) - 2;
        double d2 = (double)dimension.width / (this.maxValue - this.minValue);
        String string = decimalFormat2.format(this.minValue);
        this.drawScaleString(graphics, string, 0, n3);
        this.drawScaleLine(graphics, 0, n, true);
        n4 = fontMetrics.stringWidth(string) + 4;
        for (double d3 = this.minValue; d3 <= this.maxValue + d; d3 += d) {
            int n6;
            int n7;
            double d4 = (double)((int)(d3 / d)) * d;
            if (d4 < this.minValue) {
                d4 = this.minValue;
            } else if (d4 > this.maxValue) {
                d4 = this.maxValue;
            }
            int n8 = (int)((d4 - this.minValue) * d2);
            if (n8 > dimension.width - 2) {
                n8 = dimension.width - 2;
            }
            if ((n7 = n8 - (n6 = fontMetrics.stringWidth(string = decimalFormat.format(d4)) + 4) / 2) < 0) {
                n7 = 0;
            }
            boolean bl = false;
            if (n7 + n6 < n5 && n7 > n4) {
                this.drawScaleString(graphics, string, n7, n3);
                n4 = n7 + n6 + 2;
                bl = true;
            }
            this.drawScaleLine(graphics, n8, n, bl);
        }
        string = decimalFormat2.format(this.maxValue);
        this.drawScaleString(graphics, string, dimension.width - fontMetrics.stringWidth(string), n3);
        this.drawScaleLine(graphics, dimension.width - 2, n, true);
    }

    private void drawScaleLine(Graphics graphics, int n, int n2, boolean bl) {
        int n3 = bl ? this.scaleHeight : this.scaleHeight / 2;
        graphics.setColor(SystemColor.controlDkShadow);
        graphics.drawLine(n, n2, n, n2 + n3);
        graphics.setColor(SystemColor.controlLtHighlight);
        graphics.drawLine(n + 1, n2, n + 1, n2 + n3);
    }

    private void drawScaleString(Graphics graphics, String string, int n, int n2) {
        graphics.setColor(this.getForeground());
        graphics.drawString(string, n, n2);
    }
}

