/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.IPanel;
import java.awt.AWTEventMulticaster;
import java.awt.Choice;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class IFontChoice
extends IPanel
implements ItemListener {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    Choice familyChoice;
    Choice styleChoice;
    Choice sizeChoice;
    ItemListener itemListener;
    private Font font;
    public static final Font DEFAULT_FONT = new Font("Serif", 0, 12);

    public IFontChoice() {
        this(1, null);
    }

    public IFontChoice(int n) {
        this(n, null);
    }

    public IFontChoice(int n, Font font) {
        this.setFont(new Font("Serif", 0, 12));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        gridBagConstraints.ipadx = 2;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        Label label = new Label("Schriftart:");
        this.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.familyChoice = new Choice();
        this.add(this.familyChoice);
        this.familyChoice.addItemListener(this);
        this.familyChoice.addItem("SansSerif");
        this.familyChoice.addItem("Serif");
        this.familyChoice.addItem("Monospaced");
        gridBagConstraints.gridx = n == 0 ? 0 : 1;
        gridBagConstraints.gridy = n == 0 ? 1 : 0;
        gridBagLayout.setConstraints(this.familyChoice, gridBagConstraints);
        label = new Label("Schnitt:");
        this.add(label);
        gridBagConstraints.gridx = n == 0 ? 1 : 0;
        gridBagConstraints.gridy = n == 0 ? 0 : 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.styleChoice = new Choice();
        this.add(this.styleChoice);
        this.styleChoice.addItemListener(this);
        this.styleChoice.addItem("Normal");
        this.styleChoice.addItem("Fett");
        this.styleChoice.addItem("Kursiv");
        this.styleChoice.addItem("Fett Kursiv");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.styleChoice, gridBagConstraints);
        label = new Label("Grad:");
        this.add(label);
        gridBagConstraints.gridx = n == 0 ? 2 : 0;
        gridBagConstraints.gridy = n == 0 ? 0 : 2;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.sizeChoice = new Choice();
        this.add(this.sizeChoice);
        this.sizeChoice.addItemListener(this);
        this.sizeChoice.addItem("8");
        this.sizeChoice.addItem("9");
        this.sizeChoice.addItem("10");
        this.sizeChoice.addItem("11");
        this.sizeChoice.addItem("12");
        this.sizeChoice.addItem("14");
        this.sizeChoice.addItem("16");
        this.sizeChoice.addItem("18");
        this.sizeChoice.addItem("20");
        this.sizeChoice.addItem("24");
        this.sizeChoice.addItem("28");
        this.sizeChoice.addItem("32");
        gridBagConstraints.gridx = n == 0 ? 2 : 1;
        gridBagConstraints.gridy = n == 0 ? 1 : 2;
        gridBagLayout.setConstraints(this.sizeChoice, gridBagConstraints);
        this.setChoiceFont(font);
    }

    public void setChoiceFont(Font font) {
        this.font = font;
        if (font != null) {
            this.setChoices(font);
        } else {
            this.setChoices(DEFAULT_FONT);
        }
    }

    public Font getChoiceFont() {
        return this.font;
    }

    public void addItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    private void setChoices(Font font) {
        String string = font.getName();
        if (string.equals("Serif") || string.equals("SansSerif") || string.equals("Monospaced")) {
            this.familyChoice.select(string);
        } else {
            this.familyChoice.select(DEFAULT_FONT.getName());
        }
        switch (font.getStyle()) {
            case 0: {
                this.styleChoice.select("Normal");
                break;
            }
            case 1: {
                this.styleChoice.select("Fett");
                break;
            }
            case 2: {
                this.styleChoice.select("Kursiv");
                break;
            }
            default: {
                this.styleChoice.select("Fett Kursiv");
            }
        }
        String string2 = new Integer(font.getSize()).toString();
        boolean bl = false;
        for (int i = 0; i < this.sizeChoice.getItemCount(); ++i) {
            if (!string2.equals(this.sizeChoice.getItem(i))) continue;
            this.sizeChoice.select(i);
            bl = true;
            break;
        }
        if (!bl) {
            this.sizeChoice.select(new Integer(DEFAULT_FONT.getSize()).toString());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.font = new Font(this.familyChoice.getSelectedItem(), this.styleChoice.getSelectedIndex(), Integer.parseInt(this.sizeChoice.getSelectedItem()));
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(itemEvent);
        }
    }
}

