/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.IDialog;
import de.geocalc.awt.IFontChoice;
import de.geocalc.awt.IFontViewer;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IPanel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class IFontDialog
extends IDialog
implements ActionListener,
ItemListener {
    private static final String OK_COMMAND = "OK";
    private static final String ABORT_COMMAND = "Abbrechen";
    private Button okButton;
    private Button abortButton;
    private IFontChoice fontChoice;
    private IFontViewer fontViewer;
    private Font font;
    private boolean isChoiced = false;

    public IFontDialog(IFrame iFrame, String string, boolean bl) {
        this(iFrame, string, bl, null);
    }

    public IFontDialog(IFrame iFrame, String string, boolean bl, Font font) {
        super(iFrame, string, bl);
        this.font = font;
        this.setLayout(new BorderLayout());
        this.fontViewer = new IFontViewer(font);
        this.fontViewer.setBorder(new IBorder(1));
        this.fontViewer.setFont(this.getFont());
        this.add("North", this.fontViewer);
        this.fontChoice = new IFontChoice(1, font);
        this.fontChoice.setBorder(new IBorder(1));
        this.fontChoice.addItemListener(this);
        this.add("Center", this.fontChoice);
        this.add("South", this.layoutButtonPanel());
        this.pack();
        this.setLocationOfParent(iFrame);
        this.setResizable(false);
    }

    private Panel layoutButtonPanel() {
        Panel panel = new Panel(new FlowLayout(2));
        this.okButton = new Button(OK_COMMAND);
        this.okButton.addActionListener(this);
        panel.add(this.okButton);
        this.abortButton = new Button(ABORT_COMMAND);
        this.abortButton.addActionListener(this);
        panel.add(this.abortButton);
        return panel;
    }

    private IPanel layoutViewerPanel() {
        IPanel iPanel = new IPanel();
        return iPanel;
    }

    private IPanel layoutChoicePanel() {
        IPanel iPanel = new IPanel();
        return iPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(OK_COMMAND)) {
            this.isChoiced = true;
        }
        this.endDialog();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.font = this.fontChoice.getChoiceFont();
        this.fontViewer.setViewFont(this.font);
    }

    public boolean isChoiced() {
        return this.isChoiced;
    }

    public Font getChoiceFont() {
        return this.font;
    }

    @Override
    protected void doStandardAction() {
        this.isChoiced = true;
        this.endDialog();
    }

    @Override
    protected void doAbortAction() {
        this.isChoiced = false;
        this.endDialog();
    }
}

