/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.IPanel;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.SystemColor;

public class IFontViewer
extends IPanel {
    private Font font;
    private String text = "TextText";

    public IFontViewer(Font font) {
        this.font = font;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(200, 80);
    }

    public void setViewFont(Font font) {
        this.font = font;
        this.repaint();
    }

    public Font getViewFont() {
        return this.font;
    }

    public void setText(String string) {
        this.text = string;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Insets insets = this.getInsets();
        Dimension dimension = this.getSize();
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        graphics.clearRect(insets.left, insets.top, dimension.width, dimension.height);
        if (this.font != null && this.text != null) {
            graphics.setFont(this.font);
            FontMetrics fontMetrics = this.getFontMetrics(this.font);
            int n = insets.left + (dimension.width - fontMetrics.stringWidth(this.text)) / 2;
            int n2 = insets.top + dimension.height / 2 + fontMetrics.getAscent() / 2;
            graphics.setColor(SystemColor.textText);
            graphics.drawString(this.text, n, n2);
        }
    }
}

