/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.IToolTipManager;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.net.URL;
import java.util.ArrayList;

public class IFrame
extends Frame {
    private Rectangle dialogWindow = new Rectangle();
    private static IToolTipManager toolTipManager = new IToolTipManager();

    public IFrame() {
        toolTipManager.setParent(this);
    }

    public IFrame(String string) {
        super(string);
        toolTipManager.setParent(this);
    }

    public static IToolTipManager getToolTipManager() {
        return toolTipManager;
    }

    public void setToolTipsEnabled(boolean bl) {
        toolTipManager.setEnabled(bl);
    }

    public boolean isToolTipsEnabled() {
        return toolTipManager.isEnabled();
    }

    public void setDialogWindow(Rectangle rectangle) {
        this.dialogWindow = rectangle;
    }

    public Rectangle getDialogWindow() {
        return this.dialogWindow;
    }

    public Rectangle getDialogPlace() {
        return new Rectangle(this.getLocationOnScreen().x + this.dialogWindow.x, this.getLocationOnScreen().y + this.dialogWindow.y, this.dialogWindow.width, this.dialogWindow.height);
    }

    protected void loadIcon(URL uRL) {
        try {
            Image image = this.getToolkit().getImage(uRL);
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(image, 0);
            try {
                mediaTracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.setIconImage(image);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void loadIconSet(String string) {
        ArrayList<Image> arrayList = new ArrayList<Image>();
        try {
            arrayList.add(this.loadIcon(string + "_16.png"));
            arrayList.add(this.loadIcon(string + "_20.png"));
            arrayList.add(this.loadIcon(string + "_24.png"));
            arrayList.add(this.loadIcon(string + "_32.png"));
            arrayList.add(this.loadIcon(string + "_40.png"));
            arrayList.add(this.loadIcon(string + "_48.png"));
            arrayList.add(this.loadIcon(string + "_64.png"));
            arrayList.add(this.loadIcon(string + "_128.png"));
            arrayList.add(this.loadIcon(string + "_256.png"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setIconImages(arrayList);
    }

    private Image loadIcon(String string) {
        return Toolkit.getDefaultToolkit().getImage(this.getClass().getResource(string));
    }

    @Override
    public Insets getInsets() {
        Insets insets = super.getInsets();
        insets.top += 5;
        insets.left += 5;
        insets.right += 5;
        insets.bottom += 5;
        return insets;
    }
}

