/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.ClearPolygon;
import de.geocalc.awt.IViewport;
import de.geocalc.geom.DArc;
import de.geocalc.geom.DCollection;
import de.geocalc.geom.DLine;
import de.geocalc.geom.DPoint;
import de.geocalc.geom.DPolygon;
import de.geocalc.geom.DRectangle;
import de.geocalc.geom.GeomElement;
import de.geocalc.geom.Transform;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.util.Enumeration;

public class IGraphics
implements Cloneable {
    public static final Stroke DEFAULT_STROKE = new BasicStroke();
    public static final Stroke DEFAULT_STROKE_RAISED = new BasicStroke(3.0f);
    private Graphics g;
    private Transform trafo;
    private Rectangle drawRect;
    private Rectangle viewRect;
    private IViewport viewport = null;
    private Point gp1 = new Point();
    private Point gp2 = new Point();
    private boolean isClip = false;
    private double minDisplaySize = 0.0;
    private static final Rectangle maxRect = new Rectangle(-32765, -32765, 65530, 65530);
    static double lastY;
    static double lastX;

    public IGraphics(Graphics graphics, Transform transform, Rectangle rectangle) {
        this.g = graphics;
        this.trafo = transform;
        this.drawRect = rectangle;
        this.computeParam();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public final void setClip(boolean bl) {
        this.isClip = bl;
    }

    public final boolean isClip() {
        return this.isClip;
    }

    public final Graphics getGraphics() {
        return this.g;
    }

    public final void setGraphics(Graphics graphics) {
        this.g = graphics;
    }

    public void setMinDiplaySize(double d) {
        this.minDisplaySize = d;
        if (this.viewport != null) {
            this.viewport.setMinGeomSize(d);
        }
    }

    public final void setRenderingHint(RenderingHints.Key key, Object object) {
        if (this.g instanceof Graphics2D) {
            ((Graphics2D)this.g).setRenderingHint(key, object);
        }
    }

    public final void setPaintMode() {
        this.g.setPaintMode();
    }

    public final void setPaintMode(Color color) {
        this.g.setPaintMode();
        this.g.setColor(color);
    }

    public final void setXORMode() {
        this.g.setColor(Color.white);
        this.g.setXORMode(Color.magenta);
    }

    public final void setXORMode(Color color) {
        this.g.setColor(Color.white);
        this.g.setXORMode(color);
    }

    public void setColor(Color color) {
        this.g.setColor(color);
    }

    public void setStroke(Stroke stroke) {
        if (this.g instanceof Graphics2D) {
            ((Graphics2D)this.g).setStroke(stroke);
        }
    }

    public final void setTransform(Transform transform) {
        this.trafo = this.trafo;
        this.computeParam();
    }

    public final Transform getTransform() {
        return this.trafo;
    }

    public final double getRotation() {
        return this.trafo.getRotation();
    }

    public final double getScale() {
        return this.trafo.getScale();
    }

    public final void setDrawRect(Rectangle rectangle) {
        this.drawRect = rectangle;
        this.computeParam();
    }

    public final Rectangle getDrawRect() {
        return this.drawRect;
    }

    public final void setViewRect(Rectangle rectangle) {
        this.viewRect = rectangle;
    }

    public final Rectangle getViewRect() {
        return this.viewRect;
    }

    public final IViewport getViewport() {
        return this.viewport;
    }

    private void computeParam() {
        if (this.drawRect != null && this.trafo != null) {
            double d = Double.MIN_VALUE;
            double d2 = Double.MIN_VALUE;
            double d3 = Double.MAX_VALUE;
            double d4 = Double.MAX_VALUE;
            DPoint dPoint = new DPoint();
            dPoint = this.getDataPoint(new Point(this.drawRect.x, this.drawRect.y), dPoint);
            d = Math.max(d, dPoint.y);
            d2 = Math.max(d2, dPoint.x);
            d3 = Math.min(d3, dPoint.y);
            d4 = Math.min(d4, dPoint.x);
            dPoint = this.getDataPoint(new Point(this.drawRect.x + this.drawRect.width, this.drawRect.y), dPoint);
            d = Math.max(d, dPoint.y);
            d2 = Math.max(d2, dPoint.x);
            d3 = Math.min(d3, dPoint.y);
            d4 = Math.min(d4, dPoint.x);
            dPoint = this.getDataPoint(new Point(this.drawRect.x + this.drawRect.width, this.drawRect.y + this.drawRect.height), dPoint);
            d = Math.max(d, dPoint.y);
            d2 = Math.max(d2, dPoint.x);
            d3 = Math.min(d3, dPoint.y);
            d4 = Math.min(d4, dPoint.x);
            dPoint = this.getDataPoint(new Point(this.drawRect.x, this.drawRect.y + this.drawRect.height), dPoint);
            d = Math.max(d, dPoint.y);
            d2 = Math.max(d2, dPoint.x);
            d3 = Math.min(d3, dPoint.y);
            d4 = Math.min(d4, dPoint.x);
            Point point = this.getGraphicPoint(new DPoint(d3, d2), new Point());
            Point point2 = this.getGraphicPoint(new DPoint(d, d2), new Point());
            Point point3 = this.getGraphicPoint(new DPoint(d3, d4), new Point());
            Point point4 = this.getGraphicPoint(new DPoint(d, d4), new Point());
            this.viewport = new IViewport(d3, d4, d - d3, d2 - d4, point3, point4, point, point2, this.trafo.getScale(), this.minDisplaySize);
            dPoint = this.getDataPoint(new Point(IGraphics.maxRect.x, IGraphics.maxRect.y), dPoint);
            d = Math.max(d, dPoint.y);
            d2 = Math.max(d2, dPoint.x);
            d3 = Math.min(d3, dPoint.y);
            d4 = Math.min(d4, dPoint.x);
            dPoint = this.getDataPoint(new Point(IGraphics.maxRect.x + IGraphics.maxRect.width, IGraphics.maxRect.y), dPoint);
            d = Math.max(d, dPoint.y);
            d2 = Math.max(d2, dPoint.x);
            d3 = Math.min(d3, dPoint.y);
            d4 = Math.min(d4, dPoint.x);
            dPoint = this.getDataPoint(new Point(IGraphics.maxRect.x + IGraphics.maxRect.width, IGraphics.maxRect.y + IGraphics.maxRect.height), dPoint);
            d = Math.max(d, dPoint.y);
            d2 = Math.max(d2, dPoint.x);
            d3 = Math.min(d3, dPoint.y);
            d4 = Math.min(d4, dPoint.x);
            dPoint = this.getDataPoint(new Point(IGraphics.maxRect.x, IGraphics.maxRect.y + IGraphics.maxRect.height), dPoint);
            d = Math.max(d, dPoint.y);
            d2 = Math.max(d2, dPoint.x);
            d3 = Math.min(d3, dPoint.y);
            d4 = Math.min(d4, dPoint.x);
            point = this.getGraphicPoint(new DPoint(d3, d2), new Point());
            point2 = this.getGraphicPoint(new DPoint(d, d2), new Point());
            point3 = this.getGraphicPoint(new DPoint(d3, d4), new Point());
            point4 = this.getGraphicPoint(new DPoint(d, d4), new Point());
        }
    }

    public final Point getGraphicPoint(DPoint dPoint, Point point) {
        return this.trafo.transform(dPoint, point);
    }

    public final Point getGraphicPoint(double d, double d2, Point point) {
        return this.trafo.transform(d, d2, point);
    }

    public final DPoint getDataPoint(Point point, DPoint dPoint) {
        return this.trafo.inverse(point, dPoint);
    }

    public final Polygon getGraphicBogenPolygon(DPoint dPoint, DPoint dPoint2, double d) {
        DPolygon dPolygon = this.getDataBogenPolygon(dPoint, dPoint2, d);
        Polygon polygon = new Polygon();
        if (dPolygon.npoints == 0) {
            return polygon;
        }
        DPoint dPoint3 = new DPoint();
        Point point = new Point();
        double d2 = dPolygon.ypoints[0];
        double d3 = dPolygon.xpoints[0];
        int n = this.viewport.incode(d2, d3);
        for (int i = 1; i < dPolygon.npoints; ++i) {
            double d4 = dPolygon.ypoints[i];
            double d5 = dPolygon.xpoints[i];
            n = IGraphics.addViewPortPoints(n, d2, d3, this.viewport, polygon);
            DLine dLine = this.viewport.intersectLine(d2, d3, d4, d5);
            if (dLine != null) {
                dPoint3.y = dLine.ya;
                dPoint3.x = dLine.xa;
                point = this.trafo.transform(dPoint3, point);
                polygon.addPoint(point.x, point.y);
                dPoint3.y = dLine.ye;
                dPoint3.x = dLine.xe;
                point = this.trafo.transform(dPoint3, point);
                polygon.addPoint(point.x, point.y);
                n = this.viewport.incode(dLine.ye, dLine.xe);
            }
            n = IGraphics.addViewPortPoints(n, d4, d5, this.viewport, polygon);
            d2 = d4;
            d3 = d5;
        }
        return polygon;
    }

    public final DPolygon getDataBogenPolygon(DPoint dPoint, DPoint dPoint2, double d) {
        DLine dLine;
        int n;
        DPolygon dPolygon = new DPolygon(10);
        DPoint dPoint3 = null;
        if (dPoint.equals(dPoint2)) {
            d = Math.abs(d);
            dPoint3 = dPoint;
            double d2 = Math.abs(2.0 * Math.acos(-0.01 / d + 1.0));
            double d3 = 0.0;
            double d4 = Math.PI * 2;
            double d5 = dPoint3.y;
            double d6 = dPoint3.x + d;
            dPolygon.addPoint(d5, d6);
            boolean bl = this.viewport.contains(d5, d6);
            while (true) {
                double d7;
                double d8;
                d3 += d2;
                if (!(d8 < d4)) break;
                double d9 = dPoint3.y + d * Math.sin(d3);
                DLine dLine2 = this.viewport.intersectLine(d5, d6, d9, d7 = dPoint3.x + d * Math.cos(d3));
                if (dLine2 == null) {
                    dPolygon.addPoint(d9, d7);
                } else if (bl) {
                    dPolygon.addPoint(dLine2.ye, dLine2.xe);
                } else {
                    dPolygon.addPoint(dLine2.ya, dLine2.xa);
                    dPolygon.addPoint(dLine2.ye, dLine2.xe);
                }
                bl = this.viewport.contains(d9, d7);
                d5 = d9;
                d6 = d7;
            }
            dPolygon.addPoint(dPoint3.y, dPoint3.x + d);
            return dPolygon;
        }
        dPoint3 = DArc.getCenter(dPoint.y, dPoint.x, dPoint2.y, dPoint2.x, d);
        double d10 = Math.atan2(dPoint.y - dPoint3.y, dPoint.x - dPoint3.x);
        double d11 = Math.atan2(dPoint2.y - dPoint3.y, dPoint2.x - dPoint3.x);
        double d12 = DLine.getDist(dPoint.y, dPoint.x, dPoint2.y, dPoint2.x);
        double d13 = 1.0 / this.trafo.getScale();
        double d14 = Math.abs(d) - d13;
        double d15 = Math.sqrt(d * d - d14 * d14);
        double d16 = Math.atan2(d15, d14);
        if (d11 - d10 > Math.PI || d10 - d11 > Math.PI) {
            d11 = d > 0.0 ? (d11 += Math.PI * 2) : (d11 -= Math.PI * 2);
        }
        if (d < 0.0) {
            d16 = -d16;
        }
        d12 = dPoint.y;
        d13 = dPoint.x;
        double d17 = Math.abs(d);
        DPoint dPoint4 = new DPoint(this.viewport.y, this.viewport.x + this.viewport.height);
        DPoint dPoint5 = new DPoint(this.viewport.y + this.viewport.width, this.viewport.x + this.viewport.height);
        DPoint dPoint6 = new DPoint(this.viewport.y, this.viewport.x);
        DPoint dPoint7 = new DPoint(this.viewport.y + this.viewport.width, this.viewport.x);
        DPoint[] dPointArray = new DPoint[8];
        for (int i = 0; i < 8; ++i) {
            dPointArray[i] = new DPoint();
        }
        DArc.getSysSect(dPoint3, dPoint4, dPoint5, d, dPointArray[0], dPointArray[1]);
        DArc.getSysSect(dPoint3, dPoint5, dPoint7, d, dPointArray[2], dPointArray[3]);
        DArc.getSysSect(dPoint3, dPoint6, dPoint7, d, dPointArray[4], dPointArray[5]);
        DArc.getSysSect(dPoint3, dPoint6, dPoint4, d, dPointArray[6], dPointArray[7]);
        double d18 = Double.MAX_VALUE;
        double d19 = -1.7976931348623157E308;
        for (n = 0; n < 8; ++n) {
            DPoint dPoint8 = dPointArray[n];
            if (dPoint8.y == 0.0 && dPoint8.x == 0.0 || !this.viewport.contains(dPoint8)) continue;
            double d20 = Math.atan2(dPoint8.y - dPoint3.y, dPoint8.x - dPoint3.x);
            if (d20 - d10 > Math.PI || d10 - d20 > Math.PI) {
                d20 = d > 0.0 ? (d20 += Math.PI * 2) : (d20 -= Math.PI * 2);
            }
            if (!(d16 > 0.0 && d20 > d10 && d20 < d11) && (!(d16 < 0.0) || !(d20 > d11) || !(d20 < d10))) continue;
            d18 = Math.min(d20, d18);
            d19 = Math.max(d20, d19);
        }
        n = this.viewport.contains(dPoint) ? 1 : 0;
        boolean bl = this.viewport.contains(dPoint2);
        int n2 = n;
        if (n == 0 && !bl && d18 == Double.MAX_VALUE && d19 == -1.7976931348623157E308) {
            double d21 = Math.atan2(this.viewport.y + this.viewport.width / 2.0 - dPoint3.y, this.viewport.x + this.viewport.height / 2.0 - dPoint3.x);
            if (d21 - d10 > Math.PI || d10 - d21 > Math.PI) {
                d21 = d > 0.0 ? (d21 += Math.PI * 2) : (d21 -= Math.PI * 2);
            }
            if (d16 > 0.0 && d21 > d10 && d21 < d11 || d16 < 0.0 && d21 > d11 && d21 < d10) {
                dPolygon.addPoint(dPoint3.y + d17 * Math.sin(d21), dPoint3.x + d17 * Math.cos(d21));
            } else {
                d21 = (d10 + d11) / 2.0;
                dPolygon.addPoint(dPoint3.y + d17 * Math.sin(d21), dPoint3.x + d17 * Math.cos(d21));
            }
            return dPolygon;
        }
        if (d16 > 0.0) {
            if (n == 0 && d18 != Double.MAX_VALUE) {
                d10 = d18 - d16 * 0.99;
            }
            if (!bl && d19 != -1.7976931348623157E308) {
                d11 = d19 + d16 * 0.99;
            }
        } else {
            if (!bl && d18 != Double.MAX_VALUE) {
                d11 = d18 + d16 * 0.99;
            }
            if (n == 0 && d19 != -1.7976931348623157E308) {
                d10 = d19 - d16 * 0.99;
            }
        }
        int n3 = 0;
        do {
            if (this.viewport.contains(d14 = dPoint3.y + d17 * Math.sin(d10), d15 = dPoint3.x + d17 * Math.cos(d10))) {
                if (n2 == 0) {
                    dPolygon.addPoint(d12, d13);
                    dLine = this.viewport.intersectLine(d12, d13, d14, d15);
                    dPolygon.addPoint(dLine.ya, dLine.xa);
                    dPolygon.addPoint(d14, d15);
                    n2 = 1;
                }
                dPolygon.addPoint(d14, d15);
            } else if (n2 != 0) {
                dLine = this.viewport.intersectLine(d12, d13, d14, d15);
                dPolygon.addPoint(dLine.ye, dLine.xe);
                dPolygon.addPoint(d14, d15);
                n2 = 0;
            }
            d12 = d14;
            d13 = d15;
        } while (n3++ <= 1000 && Math.abs((d10 += d16) - d11) > Math.abs(d16));
        d14 = dPoint3.y + d17 * Math.sin(d11);
        if (this.viewport.contains(d14, d15 = dPoint3.x + d17 * Math.cos(d11))) {
            if (n2 == 0) {
                dLine = this.viewport.intersectLine(d12, d13, d14, d15);
                dPolygon.addPoint(dLine.ya, dLine.xa);
            }
            dPolygon.addPoint(d14, d15);
        } else if (n2 != 0) {
            dLine = this.viewport.intersectLine(d12, d13, d14, d15);
            dPolygon.addPoint(dLine.ye, dLine.xe);
        }
        return dPolygon;
    }

    public final boolean contains(double d, double d2) {
        return this.viewport.contains(d, d2);
    }

    public final boolean contains(DPoint dPoint) {
        return this.viewport.contains(dPoint.y, dPoint.x);
    }

    public final boolean intersects(DRectangle dRectangle) {
        return this.viewport.intersects(dRectangle);
    }

    public final void drawLine(double d, double d2, double d3, double d4) {
        this.drawLine(this.viewport.intersectLine(d, d2, d3, d4));
    }

    public final void drawLine(double d, double d2, double d3, double d4, int n) {
        DLine dLine = this.viewport.intersectLine(d, d2, d3, d4);
        if (dLine == null) {
            return;
        }
        this.trafo.transform(dLine.ya, dLine.xa, this.gp1);
        this.trafo.transform(dLine.ye, dLine.xe, this.gp2);
        this.drawLine(this.gp1.x, this.gp1.y, this.gp2.x, this.gp2.y, n);
    }

    public final void drawLine(DPoint dPoint, DPoint dPoint2) {
        this.drawLine(this.viewport.intersectLine(dPoint.y, dPoint.x, dPoint2.y, dPoint2.x));
    }

    public final void drawLine(DPoint dPoint, DPoint dPoint2, int n) {
        DLine dLine = this.viewport.intersectLine(dPoint.y, dPoint.x, dPoint2.y, dPoint2.x);
        if (dLine == null) {
            return;
        }
        this.trafo.transform(dLine.ya, dLine.xa, this.gp1);
        this.trafo.transform(dLine.ye, dLine.xe, this.gp2);
        this.drawLine(this.gp1.x, this.gp1.y, this.gp2.x, this.gp2.y, n);
    }

    public final void drawLine(DPoint dPoint, DPoint dPoint2, int[] nArray, boolean bl) {
        if (bl) {
            this.drawLine(dPoint2, dPoint, 0, nArray, 1);
        } else {
            this.drawLine(dPoint, dPoint2, 0, nArray, 1);
        }
    }

    public final void drawLine(DPoint dPoint, DPoint dPoint2, BasicStroke basicStroke, boolean bl, boolean bl2) {
        DLine dLine = this.viewport.intersectLine(dPoint.y, dPoint.x, dPoint2.y, dPoint2.x);
        if (dLine == null) {
            return;
        }
        this.trafo.transform(dLine.ya, dLine.xa, this.gp1);
        this.trafo.transform(dLine.ye, dLine.xe, this.gp2);
        this.drawLine(this.gp1.x, this.gp1.y, this.gp2.x, this.gp2.y, basicStroke, bl, bl2);
    }

    public final void drawLine(DPoint dPoint, DPoint dPoint2, int n, int[] nArray, int n2) {
        DLine dLine = this.viewport.intersectLine(dPoint.y, dPoint.x, dPoint2.y, dPoint2.x);
        if (dLine == null) {
            return;
        }
        this.trafo.transform(dLine.ya, dLine.xa, this.gp1);
        this.trafo.transform(dLine.ye, dLine.xe, this.gp2);
        this.drawLine(this.gp1.x, this.gp1.y, this.gp2.x, this.gp2.y, n, nArray, n2);
    }

    private void drawLine(DLine dLine) {
        if (dLine == null) {
            return;
        }
        this.trafo.transform(dLine.ya, dLine.xa, this.gp1);
        this.trafo.transform(dLine.ye, dLine.xe, this.gp2);
        this.g.drawLine(this.gp1.x, this.gp1.y, this.gp2.x, this.gp2.y);
    }

    public final void drawPolygon(DPolygon dPolygon) {
        Polygon polygon = this.getGraphicPolygon(dPolygon);
        this.g.drawPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    public final void drawOval(DPoint dPoint, int n, BasicStroke basicStroke, boolean bl) {
        this.trafo.transform(dPoint.y, dPoint.x, this.gp1);
        this.drawOval(this.gp1.x, this.gp1.y, n, basicStroke, bl);
    }

    public final void fillOval(DPoint dPoint, int n, BasicStroke basicStroke, boolean bl) {
        this.trafo.transform(dPoint.y, dPoint.x, this.gp1);
        this.fillOval(this.gp1.x, this.gp1.y, n, basicStroke, bl);
    }

    public final void drawGeomElement(GeomElement geomElement) {
        if (geomElement instanceof DPoint) {
            Point point = this.getGraphicPoint((DPoint)geomElement, new Point());
            this.g.drawOval(point.x - 5, point.y - 5, 10, 10);
        } else if (geomElement instanceof DLine) {
            DLine dLine = (DLine)geomElement;
            Point point = this.getGraphicPoint(dLine.getStartLocation(), new Point());
            Point point2 = this.getGraphicPoint(dLine.getEndLocation(), new Point());
            this.g.drawLine(point.x, point.y, point2.x, point2.y);
        } else if (geomElement instanceof DPolygon) {
            Polygon polygon = this.getGraphicPolygon((DPolygon)geomElement);
            this.g.drawPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
        } else if (geomElement instanceof DCollection) {
            Enumeration enumeration = ((DCollection)geomElement).elements();
            while (enumeration.hasMoreElements()) {
                this.drawGeomElement((GeomElement)enumeration.nextElement());
            }
        } else {
            throw new ClassCastException("Visualisierung des Objects " + geomElement.getClass().getName() + " nicht implementiert");
        }
    }

    public final void fillGeomElement(GeomElement geomElement) {
        if (geomElement instanceof DPoint) {
            Point point = this.getGraphicPoint((DPoint)geomElement, new Point());
            this.g.fillOval(point.x - 5, point.y - 5, 10, 10);
        } else if (geomElement instanceof DLine) {
            DLine dLine = (DLine)geomElement;
            Point point = this.getGraphicPoint(dLine.getStartLocation(), new Point());
            Point point2 = this.getGraphicPoint(dLine.getEndLocation(), new Point());
            this.drawLine(point.x, point.y, point2.x, point2.y, 3);
        } else if (geomElement instanceof DPolygon) {
            Polygon polygon = this.getGraphicPolygon((DPolygon)geomElement);
            this.g.fillPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
        } else if (geomElement instanceof DCollection) {
            Enumeration enumeration = ((DCollection)geomElement).elements();
            while (enumeration.hasMoreElements()) {
                this.fillGeomElement((GeomElement)enumeration.nextElement());
            }
        } else {
            throw new ClassCastException("Visualisierung des Objects " + geomElement.getClass().getName() + " nicht implementiert");
        }
    }

    private Polygon getGraphicPolygon(DPolygon dPolygon) {
        Point point = new Point();
        int n = dPolygon.npoints;
        ClearPolygon clearPolygon = new ClearPolygon(n);
        if (n < 1) {
            return clearPolygon;
        }
        int n2 = this.viewport.incode(dPolygon.ypoints[0], dPolygon.xpoints[0]);
        for (int i = 1; i < n; ++i) {
            n2 = IGraphics.addViewPortPoints(n2, dPolygon.ypoints[i - 1], dPolygon.xpoints[i - 1], this.viewport, clearPolygon);
            DLine dLine = this.viewport.intersectLine(dPolygon.ypoints[i - 1], dPolygon.xpoints[i - 1], dPolygon.ypoints[i], dPolygon.xpoints[i]);
            if (dLine != null) {
                point = this.getGraphicPoint(dLine.ya, dLine.xa, point);
                ((Polygon)clearPolygon).addPoint(point.x, point.y);
                point = this.getGraphicPoint(dLine.ye, dLine.xe, point);
                ((Polygon)clearPolygon).addPoint(point.x, point.y);
                n2 = this.viewport.incode(dLine.ye, dLine.xe);
            }
            n2 = IGraphics.addViewPortPoints(n2, dPolygon.ypoints[i], dPolygon.xpoints[i], this.viewport, clearPolygon);
        }
        if (dPolygon.ypoints[n - 1] != dPolygon.ypoints[0] && dPolygon.xpoints[n - 1] != dPolygon.xpoints[0]) {
            n2 = IGraphics.addViewPortPoints(n2, dPolygon.ypoints[n - 1], dPolygon.xpoints[n - 1], this.viewport, clearPolygon);
            DLine dLine = this.viewport.intersectLine(dPolygon.ypoints[n - 1], dPolygon.xpoints[n - 1], dPolygon.ypoints[0], dPolygon.xpoints[0]);
            if (dLine != null) {
                point = this.getGraphicPoint(dLine.ya, dLine.xa, point);
                ((Polygon)clearPolygon).addPoint(point.x, point.y);
                point = this.getGraphicPoint(dLine.ye, dLine.xe, point);
                ((Polygon)clearPolygon).addPoint(point.x, point.y);
                n2 = this.viewport.incode(dLine.ye, dLine.xe);
            }
            n2 = IGraphics.addViewPortPoints(n2, dPolygon.ypoints[0], dPolygon.xpoints[0], this.viewport, clearPolygon);
        }
        return clearPolygon;
    }

    public final void drawLine(int n, int n2, int n3, int n4, int n5) {
        if (n5 < 2) {
            this.g.drawLine(n, n2, n3, n4);
        } else {
            double d = n3 - n;
            double d2 = n4 - n2;
            double d3 = (float)Math.sqrt(d * d + d2 * d2);
            double d4 = d / d3;
            double d5 = d2 / d3;
            double d6 = (double)n5 / 2.0;
            double d7 = d4 * d6;
            double d8 = d5 * d6;
            int[] nArray = new int[]{(int)Math.rint((double)n + d8 - d7), (int)Math.rint((double)n - d8 - d7), (int)Math.rint((double)n3 - d8 + d7), (int)Math.rint((double)n3 + d8 + d7)};
            int[] nArray2 = new int[]{(int)Math.rint((double)n2 - d7 - d8), (int)Math.rint((double)n2 + d7 - d8), (int)Math.rint((double)n4 + d7 + d8), (int)Math.rint((double)n4 - d7 + d8)};
            this.g.fillPolygon(nArray, nArray2, 4);
        }
    }

    public final void drawPolyline(int[] nArray, int[] nArray2, int n, int n2) {
        for (int i = 1; i < n; ++i) {
            this.drawLine(nArray[i - 1], nArray2[i - 1], nArray[i], nArray2[i], n2);
        }
    }

    public final void drawLine(int n, int n2, int n3, int n4, int[] nArray, boolean bl) {
        if (bl) {
            this.drawLine(n3, n4, n, n2, 1, nArray, 0);
        } else {
            this.drawLine(n, n2, n3, n4, 1, nArray, 0);
        }
    }

    public final void drawLine(int n, int n2, int n3, int n4, int n5, int[] nArray, boolean bl) {
        if (bl) {
            this.drawLine(n3, n4, n, n2, n5, nArray, 0);
        } else {
            this.drawLine(n, n2, n3, n4, n5, nArray, 0);
        }
    }

    public final void drawLine(int n, int n2, int n3, int n4, int n5, int[] nArray, int n6, boolean bl) {
        if (bl) {
            this.drawLine(n3, n4, n, n2, n5, nArray, n6);
        } else {
            this.drawLine(n, n2, n3, n4, n5, nArray, n6);
        }
    }

    private void drawLine(int n, int n2, int n3, int n4, int n5, int[] nArray, int n6) {
        double d = n3 - n;
        double d2 = n4 - n2;
        double d3 = (float)Math.sqrt(d * d + d2 * d2);
        if (d3 == 0.0) {
            return;
        }
        double d4 = d / d3;
        double d5 = d2 / d3;
        n -= (int)(d5 * (double)n6);
        n3 -= (int)(d5 * (double)n6);
        n2 += (int)(d4 * (double)n6);
        n4 += (int)(d4 * (double)n6);
        double d6 = 0.0;
        double d7 = 0.0;
        block0: while (d7 < d3) {
            for (int i = 0; i < nArray.length; ++i) {
                if (i % 2 == 0) {
                    d6 = d7;
                    if ((d7 += (double)nArray[i]) > d3) {
                        d7 = d3;
                    }
                    this.drawLine(n + (int)Math.rint(d4 * d6), n2 + (int)Math.rint(d5 * d6), n + (int)Math.rint(d4 * d7), n2 + (int)Math.rint(d5 * d7), n5);
                    continue;
                }
                if ((d7 += (double)nArray[i]) >= d3) continue block0;
            }
        }
    }

    private final void setStroke(BasicStroke basicStroke, boolean bl) {
        if (this.g instanceof Graphics2D) {
            ((Graphics2D)this.g).setStroke(bl ? new BasicStroke(basicStroke.getLineWidth() + 2.0f, basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), basicStroke.getDashArray(), basicStroke.getDashPhase()) : basicStroke);
        }
    }

    public final void setStroke(BasicStroke basicStroke) {
        if (this.g instanceof Graphics2D) {
            ((Graphics2D)this.g).setStroke(basicStroke);
        }
    }

    public final void resetStroke() {
        if (this.g instanceof Graphics2D) {
            ((Graphics2D)this.g).setStroke(DEFAULT_STROKE);
        }
    }

    public final void drawLine(int n, int n2, int n3, int n4, BasicStroke basicStroke, boolean bl, boolean bl2) {
        if (bl2) {
            this.drawLine(n3, n4, n, n2, basicStroke, bl);
        } else {
            this.drawLine(n, n2, n3, n4, basicStroke, bl);
        }
    }

    public final void drawLine(int n, int n2, int n3, int n4, BasicStroke basicStroke, boolean bl) {
        this.setStroke(basicStroke, bl);
        if (n - n3 > n2 - n4) {
            this.g.drawLine(n3, n4, n, n2);
        } else {
            this.g.drawLine(n, n2, n3, n4);
        }
        this.resetStroke();
    }

    public final void drawLine(int n, int n2, int n3, int n4, float f, BasicStroke basicStroke, boolean bl, boolean bl2) {
        if (bl && n - n3 > n2 - n4) {
            int n5 = n;
            int n6 = n2;
            n = n3;
            n2 = n4;
            n3 = n5;
            n4 = n6;
        }
        this.drawLine(n, n2, n3, n4, f, basicStroke, bl2);
    }

    public final void drawLine(int n, int n2, int n3, int n4, float f, BasicStroke basicStroke, boolean bl) {
        int n5 = n3 - n;
        int n6 = n4 - n2;
        if ((double)n5 == 0.0 && (double)n6 == 0.0) {
            return;
        }
        double d = Math.sqrt(n5 * n5 + n6 * n6);
        double d2 = (double)n5 / d;
        double d3 = (double)n6 / d;
        n -= (int)Math.rint(d3 * (double)f);
        n3 -= (int)Math.rint(d3 * (double)f);
        n2 += (int)Math.rint(d2 * (double)f);
        n4 += (int)Math.rint(d2 * (double)f);
        if (this.g instanceof Graphics2D) {
            ((Graphics2D)this.g).setStroke(bl ? new BasicStroke(basicStroke.getLineWidth() + 2.0f, basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), basicStroke.getDashArray(), basicStroke.getDashPhase()) : basicStroke);
        }
        this.g.drawLine(n3, n4, n, n2);
        this.resetStroke();
    }

    public final void drawLine(int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            this.drawLine(n3, n4, n, n2, 3);
        } else {
            this.g.drawLine(n3, n4, n, n2);
        }
    }

    public final void drawOval(int n, int n2, int n3, BasicStroke basicStroke, boolean bl) {
        this.setStroke(basicStroke, bl);
        this.g.drawOval(n - n3, n2 - n3, n3 * 2, n3 * 2);
        this.resetStroke();
    }

    public final void fillOval(int n, int n2, int n3, BasicStroke basicStroke, boolean bl) {
        this.setStroke(basicStroke, bl);
        this.g.fillOval(n - n3, n2 - n3, n3 * 2, n3 * 2);
        this.resetStroke();
    }

    public final Point getGraphicPoint(DPoint dPoint) {
        if (dPoint == null || this.trafo == null) {
            return null;
        }
        Point point = new Point();
        return this.trafo.transform(dPoint, point);
    }

    public final DPoint getPunkt(Point point) {
        if (this.trafo == null) {
            return null;
        }
        return this.trafo.inverse(point, new DPoint());
    }

    public static final int addViewPortPoints(int n, double d, double d2, IViewport iViewport, Polygon polygon) {
        int n2 = iViewport.incode(d, d2);
        if (n == 0) {
            return n2;
        }
        if ((n & 4) != 0 && (n2 & 1) != 0) {
            double d3 = d2 + (iViewport.y + iViewport.width - d) * (lastX - d2) / (lastY - d);
            if (d3 > iViewport.x + iViewport.height) {
                polygon.addPoint(iViewport.getOR().x, iViewport.getOR().y);
                n = 2;
            } else if (d3 < iViewport.x) {
                polygon.addPoint(iViewport.getUR().x, iViewport.getUR().y);
                n = 8;
            }
        } else if ((n & 1) != 0 && (n2 & 4) != 0) {
            double d4 = d2 + (iViewport.y - d) * (lastX - d2) / (lastY - d);
            if (d4 > iViewport.x + iViewport.height) {
                polygon.addPoint(iViewport.getOL().x, iViewport.getOL().y);
                n = 2;
            } else if (d4 < iViewport.x) {
                polygon.addPoint(iViewport.getUL().x, iViewport.getUL().y);
                n = 8;
            }
        }
        if ((n & 4) != 0) {
            if ((n2 & 8) != 0) {
                polygon.addPoint(iViewport.getUR().x, iViewport.getUR().y);
            } else if ((n2 & 2) != 0) {
                polygon.addPoint(iViewport.getOR().x, iViewport.getOR().y);
            }
        } else if ((n & 1) != 0) {
            if ((n2 & 2) != 0) {
                polygon.addPoint(iViewport.getOL().x, iViewport.getOL().y);
            } else if ((n2 & 8) != 0) {
                polygon.addPoint(iViewport.getUL().x, iViewport.getUL().y);
            }
        }
        if ((n & 8) != 0) {
            if ((n2 & 1) != 0) {
                polygon.addPoint(iViewport.getUL().x, iViewport.getUL().y);
            } else if ((n2 & 4) != 0) {
                polygon.addPoint(iViewport.getUR().x, iViewport.getUR().y);
            }
        } else if ((n & 2) != 0) {
            if ((n2 & 4) != 0) {
                polygon.addPoint(iViewport.getOR().x, iViewport.getOR().y);
            } else if ((n2 & 1) != 0) {
                polygon.addPoint(iViewport.getOL().x, iViewport.getOL().y);
            }
        }
        lastY = d;
        lastX = d2;
        return n2;
    }
}

