/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.IColorizer;
import de.geocalc.awt.IColorizerSlider;
import de.geocalc.awt.IHashColorizerSlider;
import java.awt.Color;
import java.util.StringTokenizer;

public class IHashColorizer
extends IColorizer {
    protected int minHue = 0;
    protected int maxHue = 255;
    protected int minSaturation = 31;
    protected int maxSaturation = 180;
    protected int minBrightness = 220;
    protected int maxBrightness = 255;

    public IHashColorizer() {
    }

    public IHashColorizer(int n, int n2, int n3, int n4, int n5, int n6) {
        this.minHue = n;
        this.maxHue = n2;
        this.minSaturation = n3;
        this.maxSaturation = n4;
        this.minBrightness = n5;
        this.maxBrightness = n6;
    }

    @Override
    public Object clone() {
        IHashColorizer iHashColorizer = new IHashColorizer();
        this.copyParameters(iHashColorizer);
        return iHashColorizer;
    }

    @Override
    public void copyParameters(IColorizer iColorizer) {
        IHashColorizer iHashColorizer = (IHashColorizer)iColorizer;
        iHashColorizer.minHue = this.minHue;
        iHashColorizer.maxHue = this.maxHue;
        iHashColorizer.minSaturation = this.minSaturation;
        iHashColorizer.maxSaturation = this.maxSaturation;
        iHashColorizer.minBrightness = this.minBrightness;
        iHashColorizer.maxBrightness = this.maxBrightness;
    }

    public void setMinHue(int n) {
        this.minHue = this.normalize(n);
    }

    public int getMinHue() {
        return this.minHue;
    }

    public void setMaxHue(int n) {
        this.maxHue = this.normalize(n);
    }

    public int getMaxHue() {
        return this.maxHue;
    }

    public void setHue(int n, int n2) {
        this.setMinHue(n);
        this.setMaxHue(n2);
    }

    public void setMinSaturation(int n) {
        this.minSaturation = this.normalize(n);
    }

    public int getMinSaturation() {
        return this.minSaturation;
    }

    public void setMaxSaturation(int n) {
        this.maxSaturation = this.normalize(n);
    }

    public int getMaxSaturation() {
        return this.maxSaturation;
    }

    public void setSaturation(int n, int n2) {
        this.setMinSaturation(n);
        this.setMaxSaturation(n2);
    }

    public void setMinBrightness(int n) {
        this.minBrightness = this.normalize(n);
    }

    public int getMinBrightness() {
        return this.minBrightness;
    }

    public void setMaxBrightness(int n) {
        this.maxBrightness = this.normalize(n);
    }

    public int getMaxBrightness() {
        return this.maxBrightness;
    }

    public void setBrightness(int n, int n2) {
        this.setMinBrightness(n);
        this.setMaxBrightness(n2);
    }

    public Color getColor(int n) {
        int n2 = Math.max(1, this.maxHue - this.minHue);
        int n3 = Math.max(1, this.maxSaturation - this.minSaturation);
        int n4 = Math.max(1, this.maxBrightness - this.minBrightness);
        float f = (float)this.normalize(this.minHue + Math.abs(n * (n2 / 3 + 1) % n2)) / 255.0f;
        float f2 = (float)this.normalize(this.minSaturation + Math.abs(n * (n3 / 7 + 1) % n3)) / 255.0f;
        float f3 = (float)this.normalize(this.minBrightness + Math.abs(n * (n4 / 12 + 1) % n4)) / 255.0f;
        return Color.getHSBColor(f, f2, f3);
    }

    @Override
    public String getParameterString() {
        return this.minHue + "," + this.maxHue + "," + this.minSaturation + "," + this.maxSaturation + "," + this.minBrightness + "," + this.maxBrightness;
    }

    @Override
    public void parseParameterString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.hasMoreTokens()) {
            this.minHue = Integer.parseInt(stringTokenizer.nextToken());
        }
        if (stringTokenizer.hasMoreTokens()) {
            this.maxHue = Integer.parseInt(stringTokenizer.nextToken());
        }
        if (stringTokenizer.hasMoreTokens()) {
            this.minSaturation = Integer.parseInt(stringTokenizer.nextToken());
        }
        if (stringTokenizer.hasMoreTokens()) {
            this.maxSaturation = Integer.parseInt(stringTokenizer.nextToken());
        }
        if (stringTokenizer.hasMoreTokens()) {
            this.minBrightness = Integer.parseInt(stringTokenizer.nextToken());
        }
        if (stringTokenizer.hasMoreTokens()) {
            this.maxBrightness = Integer.parseInt(stringTokenizer.nextToken());
        }
    }

    @Override
    public IColorizerSlider getSlider() {
        return new IHashColorizerSlider(this);
    }

    private int normalize(int n) {
        n = Math.max(n, 0);
        n = Math.min(n, 255);
        return n;
    }
}

