/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.IColorBrightnessSlider;
import de.geocalc.awt.IColorHueSlider;
import de.geocalc.awt.IColorSaturationSlider;
import de.geocalc.awt.IColorizer;
import de.geocalc.awt.IColorizerSlider;
import de.geocalc.awt.IHashColorizer;
import java.awt.Adjustable;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;

public class IHashColorizerSlider
extends IColorizerSlider
implements Adjustable,
AdjustmentListener {
    private static final float SLIDER_WIDTH = 0.4f;
    private IHashColorizer colorizer;
    private AdjustmentListener adjustmentListener;
    private IColorHueSlider minHueSlider;
    private IColorHueSlider maxHueSlider;
    private IColorSaturationSlider minSatSlider;
    private IColorSaturationSlider maxSatSlider;
    private IColorBrightnessSlider minBrigSlider;
    private IColorBrightnessSlider maxBrigSlider;

    public IHashColorizerSlider() {
        this((IHashColorizer)null);
    }

    public IHashColorizerSlider(IHashColorizer iHashColorizer) {
        this.colorizer = iHashColorizer;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.setLayout(gridBagLayout);
        Label label = null;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        label = new Label("Auswahl des Farbspektrums:");
        this.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        label = new Label("Minimum:");
        this.add(label);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("Maximum:");
        this.add(label);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        label = new Label("Farbton:");
        this.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("S\u00e4ttigung:");
        this.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("Helligkeit:");
        this.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        int n = (iHashColorizer.getMinHue() + iHashColorizer.getMaxHue()) / 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.minHueSlider = new IColorHueSlider(0, 0.4f);
        this.add(this.minHueSlider);
        this.minHueSlider.setValue(iHashColorizer.getMinHue());
        this.minHueSlider.addAdjustmentListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.minHueSlider, gridBagConstraints);
        this.maxHueSlider = new IColorHueSlider(0, 0.4f);
        this.add(this.maxHueSlider);
        this.maxHueSlider.setValue(iHashColorizer.getMaxHue());
        this.maxHueSlider.addAdjustmentListener(this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.maxHueSlider, gridBagConstraints);
        this.minSatSlider = new IColorSaturationSlider(0, 0.4f);
        this.add(this.minSatSlider);
        this.minSatSlider.setValue(iHashColorizer.getMinSaturation());
        this.minSatSlider.setHue(n);
        this.minSatSlider.addAdjustmentListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.minSatSlider, gridBagConstraints);
        this.maxSatSlider = new IColorSaturationSlider(0, 0.4f);
        this.add(this.maxSatSlider);
        this.maxSatSlider.setValue(iHashColorizer.getMaxSaturation());
        this.maxSatSlider.setHue(n);
        this.maxSatSlider.addAdjustmentListener(this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.maxSatSlider, gridBagConstraints);
        this.minBrigSlider = new IColorBrightnessSlider(0, 0.4f);
        this.add(this.minBrigSlider);
        this.minBrigSlider.setValue(iHashColorizer.getMinBrightness());
        this.minBrigSlider.setHue(n);
        this.minBrigSlider.addAdjustmentListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.minBrigSlider, gridBagConstraints);
        this.maxBrigSlider = new IColorBrightnessSlider(0, 0.4f);
        this.add(this.maxBrigSlider);
        this.maxBrigSlider.setValue(iHashColorizer.getMaxBrightness());
        this.maxBrigSlider.setHue(n);
        this.maxBrigSlider.addAdjustmentListener(this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagLayout.setConstraints(this.maxBrigSlider, gridBagConstraints);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Object object = adjustmentEvent.getSource();
        if (object == this.minHueSlider || object == this.maxHueSlider) {
            if (object == this.minHueSlider && this.maxHueSlider.getValue() < this.minHueSlider.getValue()) {
                this.maxHueSlider.setValue(this.minHueSlider.getValue());
            }
            if (object == this.maxHueSlider && this.minHueSlider.getValue() > this.maxHueSlider.getValue()) {
                this.minHueSlider.setValue(this.maxHueSlider.getValue());
            }
            this.colorizer.setHue(this.minHueSlider.getValue(), this.maxHueSlider.getValue());
            int n = (this.minHueSlider.getValue() + this.maxHueSlider.getValue()) / 2;
            this.minSatSlider.setHue(n);
            this.maxSatSlider.setHue(n);
            this.minBrigSlider.setHue(n);
            this.maxBrigSlider.setHue(n);
        } else if (object == this.minSatSlider || object == this.maxSatSlider) {
            if (object == this.minSatSlider && this.maxSatSlider.getValue() < this.minSatSlider.getValue()) {
                this.maxSatSlider.setValue(this.minSatSlider.getValue());
            }
            if (object == this.maxSatSlider && this.minSatSlider.getValue() > this.maxSatSlider.getValue()) {
                this.minSatSlider.setValue(this.maxSatSlider.getValue());
            }
            this.colorizer.setSaturation(this.minSatSlider.getValue(), this.maxSatSlider.getValue());
        } else if (object == this.minBrigSlider || object == this.maxBrigSlider) {
            if (object == this.minBrigSlider && this.maxBrigSlider.getValue() < this.minBrigSlider.getValue()) {
                this.maxBrigSlider.setValue(this.minBrigSlider.getValue());
            }
            if (object == this.maxBrigSlider && this.minBrigSlider.getValue() > this.maxBrigSlider.getValue()) {
                this.minBrigSlider.setValue(this.maxBrigSlider.getValue());
            }
            this.colorizer.setBrightness(this.minBrigSlider.getValue(), this.maxBrigSlider.getValue());
        }
        if (this.adjustmentListener != null) {
            this.adjustmentListener.adjustmentValueChanged(adjustmentEvent);
        }
    }

    @Override
    public int getOrientation() {
        return 0;
    }

    @Override
    public void setMinimum(int n) {
    }

    @Override
    public int getMinimum() {
        return 0;
    }

    @Override
    public void setMaximum(int n) {
    }

    @Override
    public int getMaximum() {
        return 1;
    }

    @Override
    public void setUnitIncrement(int n) {
    }

    @Override
    public int getUnitIncrement() {
        return 1;
    }

    @Override
    public void setBlockIncrement(int n) {
    }

    @Override
    public int getBlockIncrement() {
        return 1;
    }

    @Override
    public void setVisibleAmount(int n) {
    }

    @Override
    public int getVisibleAmount() {
        return 1;
    }

    @Override
    public void setValue(int n) {
    }

    @Override
    public int getValue() {
        return 1;
    }

    @Override
    public void addAdjustmentListener(AdjustmentListener adjustmentListener) {
        this.adjustmentListener = adjustmentListener;
    }

    @Override
    public void removeAdjustmentListener(AdjustmentListener adjustmentListener) {
        if (this.adjustmentListener == adjustmentListener) {
            this.adjustmentListener = null;
        }
    }

    private void setColorizerParameter() {
    }

    @Override
    public void setColorizer(IColorizer iColorizer) {
    }
}

