/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.IDialog;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IPanel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;

public class IInfoDialog
extends IDialog
implements ActionListener {
    protected static final Color TEXT_COLOR_NORMAL = Color.black;
    protected static final Color TEXT_COLOR_UNUSED = Color.darkGray;
    protected static final Color TEXT_COLOR_CONFIRM = Color.green;
    protected static final Color TEXT_COLOR_MODIFY = Color.red;
    private static final String OK_COMMAND = "OK";
    protected String message;
    protected int align;

    public IInfoDialog(IFrame iFrame, String string, String string2) {
        this(iFrame, string, string2, 0);
    }

    public IInfoDialog(IFrame iFrame, String string, String string2, int n) {
        super(iFrame, string, true);
        this.message = string2;
        this.align = n;
        this.setLayout(new BorderLayout());
        this.add("North", this.createInfoPanel());
        this.add("South", this.createButtonPanel());
        this.pack();
        this.setLocationOfParent(iFrame);
        this.setResizable(false);
    }

    protected IPanel createInfoPanel() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.message, "\n");
        IPanel iPanel = new IPanel(new GridLayout(stringTokenizer.countTokens(), 1));
        IBorder iBorder = new IBorder(1);
        iPanel.setBorder(iBorder);
        while (stringTokenizer.hasMoreTokens()) {
            iPanel.add(new Label(stringTokenizer.nextToken(), this.align));
        }
        return iPanel;
    }

    private Panel createButtonPanel() {
        Panel panel = new Panel(new FlowLayout(1));
        Button button = new Button(OK_COMMAND);
        button.addActionListener(this);
        panel.add(button);
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(OK_COMMAND)) {
            this.endDialog();
        }
    }

    @Override
    protected void doStandardAction() {
        this.endDialog();
    }

    @Override
    protected void doAbortAction() {
        this.endDialog();
    }
}

