/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.IPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Label;

public class IInfoField
extends IPanel {
    private static final int STANDARD_LENGTH = 5;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int CENTER = 3;
    private Label infoLabel;
    private Dimension size;
    private int length = 5;

    public IInfoField() {
        this(null, 5, 1, 3);
    }

    public IInfoField(String string) {
        this(string, 5, 1, 3);
    }

    public IInfoField(int n) {
        this(null, n, 1, 3);
    }

    public IInfoField(int n, int n2) {
        this(null, n, n2, 3);
    }

    public IInfoField(int n, int n2, int n3) {
        this(null, n, n2, n3);
    }

    public IInfoField(String string, int n, int n2, int n3) {
        super(new BorderLayout(0, 0));
        this.length = n;
        this.setBorder(new IBorder(n3));
        this.infoLabel = new Label();
        switch (n2) {
            case 1: {
                this.infoLabel.setAlignment(0);
                break;
            }
            case 2: {
                this.infoLabel.setAlignment(2);
                break;
            }
            case 3: {
                this.infoLabel.setAlignment(1);
            }
        }
        this.setFont(new Font("Dialog", 1, 12));
        super.add("Center", this.infoLabel);
        this.setText(string);
    }

    private void computeBounds() {
        if (this.length <= 0) {
            this.length = 5;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.charWidth('0');
        this.infoLabel.setSize(n * this.length + 2, fontMetrics.getHeight());
        Insets insets = this.getBorder().getInsets();
        this.size = new Dimension(n * this.length + insets.left + insets.right + 2, fontMetrics.getHeight() + insets.top + insets.bottom);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.computeBounds();
    }

    public void setText(String string) {
        if (string != null) {
            this.infoLabel.setText(string);
        } else {
            this.infoLabel.setText("");
        }
    }

    public String getText() {
        return this.infoLabel.getText();
    }

    public void setTextColor(Color color) {
        this.infoLabel.setForeground(color);
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.setTextColor(color);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.size;
    }

    public void setPreferedSize() {
        this.setSize(this.size);
    }
}

