/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.IComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.SystemColor;

public class IInfoPanel
extends IComponent {
    public static final int LEFT = 1;
    public static final int CENTER = 2;
    public static final int RIGHT = 3;
    private static final Font DEFAULT_FONT = new Font("Serif", 0, 12);
    private String infoText;
    private IBorder border;
    private Dimension minSize = new Dimension();
    private Dimension prefSize = new Dimension();
    private int pos = 1;

    public IInfoPanel() {
        this(null, 0);
    }

    public IInfoPanel(int n) {
        this(null, n);
    }

    public IInfoPanel(String string) {
        this(string, 0);
    }

    public IInfoPanel(String string, int n) {
        this.border = new IBorder(3);
        Font font = this.getFont() != null ? this.getFont() : DEFAULT_FONT;
        FontMetrics fontMetrics = this.getFontMetrics(font);
        Insets insets = this.border.getInsets();
        this.minSize.height = insets.top + insets.bottom + fontMetrics.getHeight();
        this.minSize.width = n != 0 ? insets.left + insets.right + fontMetrics.charWidth('e') * n : (string != null ? insets.left + insets.right + fontMetrics.stringWidth(string) * n : insets.left + insets.right + fontMetrics.charWidth('e'));
        this.prefSize.width = this.minSize.width;
        this.prefSize.height = this.minSize.height;
        this.setText(string);
    }

    public void setAlignment(int n) {
        this.pos = n;
    }

    public int getAlignment() {
        return this.pos;
    }

    public void setStyle(int n) {
        Font font = this.getFont();
        if (font != null && font.getStyle() != n) {
            this.setFont(new Font(font.getFamily(), n, font.getSize()));
        }
    }

    public void setText(String string) {
        this.setText(string, SystemColor.textText);
    }

    public void setText(String string, Color color) {
        Object object;
        Font font = this.getFont() != null ? this.getFont() : DEFAULT_FONT;
        FontMetrics fontMetrics = this.getFontMetrics(font);
        this.setForeground(color);
        if (string != null) {
            object = this.border.getInsets();
            if (((Insets)object).left + ((Insets)object).right + fontMetrics.stringWidth(string) > this.minSize.width) {
                this.prefSize.width = ((Insets)object).left + ((Insets)object).right + fontMetrics.stringWidth(string);
            }
        }
        this.infoText = string;
        object = this.getGraphics();
        if (object != null) {
            this.update((Graphics)object);
        }
    }

    public void removeText(String string) {
        if (string != null && string.equals(this.infoText)) {
            this.setText(null);
        }
    }

    public String getText() {
        return this.infoText;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.prefSize;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.minSize;
    }

    @Override
    public void paint(Graphics graphics) {
        Font font = this.getFont() != null ? this.getFont() : DEFAULT_FONT;
        FontMetrics fontMetrics = this.getFontMetrics(font);
        Dimension dimension = this.getSize();
        Insets insets = this.border.getInsets();
        graphics.setColor(this.getBackground());
        graphics.setFont(this.getFont());
        if (this.border != null) {
            this.border.repaint(graphics, 0, 0, dimension.width, dimension.height);
        }
        graphics.fillRect(insets.left, insets.top, dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
        graphics.setClip(insets.left + 1, insets.top + 1, dimension.width - insets.left - insets.right - 1, dimension.height - insets.top - insets.bottom - 1);
        if (this.infoText != null) {
            graphics.setColor(this.getForeground());
            int n = 0;
            int n2 = dimension.height - insets.top - fontMetrics.getDescent() - 1;
            switch (this.pos) {
                case 2: {
                    n = (dimension.width - fontMetrics.stringWidth(this.infoText)) / 2;
                    break;
                }
                case 3: {
                    n = dimension.width - fontMetrics.stringWidth(this.infoText) - insets.right;
                    break;
                }
                default: {
                    n = insets.left + 2;
                }
            }
            graphics.drawString(this.infoText, n, n2);
        }
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

