/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.IInscriptionComponent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;

public class IInscription
extends Container {
    public static final int NORMAL = 0;
    public static final int DURCHGESTRICHEN = 1;
    Dimension size = null;
    Point bezug = new Point(0, 0);
    int orientation = 0;
    int rows;
    int cols;
    int[] width;
    int[] height;
    int[] xGrid;
    int[] yGrid;
    int min_bezug = 10;
    private Color color = Color.black;
    private int maxFontSize = 1;

    public IInscription() {
        this(new Point());
    }

    public IInscription(Point point) {
        this.bezug = point;
        super.setLocation(point.x, point.y);
    }

    public void add(IInscriptionComponent iInscriptionComponent) {
        super.add(iInscriptionComponent);
        this.rows = Math.max(this.rows, iInscriptionComponent.getGridY() + 1);
        this.cols = Math.max(this.cols, iInscriptionComponent.getGridX() + 1);
    }

    @Override
    public void doLayout() {
        this.size = this.getPreferredSize();
    }

    public Point getInsertPoint() {
        return this.bezug;
    }

    @Override
    public Dimension getSize() {
        if (this.size != null) {
            return this.size;
        }
        this.size = this.getPreferredSize();
        return this.size;
    }

    @Override
    public void setLocation(Point point) {
        this.setLocation(point.x, point.y);
    }

    public void setOrientation(int n) {
        this.orientation = n;
    }

    public void computeOrientation(int n, int n2) {
        if (this.size == null) {
            this.size = this.getSize();
        }
        this.orientation = 0;
        if (n > this.bezug.x) {
            this.orientation += -10;
        } else if (n + this.size.width < this.bezug.x) {
            this.orientation += 10;
        }
        if (n2 + this.size.height < this.bezug.y) {
            ++this.orientation;
        } else if (n2 > this.bezug.y) {
            this.orientation += -1;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int n;
        this.width = new int[this.cols];
        this.height = new int[this.rows];
        this.xGrid = new int[this.cols];
        this.yGrid = new int[this.rows];
        int n2 = this.getComponentCount();
        for (n = 0; n < n2; ++n) {
            IInscriptionComponent iInscriptionComponent = (IInscriptionComponent)this.getComponent(n);
            Dimension dimension = iInscriptionComponent.getPreferredSize();
            int n3 = iInscriptionComponent.getGridY();
            this.height[n3] = Math.max(this.height[n3], dimension.height);
            int n4 = iInscriptionComponent.getGridX();
            this.width[n4] = Math.max(this.width[n4], dimension.width);
            this.maxFontSize = Math.max(this.maxFontSize, iInscriptionComponent.getFont().getSize());
        }
        this.size = new Dimension();
        for (n = 0; n < this.rows; ++n) {
            this.yGrid[n] = this.size.height;
            this.size.height += this.height[n];
        }
        for (n = 0; n < this.cols; ++n) {
            this.xGrid[n] = this.size.width;
            this.size.width += this.width[n];
        }
        return this.size;
    }

    @Override
    public void setLocation(int n, int n2) {
        if (this.size == null) {
            this.size = this.getSize();
        }
        super.setLocation(n, n2);
        int n3 = this.getComponentCount();
        for (int i = 0; i < n3; ++i) {
            IInscriptionComponent iInscriptionComponent = (IInscriptionComponent)this.getComponent(i);
            iInscriptionComponent.setLocation(n + this.xGrid[iInscriptionComponent.getGridX()], n2 + this.yGrid[iInscriptionComponent.getGridY()]);
            iInscriptionComponent.setSize(this.width[iInscriptionComponent.getGridX()], this.height[iInscriptionComponent.getGridY()]);
        }
    }

    @Override
    public void printComponents(Graphics graphics) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            IInscriptionComponent iInscriptionComponent = (IInscriptionComponent)this.getComponent(i);
            iInscriptionComponent.paint(graphics);
        }
    }

    public void overwriteComponents(Graphics graphics) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            IInscriptionComponent iInscriptionComponent = (IInscriptionComponent)this.getComponent(i);
            graphics.setColor(this.getBackground());
            iInscriptionComponent.fill(graphics);
            graphics.setColor(this.getForeground());
            iInscriptionComponent.paint(graphics);
        }
        this.drawBezug(graphics);
    }

    private void drawBezug(Graphics graphics) {
        if (this.bezug.x == 0 && this.bezug.y == 0) {
            return;
        }
        Point point = this.getLocation();
        Dimension dimension = this.getSize();
        switch (this.orientation) {
            case 9: {
                point.x += dimension.width;
            }
            case -11: {
                break;
            }
            case 10: {
                point.x += dimension.width;
            }
            case -10: {
                point.y += dimension.height / 2;
                break;
            }
            case 11: {
                point.x += dimension.width;
            }
            case -9: {
                point.y += dimension.height;
                break;
            }
            case -1: {
                point.x += dimension.width / 2;
                break;
            }
            case 1: {
                point.x += dimension.width / 2;
                point.y += dimension.height;
                break;
            }
            case 0: {
                return;
            }
        }
        if ((int)Math.sqrt((point.x - this.bezug.x) * (point.x - this.bezug.x) + (point.y - this.bezug.y) * (point.y - this.bezug.y)) > this.min_bezug) {
            graphics.setColor(this.color);
            if (graphics instanceof Graphics2D) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                Stroke stroke = graphics2D.getStroke();
                BasicStroke basicStroke = new BasicStroke((float)this.maxFontSize / 50.0f);
                graphics2D.setStroke(basicStroke);
                graphics.drawLine(point.x, point.y, this.bezug.x, this.bezug.y);
                graphics2D.setStroke(stroke);
            } else {
                graphics.drawLine(point.x, point.y, this.bezug.x, this.bezug.y);
            }
        }
    }
}

