/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.ILocation;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.util.StringTokenizer;

public class IInscriptionComponent
extends Component {
    private static final Font STANDARD_FONT = new Font("SansSerif", 0, 12);
    private String text = null;
    private int effekt = 0;
    private int gridx;
    private int gridy;
    private int orientation = 0;
    private Dimension prefSize = null;
    private boolean isTextVisible = true;
    int hBorder = 2;
    int vBorder = 2;

    public IInscriptionComponent(String string, int n, int n2) {
        this(string, 0, n, n2);
    }

    public IInscriptionComponent(String string, int n, int n2, int n3) {
        this.text = string;
        this.effekt = n;
        this.gridx = n2;
        this.gridy = n3;
    }

    public String getText() {
        return this.text;
    }

    public int getGridX() {
        return this.gridx;
    }

    public int getGridY() {
        return this.gridy;
    }

    public void setOrientation(int n) {
        this.orientation = n;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setTextVisible(boolean bl) {
        this.isTextVisible = bl;
    }

    @Override
    public Dimension getPreferredSize() {
        this.prefSize = this.computeSize();
        return this.prefSize;
    }

    private Dimension computeSize() {
        Dimension dimension = new Dimension();
        if (this.text != null) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            this.hBorder = fontMetrics.charWidth(' ') / 2;
            this.vBorder = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(this.text, "\n\t", true);
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                if (string.equals("\n")) continue;
                if (string.equals("\t")) {
                    dimension.height += fontMetrics.getHeight() / 12 + 2 * this.vBorder;
                    continue;
                }
                dimension.width = Math.max(dimension.width, fontMetrics.stringWidth(string) + this.hBorder * 2);
                dimension.height += fontMetrics.getAscent() + fontMetrics.getDescent() + 2 * this.vBorder;
            }
        }
        return dimension;
    }

    @Override
    public Font getFont() {
        Font font = super.getFont();
        if (font != null) {
            return font;
        }
        return STANDARD_FONT;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.computeSize();
    }

    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.getFont());
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        if (this.prefSize == null) {
            this.prefSize = this.getPreferredSize();
        }
        Point point = this.getLocation();
        Dimension dimension = this.getSize();
        int n2 = point.y;
        int n3 = ILocation.getVertical(this.orientation);
        if (n3 == 0) {
            n2 += (dimension.height - this.prefSize.height) / 2;
        } else if (n3 == 1) {
            n2 += dimension.height - this.prefSize.height;
        }
        int n4 = n = point.x;
        int n5 = n2;
        Font font = this.getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = this.getFontMetrics(font);
        graphics.setColor(this.getForeground());
        if (this.text != null && this.isTextVisible) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.text, "\n\t", true);
            while (stringTokenizer.hasMoreTokens()) {
                int n6;
                int n7;
                String string = stringTokenizer.nextToken();
                if (string.equals("\n")) continue;
                if (string.equals("\t")) {
                    n2 += this.vBorder;
                    n7 = 0;
                    n6 = ILocation.getHorizontal(this.orientation);
                    if (n6 == 0) {
                        n7 = (dimension.width - this.prefSize.width) / 2 + this.hBorder;
                    } else if (n6 == 10) {
                        n7 = dimension.width - this.prefSize.width - this.hBorder;
                    }
                    for (int i = 0; i <= fontMetrics.getHeight() / 12; ++i) {
                        graphics.drawLine(n + n7, n2 + i, n + n7 + this.prefSize.width, n2 + i);
                    }
                    n2 += fontMetrics.getHeight() / 12;
                    n2 += this.vBorder;
                    continue;
                }
                n7 = 0;
                n6 = ILocation.getHorizontal(this.orientation);
                n7 = n6 == 0 ? (dimension.width - fontMetrics.stringWidth(string)) / 2 + this.hBorder : (n6 == 10 ? dimension.width - fontMetrics.stringWidth(string) - this.hBorder : this.hBorder);
                graphics.drawString(string, n + n7, n2 += fontMetrics.getAscent() + this.vBorder);
                n2 += fontMetrics.getDescent() + this.vBorder;
            }
        }
        switch (this.effekt) {
            case 1: {
                int n8 = 0;
                int n9 = ILocation.getHorizontal(this.orientation);
                if (n9 == 0) {
                    n8 = (dimension.width - this.prefSize.width) / 2 + this.hBorder;
                } else if (n9 == 10) {
                    n8 = dimension.width - this.prefSize.width - this.hBorder;
                }
                graphics.drawLine(n4 + n8, n5 + this.prefSize.height - this.vBorder, n4 + n8 + this.prefSize.width, n5 + this.vBorder);
            }
        }
    }

    public void fill(Graphics graphics) {
        int n;
        if (this.prefSize == null) {
            this.prefSize = this.getPreferredSize();
        }
        Point point = this.getLocation();
        Dimension dimension = this.getSize();
        int n2 = point.y;
        int n3 = ILocation.getVertical(this.orientation);
        if (n3 == 0) {
            n2 += (dimension.height - this.prefSize.height) / 2;
        } else if (n3 == 1) {
            n2 += dimension.height - this.prefSize.height;
        }
        int n4 = n = point.x;
        int n5 = n2;
        Font font = this.getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        if (this.text != null && this.isTextVisible) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.text, "\n\t", true);
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                if (string.equals("\n")) continue;
                if (string.equals("\t")) {
                    n2 += this.vBorder;
                    n2 += fontMetrics.getHeight() / 12;
                    n2 += this.vBorder;
                    continue;
                }
                n2 += fontMetrics.getAscent() + this.vBorder;
                int n6 = 0;
                int n7 = ILocation.getHorizontal(this.orientation);
                int n8 = fontMetrics.stringWidth(string);
                n6 = n7 == 0 ? (dimension.width - n8) / 2 + this.hBorder : (n7 == 10 ? dimension.width - n8 - this.hBorder : this.hBorder);
                int n9 = (int)Math.rint((double)fontMetrics.getAscent() * 0.6);
                graphics.fillRect(n + n6 - 1, n2 + 2, n8 + 2, -n9 - 4);
                n2 += fontMetrics.getDescent() + this.vBorder;
            }
        }
    }

    private boolean hasDescentChars(String string) {
        for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '(': 
                case ')': 
                case 'g': 
                case 'j': 
                case 'p': 
                case 'q': 
                case 'y': {
                    return true;
                }
            }
        }
        return false;
    }
}

