/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import java.awt.AWTEventMulticaster;
import java.awt.CheckboxMenuItem;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public abstract class IMainMenu
extends MenuBar
implements ActionListener,
ItemListener {
    public static final int DATA_CLOSE = -1;
    public static final int DATA_EMPTY = 0;
    public static final int DATA_ONLY_POINTS = 1;
    public static final int DATA_FULL = 2;
    protected ActionListener actionListener;
    private int state = 0;

    public IMainMenu() {
        this.createMenu();
    }

    public void setState(int n) {
        this.state = n;
    }

    public int getState() {
        return this.state;
    }

    protected abstract void createMenu();

    protected MenuItem addMenuItem(String string, ActionListener actionListener) {
        MenuItem menuItem = new MenuItem(string);
        menuItem.addActionListener(actionListener);
        return menuItem;
    }

    protected MenuItem addMenuItem(String string, int n, ActionListener actionListener) {
        MenuShortcut menuShortcut = new MenuShortcut(n);
        MenuItem menuItem = new MenuItem(string, menuShortcut);
        menuItem.setActionCommand(string);
        menuItem.addActionListener(actionListener);
        return menuItem;
    }

    protected CheckboxMenuItem addCheckboxMenuItem(String string, ActionListener actionListener) {
        CheckboxMenuItem checkboxMenuItem = new CheckboxMenuItem(string);
        checkboxMenuItem.addActionListener(actionListener);
        checkboxMenuItem.addItemListener(this);
        return checkboxMenuItem;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(actionEvent);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(new ActionEvent(this, 1001, (String)itemEvent.getItem()));
            }
        } else if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, (String)itemEvent.getItem(), 8));
        }
    }
}

