/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.ICheckboxButton;
import de.geocalc.awt.IDialog;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.event.IOptionEvent;
import de.geocalc.awt.event.IOptionListener;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public abstract class IOptionDialog
extends IDialog
implements ActionListener,
ItemListener,
TextListener,
AdjustmentListener,
IOptionListener {
    protected static final int OK = 1;
    protected static final int DO = 2;
    protected static final int ABORT = 4;
    protected static final String OK_COMMAND = "OK";
    protected static final String DO_COMMAND = "\u00dcbernehmen";
    protected static final String ABORT_COMMAND = "Abbrechen";
    protected static final String DETAIL_COMMAND = "Details";
    protected static final String DIRECT_COMMAND = "_direct";
    private Button okButton;
    private Button doButton;
    private Button abortButton;
    private ICheckboxButton directCheckbox;
    private int buttons = 1;
    private Object optionObject = null;
    private boolean allButtons = true;
    static Insets INSETS = new Insets(0, 5, 5, 5);

    public IOptionDialog(IFrame iFrame, String string) {
        this(iFrame, string, true, (Object)null);
    }

    public IOptionDialog(IFrame iFrame, String string, Object object) {
        this(iFrame, string, true, object);
    }

    public IOptionDialog(IFrame iFrame, String string, boolean bl) {
        this(iFrame, string, bl ? 7 : 1, null);
    }

    public IOptionDialog(IFrame iFrame, String string, boolean bl, Object object) {
        this(iFrame, string, bl ? 7 : 1, object);
    }

    public IOptionDialog(IFrame iFrame, String string, int n) {
        this(iFrame, string, n, null);
    }

    public IOptionDialog(IFrame iFrame, String string, int n, Object object) {
        super(iFrame, string, true);
        this.buttons = n;
        this.optionObject = object;
        this.createLayout();
        this.checkLayout();
    }

    protected Object getOptionObject() {
        return this.optionObject;
    }

    protected void createLayout() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        IDialogPanel iDialogPanel = new IDialogPanel(gridBagLayout);
        Panel panel = null;
        Panel panel2 = null;
        panel = this.layoutDialogPanel();
        iDialogPanel.add(panel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        this.directCheckbox = new ICheckboxButton(2003, DIRECT_COMMAND);
        iDialogPanel.add(this.directCheckbox);
        this.directCheckbox.addActionListener(this);
        this.directCheckbox.setToolTipText("Einstellungen sofort anwenden");
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.directCheckbox, gridBagConstraints);
        panel2 = this.layoutButtonPanel();
        iDialogPanel.add(panel2);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(panel2, gridBagConstraints);
        this.add(iDialogPanel);
        this.pack();
        this.setLocationOfParent(this.parent);
        this.setResizable(false);
        this.directCheckbox.setVisible(false);
    }

    protected void setDirectlyActivatable(boolean bl) {
        this.directCheckbox.setVisible(bl);
    }

    protected void setDirectlyActivatable(boolean bl, boolean bl2) {
        this.setDirectlyActivatable(bl);
        this.directCheckbox.setState(bl2);
    }

    protected boolean isDirectlyActivatable() {
        return this.directCheckbox.isVisible();
    }

    protected void setDirectly(boolean bl) {
        this.directCheckbox.setState(bl);
    }

    protected boolean isDirectly() {
        return this.directCheckbox.getState();
    }

    protected void checkLayout() {
    }

    protected void updateLayout() {
    }

    protected abstract Panel layoutDialogPanel();

    protected Panel layoutButtonPanel() {
        Panel panel = new Panel(new FlowLayout((this.buttons & 4) != 0 ? 2 : 1));
        if ((this.buttons & 1) != 0) {
            this.okButton = new Button(OK_COMMAND);
            this.okButton.addActionListener(this);
            panel.add(this.okButton);
        }
        if ((this.buttons & 2) != 0) {
            this.doButton = new Button(DO_COMMAND);
            this.doButton.addActionListener(this);
            this.doButton.setEnabled(false);
            panel.add(this.doButton);
        }
        if ((this.buttons & 4) != 0) {
            this.abortButton = new Button(ABORT_COMMAND);
            this.abortButton.addActionListener(this);
            panel.add(this.abortButton);
        }
        return panel;
    }

    protected void setButtonEnabled(String string, boolean bl) {
        if (string.equals(OK_COMMAND)) {
            this.okButton.setEnabled(bl);
        } else if (string.equals(DO_COMMAND)) {
            this.doButton.setEnabled(bl);
        } else if (string.equals(ABORT_COMMAND)) {
            this.abortButton.setEnabled(bl);
        }
    }

    protected abstract void setOptions();

    protected void itemStateChanged() {
        if (this.doButton != null) {
            this.doButton.setEnabled(true);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.doButton != null) {
            this.doButton.setEnabled(true);
        }
    }

    @Override
    public void textValueChanged(TextEvent textEvent) {
        if (this.doButton != null) {
            this.doButton.setEnabled(true);
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (this.doButton != null) {
            this.doButton.setEnabled(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(OK_COMMAND)) {
            this.doStandardAction();
            this.endDialog();
        } else if (string.equals(DO_COMMAND)) {
            this.doStandardAction();
        } else if (string.equals(ABORT_COMMAND)) {
            this.doAbortAction();
            this.endDialog();
        } else if (string.equals(DIRECT_COMMAND)) {
            this.setDirectly(this.directCheckbox.getState());
        }
    }

    @Override
    public void optionsUpdated(IOptionEvent iOptionEvent) {
        this.updateLayout();
    }

    @Override
    protected void doStandardAction() {
        this.setOptions();
        if (this.doButton != null) {
            this.doButton.setEnabled(false);
        }
        this.returnType = 1;
        if (this.actionListener != null && this.actionCommand != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
        }
    }

    @Override
    protected void doAbortAction() {
        this.returnType = 0;
    }

    private class IDialogPanel
    extends Panel {
        public IDialogPanel(LayoutManager layoutManager) {
            super(layoutManager);
        }

        @Override
        public Insets getInsets() {
            return INSETS;
        }
    }
}

