/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.IBorder;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.event.KeyListener;

public class IPanel
extends Panel {
    private IBorder border;

    public IPanel() {
        this(new FlowLayout());
    }

    public IPanel(LayoutManager layoutManager) {
        this.setLayout(layoutManager);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.border.setEnabled(bl);
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            this.getComponent(i).addKeyListener(keyListener);
        }
        super.addKeyListener(keyListener);
    }

    @Override
    public Insets getInsets() {
        if (this.border != null) {
            return this.border.getInsets();
        }
        return new Insets(0, 0, 0, 0);
    }

    public void setBorder(IBorder iBorder) {
        this.border = iBorder;
    }

    public IBorder getBorder() {
        return this.border;
    }

    public void setBorderSize(int n) {
        if (this.border != null) {
            this.border.setBorderSize(n);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.border != null) {
            this.border.repaint(graphics, 0, 0, this.getSize().width, this.getSize().height);
        }
    }

    @Override
    public void repaint() {
        this.update(this.getGraphics());
    }
}

