/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.IBorder;
import de.geocalc.awt.IDialog;
import de.geocalc.awt.IFrame;
import de.geocalc.awt.IPanel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;

public class IPasswordDialog
extends IDialog
implements ActionListener {
    private static final String OK_COMMAND = "OK";
    protected String message;
    protected String username;
    protected String password;
    protected int align;
    protected TextField usernameTextField;
    protected TextField passwordTextField;

    public IPasswordDialog(IFrame iFrame, String string, String string2) {
        this(iFrame, string, string2, 0);
    }

    public IPasswordDialog(IFrame iFrame, String string, String string2, int n) {
        super(iFrame, string, true);
        this.message = string2;
        this.align = n;
        this.setLayout(new BorderLayout());
        this.add("North", this.createInfoPanel());
        this.add("South", this.createButtonPanel());
        this.pack();
        this.setLocationOfParent(iFrame);
        this.setResizable(false);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setUsername(String string) {
        this.username = string;
        this.usernameTextField.setText(string);
    }

    public void setPassword(String string) {
        this.password = string;
        this.passwordTextField.setText(string);
    }

    protected IPanel createInfoPanel() {
        Label label;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 17;
        IPanel iPanel = new IPanel(gridBagLayout);
        iPanel.setBorder(new IBorder(1));
        int n = 0;
        if (this.message != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.message, "\n");
            while (stringTokenizer.hasMoreTokens()) {
                label = new Label(stringTokenizer.nextToken(), this.align);
                iPanel.add(label);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = n++;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 1;
                gridBagConstraints.gridwidth = 2;
                gridBagLayout.setConstraints(label, gridBagConstraints);
            }
        }
        label = new Label("Benutzername:", 0);
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.usernameTextField = new TextField("", 20);
        iPanel.add(this.usernameTextField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.usernameTextField, gridBagConstraints);
        label = new Label("Passwort:", 0);
        iPanel.add(label);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.passwordTextField = new TextField("", 20);
        iPanel.add(this.passwordTextField);
        this.passwordTextField.setEchoChar('*');
        this.passwordTextField.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.passwordTextField, gridBagConstraints);
        return iPanel;
    }

    private Panel createButtonPanel() {
        Panel panel = new Panel(new FlowLayout(1));
        Button button = new Button(OK_COMMAND);
        button.addActionListener(this);
        panel.add(button);
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(OK_COMMAND) || actionEvent.getSource() == this.passwordTextField) {
            this.doStandardAction();
        }
    }

    @Override
    protected void doStandardAction() {
        this.username = this.usernameTextField.getText();
        this.password = this.passwordTextField.getText();
        this.endDialog();
    }

    @Override
    protected void doAbortAction() {
        this.endDialog();
    }
}

