/*
 * Decompiled with CFR 0.152.
 */
package de.geocalc.awt;

import de.geocalc.awt.IButton;
import de.geocalc.geom.DPoint;
import java.awt.AWTEventMulticaster;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;

public class IPositioner
extends Panel
implements ActionListener {
    private static final String NORTH_COMMAND = "NORTH";
    private static final String WEST_COMMAND = "WEST";
    private static final String EAST_COMMAND = "EAST";
    private static final String SOUTH_COMMAND = "SOUTH";
    private static final String LEFT_COMMAND = "LEFT";
    private static final String RIGHT_COMMAND = "RIGHT";
    private static final String OFFSET_COMMAND = "OFFSET";
    private ActionListener actionListener = null;
    private IButton offsetButton;
    private double minOffset = 0.0;
    private double maxOffset = 0.0;
    private double startOffset = 0.0;
    private double offset = 0.0;
    private DecimalFormat offsetFormat = new DecimalFormat("#0.0");
    private DPoint vector = new DPoint(0.0, 0.0);
    private double rotate = 0.0;
    private String actionCommand;

    public IPositioner(double d, double d2, double d3, DecimalFormat decimalFormat, String string, boolean bl) {
        this.minOffset = d;
        this.maxOffset = d2;
        this.startOffset = d3;
        this.offset = d3;
        this.offsetFormat = decimalFormat;
        this.actionCommand = string;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.setLayout(gridBagLayout);
        IButton iButton = null;
        iButton = new IButton(1102, NORTH_COMMAND);
        this.add(iButton);
        iButton.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(iButton, gridBagConstraints);
        iButton = new IButton(1104, WEST_COMMAND);
        this.add(iButton);
        iButton.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(iButton, gridBagConstraints);
        if (d != d2) {
            this.offsetButton = new IButton(this.offsetFormat.format(this.offset), OFFSET_COMMAND);
            this.add(this.offsetButton);
            this.offsetButton.addActionListener(this);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagLayout.setConstraints(this.offsetButton, gridBagConstraints);
        }
        iButton = new IButton(1106, EAST_COMMAND);
        this.add(iButton);
        iButton.addActionListener(this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(iButton, gridBagConstraints);
        iButton = new IButton(1108, SOUTH_COMMAND);
        this.add(iButton);
        iButton.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(iButton, gridBagConstraints);
        if (bl) {
            iButton = new IButton(1207, LEFT_COMMAND);
            this.add(iButton);
            iButton.addActionListener(this);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagLayout.setConstraints(iButton, gridBagConstraints);
            iButton = new IButton(1203, RIGHT_COMMAND);
            this.add(iButton);
            iButton.addActionListener(this);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            gridBagLayout.setConstraints(iButton, gridBagConstraints);
            iButton = new IButton(1201, RIGHT_COMMAND);
            this.add(iButton);
            iButton.addActionListener(this);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagLayout.setConstraints(iButton, gridBagConstraints);
            iButton = new IButton(1205, LEFT_COMMAND);
            this.add(iButton);
            iButton.addActionListener(this);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 2;
            gridBagLayout.setConstraints(iButton, gridBagConstraints);
        }
    }

    public boolean hasShift() {
        return !this.vector.isNull();
    }

    public DPoint getShift() {
        return this.vector;
    }

    public boolean hasRotate() {
        return this.rotate != 0.0;
    }

    public double getRotate() {
        return this.rotate;
    }

    public void reset() {
        this.vector.setNull();
        this.rotate = 0.0;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(100, 100);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(OFFSET_COMMAND)) {
            this.offset = (actionEvent.getModifiers() & 4) != 0 ? Math.max(this.minOffset, this.offset / 2.0) : ((actionEvent.getModifiers() & 8) != 0 ? (this.offset >= this.maxOffset ? this.minOffset : (this.offset <= this.minOffset ? this.startOffset : this.maxOffset)) : Math.min(this.maxOffset, this.offset * 2.0));
            this.offsetButton.setText(this.offsetFormat.format(this.offset));
        } else if (string.equals(NORTH_COMMAND)) {
            this.vector.x += this.offset;
        } else if (string.equals(WEST_COMMAND)) {
            this.vector.y -= this.offset;
        } else if (string.equals(EAST_COMMAND)) {
            this.vector.y += this.offset;
        } else if (string.equals(SOUTH_COMMAND)) {
            this.vector.x -= this.offset;
        } else if (string.equals(RIGHT_COMMAND)) {
            this.rotate += this.offset;
        } else if (string.equals(LEFT_COMMAND)) {
            this.rotate -= this.offset;
        }
        if (!string.equals(OFFSET_COMMAND) && this.actionListener != null && this.actionCommand != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.actionCommand, actionEvent.getModifiers()));
        }
    }
}

